/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.recipes.FluidKey;
import gregtech.api.recipes.KeySharedStack;
import gregtech.api.util.ItemStackKey;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class GTHashMaps {
    public static Map<ItemStackKey, Integer> fromItemHandler(IItemHandler inputs) {
        Object2IntLinkedOpenHashMap map = new Object2IntLinkedOpenHashMap();
        for (int i = 0; i < inputs.getSlots(); ++i) {
            ItemStack stack = inputs.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ItemStackKey key = KeySharedStack.getRegisteredStack(stack);
            map.put((Object)key, map.getInt((Object)key) + stack.func_190916_E());
        }
        return map;
    }

    public static Map<ItemStackKey, Integer> fromItemStackCollection(Iterable<ItemStack> inputs) {
        Object2IntLinkedOpenHashMap map = new Object2IntLinkedOpenHashMap();
        for (ItemStack stack : inputs) {
            if (stack.func_190926_b()) continue;
            ItemStackKey key = KeySharedStack.getRegisteredStack(stack);
            map.put((Object)key, map.getInt((Object)key) + stack.func_190916_E());
        }
        return map;
    }

    public static Map<FluidKey, Integer> fromFluidHandler(IFluidHandler fluidInputs) {
        Object2IntLinkedOpenHashMap map = new Object2IntLinkedOpenHashMap();
        for (int i = 0; i < fluidInputs.getTankProperties().length; ++i) {
            FluidStack fluidStack = fluidInputs.getTankProperties()[i].getContents();
            if (fluidStack == null || fluidStack.amount <= 0) continue;
            FluidKey key = new FluidKey(fluidStack);
            map.put((Object)key, map.getInt((Object)key) + fluidStack.amount);
        }
        return map;
    }

    public static Map<FluidKey, Integer> fromFluidCollection(Collection<FluidStack> fluidInputs) {
        Object2IntLinkedOpenHashMap map = new Object2IntLinkedOpenHashMap();
        for (FluidStack fluidStack : fluidInputs) {
            if (fluidStack == null || fluidStack.amount <= 0) continue;
            FluidKey key = new FluidKey(fluidStack);
            map.put((Object)key, map.getInt((Object)key) + fluidStack.amount);
        }
        return map;
    }
}

