/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.properties;

import gregtech.api.unification.material.properties.FluidProperty;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;

public class DustProperty
implements IMaterialProperty<DustProperty> {
    private int harvestLevel;
    private int burnTime;

    public DustProperty(int harvestLevel, int burnTime) {
        this.harvestLevel = harvestLevel;
        this.burnTime = burnTime;
    }

    public DustProperty() {
        this(2, 0);
    }

    public void setHarvestLevel(int harvestLevel) {
        if (harvestLevel <= 0) {
            throw new IllegalArgumentException("Harvest Level must be greater than zero!");
        }
        this.harvestLevel = harvestLevel;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public void setBurnTime(int burnTime) {
        if (burnTime < 0) {
            throw new IllegalArgumentException("Burn Time cannot be negative!");
        }
        this.burnTime = burnTime;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    @Override
    public void verifyProperty(MaterialProperties properties) {
        FluidProperty prop = properties.getProperty(PropertyKey.FLUID);
        if (prop != null && prop.getFluidTemperature() == 293) {
            prop.setFluidTemperature(1200);
        }
    }
}

