/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.zenscript.IBracketHandler;
import gregtech.api.GregTechAPI;
import gregtech.api.unification.material.Material;
import java.util.List;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;

@BracketHandler
@ZenRegister
public class MaterialBracketHandler
implements IBracketHandler {
    private final IJavaMethod method = CraftTweakerAPI.getJavaMethod(MaterialBracketHandler.class, (String)"getMaterial", (Class[])new Class[]{String.class});

    public static Material getMaterial(String name) {
        Material material;
        Material material2 = material = name == null ? null : GregTechAPI.MaterialRegistry.get(name);
        if (material == null) {
            CraftTweakerAPI.logError((String)("Could not find material with name " + name));
        }
        return material;
    }

    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        if (tokens.size() < 3) {
            return null;
        }
        if (!tokens.get(0).getValue().equalsIgnoreCase("material")) {
            return null;
        }
        if (!tokens.get(1).getValue().equals(":")) {
            return null;
        }
        StringBuilder nameBuilder = new StringBuilder();
        for (int i = 2; i < tokens.size(); ++i) {
            nameBuilder.append(tokens.get(i).getValue());
        }
        return position -> new ExpressionCallStatic(position, environment, this.method, new Expression[]{new ExpressionString(position, nameBuilder.toString())});
    }
}

