/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal;

import gregtech.api.terminal.CTTerminalRegistry;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.hardware.Hardware;
import gregtech.api.util.FileUtility;
import gregtech.api.util.GTLog;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import gregtech.common.terminal.app.VirtualTankApp;
import gregtech.common.terminal.app.appstore.AppStoreApp;
import gregtech.common.terminal.app.batterymanager.BatteryManagerApp;
import gregtech.common.terminal.app.capeselector.CapeSelectorApp;
import gregtech.common.terminal.app.console.ConsoleApp;
import gregtech.common.terminal.app.game.maze.MazeApp;
import gregtech.common.terminal.app.game.minesweeper.MinesweeperApp;
import gregtech.common.terminal.app.game.pong.PongApp;
import gregtech.common.terminal.app.guide.ItemGuideApp;
import gregtech.common.terminal.app.guide.MultiBlockGuideApp;
import gregtech.common.terminal.app.guide.SimpleMachineGuideApp;
import gregtech.common.terminal.app.guide.TutorialGuideApp;
import gregtech.common.terminal.app.guideeditor.GuideEditorApp;
import gregtech.common.terminal.app.hardwaremanager.HardwareManagerApp;
import gregtech.common.terminal.app.multiblockhelper.MultiBlockPreviewARApp;
import gregtech.common.terminal.app.prospector.ProspectorApp;
import gregtech.common.terminal.app.recipechart.RecipeChartApp;
import gregtech.common.terminal.app.settings.SettingsApp;
import gregtech.common.terminal.app.teleport.TeleportApp;
import gregtech.common.terminal.app.worldprospector.WorldProspectorARApp;
import gregtech.common.terminal.hardware.BatteryHardware;
import gregtech.common.terminal.hardware.DeviceHardware;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TerminalRegistry {
    protected static final Map<String, AbstractApplication> APP_REGISTER = new LinkedHashMap<String, AbstractApplication>();
    protected static final Map<String, Hardware> HW_REGISTER = new LinkedHashMap<String, Hardware>();
    protected static final Map<String, List<Hardware>[]> APP_HW_DEMAND = new HashMap<String, List<Hardware>[]>();
    protected static final Map<String, List<ItemStack>[]> APP_UPGRADE_CONDITIONS = new HashMap<String, List<ItemStack>[]>();
    protected static final List<String> DEFAULT_APPS = new ArrayList<String>();
    @SideOnly(value=Side.CLIENT)
    public static File TERMINAL_PATH;

    public static void init() {
        TerminalRegistry.registerHardware(new BatteryHardware());
        int deviceSize = DeviceHardware.DEVICE.values().length;
        for (int i = 1; i < deviceSize; ++i) {
            TerminalRegistry.registerHardware(new DeviceHardware(i));
        }
        AppRegistryBuilder.create(new SimpleMachineGuideApp()).defaultApp().build();
        AppRegistryBuilder.create(new MultiBlockGuideApp()).defaultApp().build();
        AppRegistryBuilder.create(new ItemGuideApp()).defaultApp().build();
        AppRegistryBuilder.create(new TutorialGuideApp()).defaultApp().build();
        AppRegistryBuilder.create(new GuideEditorApp()).defaultApp().build();
        AppRegistryBuilder.create(new SettingsApp()).defaultApp().build();
        AppRegistryBuilder.create(new TeleportApp()).battery(7, 10000L).device(DeviceHardware.DEVICE.FIELD_GENERATOR_UV).build();
        AppRegistryBuilder.create(new PongApp()).battery(1, 75L).build();
        AppRegistryBuilder.create(new MazeApp()).battery(1, 150L).build();
        AppRegistryBuilder.create(new MinesweeperApp()).battery(1, 150L).build();
        AppRegistryBuilder.create(new ProspectorApp(0)).battery(0, 1, 640L).battery(1, 1, 640L).battery(2, 2, 1000L).battery(3, 3, 1500L).battery(4, 3, 1500L).upgrade(0, MetaItems.SENSOR_LV.getStackForm(1)).upgrade(1, MetaItems.SENSOR_HV.getStackForm(1)).upgrade(2, MetaItems.SENSOR_EV.getStackForm(1)).upgrade(3, MetaItems.SENSOR_IV.getStackForm(1)).upgrade(4, MetaItems.SENSOR_LuV.getStackForm(1)).device(0, DeviceHardware.DEVICE.PROSPECTOR_LV).device(1, DeviceHardware.DEVICE.PROSPECTOR_LV).device(2, DeviceHardware.DEVICE.PROSPECTOR_LV).device(3, DeviceHardware.DEVICE.PROSPECTOR_HV).device(4, DeviceHardware.DEVICE.PROSPECTOR_HV).build();
        AppRegistryBuilder.create(new ProspectorApp(1)).battery(0, 2, 1000L).battery(1, 2, 1000L).battery(2, 3, 1500L).battery(3, 3, 1500L).battery(4, 3, 1500L).upgrade(0, MetaItems.SENSOR_HV.getStackForm(1)).upgrade(1, MetaItems.SENSOR_HV.getStackForm(3)).upgrade(2, MetaItems.SENSOR_EV.getStackForm(1)).upgrade(3, MetaItems.SENSOR_IV.getStackForm(1)).upgrade(4, MetaItems.SENSOR_LuV.getStackForm(1)).device(DeviceHardware.DEVICE.PROSPECTOR_HV).build();
        AppRegistryBuilder.create(new MultiBlockPreviewARApp()).battery(1, 128L).device(DeviceHardware.DEVICE.CAMERA).upgrade(1, MetaItems.EMITTER_HV.getStackForm(4), MetaItems.WORKSTATION_EV.getStackForm(2)).defaultApp().build();
        if (Loader.isModLoaded((String)"jei")) {
            AppRegistryBuilder.create(new RecipeChartApp()).battery(1, 160L).upgrade(0, new ItemStack(Items.field_151121_aF, 32)).upgrade(1, new ItemStack(Items.field_151121_aF, 64)).upgrade(2, MetaItems.RANDOM_ACCESS_MEMORY.getStackForm(16)).upgrade(3, MetaItems.RANDOM_ACCESS_MEMORY.getStackForm(32)).build();
        }
        AppRegistryBuilder.create(new ConsoleApp()).battery(1, 500L).device(DeviceHardware.DEVICE.WIRELESS).build();
        AppRegistryBuilder.create(new BatteryManagerApp()).defaultApp().battery(0, 0L).build();
        AppRegistryBuilder.create(new HardwareManagerApp()).defaultApp().build();
        AppRegistryBuilder.create(new AppStoreApp()).defaultApp().build();
        AppRegistryBuilder.create(new WorldProspectorARApp()).battery(1, 320L).upgrade(0, MetaItems.EMITTER_LV.getStackForm(2)).upgrade(1, MetaItems.EMITTER_MV.getStackForm(2)).upgrade(2, MetaItems.EMITTER_HV.getStackForm(2)).device(DeviceHardware.DEVICE.CAMERA).build();
        AppRegistryBuilder.create(new VirtualTankApp()).battery(2, 500L).device(DeviceHardware.DEVICE.WIRELESS).build();
        AppRegistryBuilder.create(new CapeSelectorApp()).battery(0, 8L).build();
        if (Loader.isModLoaded((String)"crafttweaker")) {
            CTTerminalRegistry.register();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void initTerminalFiles() {
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(TerminalRegistry::onResourceManagerReload);
    }

    @SideOnly(value=Side.CLIENT)
    public static void onResourceManagerReload(IResourceManager resourceManager) {
        FileUtility.extractJarFiles(String.format("/assets/%s/%s", "gregtech", "terminal"), TERMINAL_PATH, false);
    }

    public static void registerApp(AbstractApplication application) {
        String name = application.getRegistryName();
        if (APP_REGISTER.containsKey(name)) {
            GTLog.logger.warn("Duplicate APP registry names exist: {}", (Object)name);
            return;
        }
        APP_REGISTER.put(name, application);
    }

    public static void registerHardware(Hardware hardware) {
        String name = hardware.getRegistryName();
        if (APP_REGISTER.containsKey(name)) {
            GTLog.logger.warn("Duplicate APP registry names exist: {}", (Object)name);
            return;
        }
        HW_REGISTER.put(name, hardware);
    }

    public static void registerHardwareDemand(String name, boolean isDefaultApp, @Nonnull List<Hardware>[] hardware, @Nonnull List<ItemStack>[] upgrade) {
        if (name != null && APP_REGISTER.containsKey(name)) {
            if (isDefaultApp) {
                DEFAULT_APPS.add(name);
            }
            APP_HW_DEMAND.put(name, hardware);
            APP_UPGRADE_CONDITIONS.put(name, upgrade);
        } else {
            GTLog.logger.error("Not found the app {}", (Object)name);
        }
    }

    public static List<AbstractApplication> getDefaultApps() {
        return DEFAULT_APPS.stream().map(APP_REGISTER::get).collect(Collectors.toList());
    }

    public static Collection<AbstractApplication> getAllApps() {
        return APP_REGISTER.values();
    }

    public static AbstractApplication getApplication(String name) {
        return APP_REGISTER.get(name);
    }

    public static Collection<Hardware> getAllHardware() {
        return HW_REGISTER.values();
    }

    public static Hardware getHardware(String name) {
        return HW_REGISTER.get(name);
    }

    public static List<Hardware> getAppHardwareDemand(String name, int tier) {
        return APP_HW_DEMAND.get(name)[tier] != null ? APP_HW_DEMAND.get(name)[tier] : Collections.emptyList();
    }

    public static List<ItemStack> getAppHardwareUpgradeConditions(String name, int tier) {
        return APP_UPGRADE_CONDITIONS.get(name)[tier] != null ? APP_UPGRADE_CONDITIONS.get(name)[tier] : Collections.emptyList();
    }

    static {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            TERMINAL_PATH = new File(Loader.instance().getConfigDir(), ConfigHolder.client.terminalRootPath);
        }
    }

    private static class AppRegistryBuilder {
        AbstractApplication app;
        boolean isDefaultApp;
        BatteryHardware[] battery;
        List<Hardware>[] hardware;
        List<ItemStack>[] upgrade;

        private AppRegistryBuilder() {
        }

        public static AppRegistryBuilder create(AbstractApplication app) {
            AppRegistryBuilder builder = new AppRegistryBuilder();
            builder.app = app;
            builder.battery = new BatteryHardware[app.getMaxTier() + 1];
            builder.hardware = new List[app.getMaxTier() + 1];
            builder.upgrade = new List[app.getMaxTier() + 1];
            return builder;
        }

        public AppRegistryBuilder defaultApp() {
            this.isDefaultApp = true;
            return this;
        }

        public AppRegistryBuilder battery(int batteryTier, long cost) {
            BatteryHardware.BatteryDemand hw = new BatteryHardware.BatteryDemand(batteryTier, cost);
            for (int i = 0; i <= this.app.getMaxTier(); ++i) {
                this.battery[i] = hw;
            }
            return this;
        }

        public AppRegistryBuilder battery(int tier, int batteryTier, long cost) {
            if (tier < this.battery.length) {
                this.battery[tier] = new BatteryHardware.BatteryDemand(batteryTier, cost);
            }
            return this;
        }

        public AppRegistryBuilder device(DeviceHardware.DEVICE ... device) {
            Hardware[] hw = (Hardware[])Arrays.stream(device).map(DeviceHardware.DeviceDemand::new).toArray(Hardware[]::new);
            for (int i = 0; i <= this.app.getMaxTier(); ++i) {
                this.hardware(i, hw);
            }
            return this;
        }

        public AppRegistryBuilder device(int tier, DeviceHardware.DEVICE ... device) {
            this.hardware(tier, (Hardware[])Arrays.stream(device).map(DeviceHardware.DeviceDemand::new).toArray(Hardware[]::new));
            return this;
        }

        public AppRegistryBuilder hardware(Hardware ... hardware) {
            for (int i = 0; i <= this.app.getMaxTier(); ++i) {
                this.hardware(i, hardware);
            }
            return this;
        }

        public AppRegistryBuilder hardware(int tier, Hardware ... hardware) {
            if (tier < this.hardware.length) {
                this.hardware[tier] = new LinkedList<Hardware>();
                for (Hardware hw : hardware) {
                    this.hardware[tier].add(hw);
                }
            }
            return this;
        }

        public AppRegistryBuilder appendHardware(int tier, Hardware ... hardware) {
            if (tier < this.hardware.length) {
                if (this.hardware[tier] == null) {
                    this.hardware[tier] = new LinkedList<Hardware>();
                }
                for (Hardware hw : hardware) {
                    this.hardware[tier].add(hw);
                }
            }
            return this;
        }

        public AppRegistryBuilder upgrade(ItemStack ... upgrade) {
            ItemStack[] up = (ItemStack[])Arrays.stream(upgrade).toArray(ItemStack[]::new);
            for (int i = 0; i <= this.app.getMaxTier(); ++i) {
                this.upgrade(i, up);
            }
            return this;
        }

        public AppRegistryBuilder upgrade(int tier, ItemStack ... upgrade) {
            if (tier < this.upgrade.length) {
                this.upgrade[tier] = new LinkedList<ItemStack>();
                for (ItemStack up : upgrade) {
                    this.upgrade[tier].add(up);
                }
            }
            return this;
        }

        public void build() {
            TerminalRegistry.registerApp(this.app);
            for (int i = 0; i < this.hardware.length; ++i) {
                if (this.battery[i] == null) continue;
                if (this.hardware[i] == null) {
                    this.hardware[i] = new LinkedList<Hardware>();
                }
                this.hardware[i].add(this.battery[i]);
            }
            TerminalRegistry.registerHardwareDemand(this.app.getRegistryName(), this.isDefaultApp, this.hardware, this.upgrade);
        }
    }
}

