/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.logic;

import gregtech.common.ConfigHolder;
import javax.annotation.Nonnull;

public class OverclockingLogic {
    public static final double STANDARD_OVERCLOCK_VOLTAGE_MULTIPLIER = 4.0;
    public static final double STANDARD_OVERCLOCK_DURATION_DIVISOR = ConfigHolder.machines.overclockDivisor;
    public static final double PERFECT_OVERCLOCK_DURATION_DIVISOR = 4.0;

    @Nonnull
    public static int[] standardOverclockingLogic(int recipeEUt, long maxVoltage, int recipeDuration, int numberOfOCs, double durationDivisor, double voltageMultiplier) {
        double potentialDuration;
        double potentialVoltage;
        double resultDuration = recipeDuration;
        double resultVoltage = recipeEUt;
        while (numberOfOCs > 0 && !((potentialVoltage = resultVoltage * voltageMultiplier) > (double)maxVoltage) && !((potentialDuration = resultDuration / durationDivisor) < 1.0)) {
            resultDuration = potentialDuration;
            resultVoltage = potentialVoltage;
            --numberOfOCs;
        }
        return new int[]{(int)resultVoltage, (int)resultDuration};
    }

    @Nonnull
    public static int[] heatingCoilOverclockingLogic(int recipeEUt, long maximumVoltage, int recipeDuration, int maxOverclocks, int currentTemp, int recipeRequiredTemp) {
        int amountEUDiscount = Math.max(0, (currentTemp - recipeRequiredTemp) / 900);
        int amountPerfectOC = amountEUDiscount / 2;
        recipeEUt = (int)((double)recipeEUt * Math.min(1.0, Math.pow(0.95, amountEUDiscount)));
        if (amountPerfectOC > 0) {
            int[] overclock = OverclockingLogic.standardOverclockingLogic(recipeEUt, maximumVoltage, recipeDuration, amountPerfectOC, 4.0, 4.0);
            return OverclockingLogic.standardOverclockingLogic(overclock[0], maximumVoltage, overclock[1], maxOverclocks - amountPerfectOC, STANDARD_OVERCLOCK_DURATION_DIVISOR, 4.0);
        }
        return OverclockingLogic.standardOverclockingLogic(recipeEUt, maximumVoltage, recipeDuration, maxOverclocks, STANDARD_OVERCLOCK_DURATION_DIVISOR, 4.0);
    }
}

