/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.ingredients;

import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public abstract class GTRecipeInput {
    public static ObjectOpenHashSet<GTRecipeInput> INSTANCES = new ObjectOpenHashSet(15072);
    protected int amount;
    protected boolean isConsumable = true;
    protected NBTMatcher nbtMatcher;
    protected NBTCondition nbtCondition;

    static GTRecipeInput getFromCache(GTRecipeInput realIngredient) {
        GTRecipeInput cachedIngredient = (GTRecipeInput)INSTANCES.get((Object)realIngredient);
        if (cachedIngredient == null) {
            cachedIngredient = realIngredient;
            INSTANCES.add((Object)cachedIngredient);
        }
        return cachedIngredient;
    }

    public static GTRecipeInput getOrCreate(GTRecipeInput gtRecipeIngredient) {
        return GTRecipeInput.getFromCache(gtRecipeIngredient);
    }

    public int getAmount() {
        return this.amount;
    }

    abstract GTRecipeInput copy();

    public abstract GTRecipeInput copyWithAmount(int var1);

    public GTRecipeInput setNonConsumable() {
        GTRecipeInput copy = this.copy();
        copy.isConsumable = false;
        return GTRecipeInput.getFromCache(copy);
    }

    public GTRecipeInput setNBTMatchingCondition(NBTMatcher nbtMatcher, NBTCondition nbtCondition) {
        GTRecipeInput copy = this.copy();
        copy.nbtMatcher = nbtMatcher;
        copy.nbtCondition = nbtCondition;
        return GTRecipeInput.getFromCache(copy);
    }

    public boolean hasNBTMatchingCondition() {
        return this.nbtMatcher != null;
    }

    public NBTMatcher getNBTMatcher() {
        return this.nbtMatcher;
    }

    public NBTCondition getNBTMatchingCondition() {
        return this.nbtCondition;
    }

    public boolean isNonConsumable() {
        return !this.isConsumable;
    }

    public ItemStack[] getInputStacks() {
        return null;
    }

    public FluidStack getInputFluidStack() {
        return null;
    }

    public boolean isOreDict() {
        return false;
    }

    public int getOreDict() {
        return -1;
    }

    public boolean acceptsStack(@Nullable ItemStack input) {
        return false;
    }

    public boolean acceptsFluid(@Nullable FluidStack input) {
        return false;
    }

    public abstract boolean equalIgnoreAmount(GTRecipeInput var1);

    protected static class TagToStack
    implements Object2ObjectMap.Entry<NBTTagCompound, ItemStack> {
        NBTTagCompound tag;
        ItemStack stack;

        TagToStack(NBTTagCompound tag, ItemStack stack) {
            this.tag = tag;
            this.stack = stack;
        }

        TagToStack(ItemStack stack) {
            this.tag = stack.func_77978_p();
            this.stack = stack;
        }

        public NBTTagCompound getKey() {
            return this.tag;
        }

        public ItemStack getValue() {
            return this.stack;
        }

        public ItemStack setValue(ItemStack value) {
            this.stack = value;
            return this.stack;
        }
    }

    protected static class MetaToTAGList
    implements Int2ObjectMap.Entry<List<TagToStack>> {
        protected int meta;
        protected List<TagToStack> tagToStack;

        public MetaToTAGList(ItemStack stack) {
            this.meta = stack.func_77960_j();
            this.tagToStack = ObjectLists.singleton((Object)new TagToStack(stack));
        }

        void addStackToList(ItemStack stack) {
            if (this.tagToStack instanceof ObjectLists.Singleton) {
                this.tagToStack = new ObjectArrayList(this.tagToStack);
            }
            this.tagToStack.add(new TagToStack(stack.func_77978_p(), stack));
        }

        public Integer getKey() {
            return this.meta;
        }

        public int getIntKey() {
            return this.meta;
        }

        public List<TagToStack> getValue() {
            return this.tagToStack;
        }

        public List<TagToStack> setValue(List<TagToStack> value) {
            this.tagToStack = value;
            return this.tagToStack;
        }
    }

    protected static class ItemToMetaList
    implements Object2ObjectMap.Entry<Item, List<MetaToTAGList>> {
        protected Item item;
        protected List<MetaToTAGList> metaToTAGList;

        public ItemToMetaList(ItemStack stack) {
            this.item = stack.func_77973_b();
            this.metaToTAGList = ObjectLists.singleton((Object)new MetaToTAGList(stack));
        }

        void addStackToLists(ItemStack stack) {
            if (this.metaToTAGList instanceof ObjectLists.Singleton) {
                this.metaToTAGList = new ObjectArrayList(this.metaToTAGList);
            }
            this.metaToTAGList.add(new MetaToTAGList(stack));
        }

        public Item getKey() {
            return this.item;
        }

        public List<MetaToTAGList> getValue() {
            return this.metaToTAGList;
        }

        public List<MetaToTAGList> setValue(List<MetaToTAGList> value) {
            this.metaToTAGList = value;
            return this.metaToTAGList;
        }
    }
}

