/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import com.google.common.collect.ImmutableList;
import gregtech.api.GTValues;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.recipeproperties.EmptyRecipePropertyStorage;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.integration.GroovyScriptCompat;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class Recipe {
    private static final NonNullList<ItemStack> EMPTY = NonNullList.func_191196_a();
    private final List<GTRecipeInput> inputs;
    private final NonNullList<ItemStack> outputs;
    private final List<ChanceEntry> chancedOutputs;
    private final List<GTRecipeInput> fluidInputs;
    private final List<FluidStack> fluidOutputs;
    private final int duration;
    private final int EUt;
    private final boolean hidden;
    private final boolean isCTRecipe;
    private final boolean groovyRecipe;
    private final IRecipePropertyStorage recipePropertyStorage;
    private final int hashCode;

    public static int getMaxChancedValue() {
        return 10000;
    }

    public static String formatChanceValue(int outputChance) {
        return String.format("%.2f", (double)outputChance / ((double)Recipe.getMaxChancedValue() * 1.0) * 100.0);
    }

    public Recipe(List<GTRecipeInput> inputs, List<ItemStack> outputs, List<ChanceEntry> chancedOutputs, List<GTRecipeInput> fluidInputs, List<FluidStack> fluidOutputs, int duration, int EUt, boolean hidden, boolean isCTRecipe, IRecipePropertyStorage recipePropertyStorage) {
        IRecipePropertyStorage iRecipePropertyStorage = this.recipePropertyStorage = recipePropertyStorage == null ? EmptyRecipePropertyStorage.INSTANCE : recipePropertyStorage;
        if (inputs.isEmpty()) {
            this.inputs = Collections.emptyList();
        } else {
            this.inputs = NonNullList.func_191196_a();
            this.inputs.addAll(inputs);
            this.inputs.sort((ing1, ing2) -> Boolean.compare(ing1.isNonConsumable(), ing2.isNonConsumable()));
        }
        if (outputs.isEmpty()) {
            this.outputs = EMPTY;
        } else {
            this.outputs = NonNullList.func_191196_a();
            this.outputs.addAll(outputs);
        }
        this.chancedOutputs = chancedOutputs.isEmpty() ? Collections.emptyList() : new ArrayList<ChanceEntry>(chancedOutputs);
        this.fluidInputs = fluidInputs.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf(fluidInputs);
        this.fluidOutputs = fluidOutputs.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf(fluidOutputs);
        this.duration = duration;
        this.EUt = EUt;
        this.hidden = hidden;
        this.isCTRecipe = isCTRecipe;
        this.hashCode = this.makeHashCode();
        this.groovyRecipe = GroovyScriptCompat.isCurrentlyRunning();
    }

    public Recipe copy() {
        return new Recipe(this.inputs, (List<ItemStack>)this.outputs, this.chancedOutputs, this.fluidInputs, this.fluidOutputs, this.duration, this.EUt, this.hidden, this.isCTRecipe, this.recipePropertyStorage);
    }

    public Recipe trimRecipeOutputs(Recipe currentRecipe, RecipeMap<?> recipeMap, int itemTrimLimit, int fluidTrimLimit) {
        if (itemTrimLimit == -1 && fluidTrimLimit == -1) {
            return currentRecipe;
        }
        currentRecipe = currentRecipe.copy();
        RecipeBuilder builder = new RecipeBuilder(currentRecipe, recipeMap);
        builder.clearOutputs();
        builder.clearChancedOutput();
        builder.clearFluidOutputs();
        Pair<List<ItemStack>, List<ChanceEntry>> recipeOutputs = currentRecipe.getItemAndChanceOutputs(itemTrimLimit);
        builder.chancedOutputs((List)recipeOutputs.getRight());
        builder.outputs((Collection)recipeOutputs.getLeft());
        List<FluidStack> recipeFluidOutputs = currentRecipe.getAllFluidOutputs(fluidTrimLimit);
        builder.fluidOutputs(recipeFluidOutputs);
        return builder.build().getResult();
    }

    public final boolean matches(boolean consumeIfSuccessful, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
        return this.matches(consumeIfSuccessful, GTUtility.itemHandlerToList(inputs), GTUtility.fluidHandlerToList(fluidInputs));
    }

    public boolean matches(boolean consumeIfSuccessful, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        Pair<Boolean, int[]> fluids = null;
        Pair<Boolean, int[]> items = null;
        if (fluidInputs.size() > 0 && !((Boolean)(fluids = this.matchesFluid(fluidInputs)).getKey()).booleanValue()) {
            return false;
        }
        if (inputs.size() > 0 && !((Boolean)(items = this.matchesItems(inputs)).getKey()).booleanValue()) {
            return false;
        }
        if (consumeIfSuccessful) {
            int i;
            if (fluids != null) {
                int[] fluidAmountInTank = (int[])fluids.getValue();
                for (i = 0; i < fluidAmountInTank.length; ++i) {
                    FluidStack fluidStack = fluidInputs.get(i);
                    int fluidAmount = fluidAmountInTank[i];
                    if (fluidStack == null || fluidStack.amount == fluidAmount) continue;
                    fluidStack.amount = fluidAmount;
                    if (fluidStack.amount != 0) continue;
                    fluidInputs.set(i, null);
                }
            }
            if (items != null) {
                int[] itemAmountInSlot = (int[])items.getValue();
                for (i = 0; i < itemAmountInSlot.length; ++i) {
                    ItemStack itemInSlot = inputs.get(i);
                    int itemAmount = itemAmountInSlot[i];
                    if (itemInSlot.func_190926_b() || itemInSlot.func_190916_E() == itemAmount) continue;
                    itemInSlot.func_190920_e(itemAmountInSlot[i]);
                }
            }
        }
        return true;
    }

    private Pair<Boolean, int[]> matchesItems(List<ItemStack> inputs) {
        int[] itemAmountInSlot = new int[inputs.size()];
        int indexed = 0;
        List<GTRecipeInput> gtRecipeInputs = this.inputs;
        for (int i = 0; i < gtRecipeInputs.size(); ++i) {
            GTRecipeInput ingredient = gtRecipeInputs.get(i);
            int ingredientAmount = ingredient.getAmount();
            for (int j = 0; j < inputs.size(); ++j) {
                ItemStack inputStack = inputs.get(j);
                if (j == indexed) {
                    itemAmountInSlot[j] = inputStack.func_190926_b() ? 0 : inputStack.func_190916_E();
                    ++indexed;
                }
                if (inputStack.func_190926_b() || !ingredient.acceptsStack(inputStack)) continue;
                int itemAmountToConsume = Math.min(itemAmountInSlot[j], ingredientAmount);
                ingredientAmount -= itemAmountToConsume;
                if (!ingredient.isNonConsumable()) {
                    int n = j;
                    itemAmountInSlot[n] = itemAmountInSlot[n] - itemAmountToConsume;
                }
                if (ingredientAmount == 0) break;
            }
            if (ingredientAmount <= 0) continue;
            return Pair.of((Object)false, (Object)itemAmountInSlot);
        }
        int[] retItemAmountInSlot = new int[indexed];
        System.arraycopy(itemAmountInSlot, 0, retItemAmountInSlot, 0, indexed);
        return Pair.of((Object)true, (Object)retItemAmountInSlot);
    }

    private Pair<Boolean, int[]> matchesFluid(List<FluidStack> fluidInputs) {
        int[] fluidAmountInTank = new int[fluidInputs.size()];
        int indexed = 0;
        List<GTRecipeInput> gtRecipeInputs = this.fluidInputs;
        for (int i = 0; i < gtRecipeInputs.size(); ++i) {
            GTRecipeInput fluid = gtRecipeInputs.get(i);
            int fluidAmount = fluid.getAmount();
            for (int j = 0; j < fluidInputs.size(); ++j) {
                FluidStack tankFluid = fluidInputs.get(j);
                if (j == indexed) {
                    ++indexed;
                    int n = fluidAmountInTank[j] = tankFluid == null ? 0 : tankFluid.amount;
                }
                if (tankFluid == null || !fluid.acceptsFluid(tankFluid)) continue;
                int fluidAmountToConsume = Math.min(fluidAmountInTank[j], fluidAmount);
                fluidAmount -= fluidAmountToConsume;
                if (!fluid.isNonConsumable()) {
                    int n = j;
                    fluidAmountInTank[n] = fluidAmountInTank[n] - fluidAmountToConsume;
                }
                if (fluidAmount == 0) break;
            }
            if (fluidAmount <= 0) continue;
            return Pair.of((Object)false, (Object)fluidAmountInTank);
        }
        int[] retfluidAmountInTank = new int[indexed];
        System.arraycopy(fluidAmountInTank, 0, retfluidAmountInTank, 0, indexed);
        return Pair.of((Object)true, (Object)retfluidAmountInTank);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipe recipe = (Recipe)o;
        return this.hasSameInputs(recipe) && this.hasSameFluidInputs(recipe);
    }

    private int makeHashCode() {
        int hash = 31 * this.hashInputs();
        hash = 31 * hash + this.hashFluidList(this.fluidInputs);
        return hash;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int hashInputs() {
        int hash = 0;
        for (GTRecipeInput recipeIngredient : this.inputs) {
            if (!recipeIngredient.isOreDict()) {
                for (ItemStack is : recipeIngredient.getInputStacks()) {
                    hash = 31 * hash + ItemStackHashStrategy.comparingAll().hashCode(is);
                }
                continue;
            }
            hash = 31 * hash + recipeIngredient.getOreDict();
        }
        return hash;
    }

    private boolean hasSameInputs(Recipe otherRecipe) {
        ObjectArrayList otherStackList = new ObjectArrayList(otherRecipe.inputs.size());
        for (GTRecipeInput otherInputs : otherRecipe.inputs) {
            otherStackList.addAll(Arrays.asList(otherInputs.getInputStacks()));
        }
        if (!((Boolean)this.matchesItems((List<ItemStack>)otherStackList).getLeft()).booleanValue()) {
            return false;
        }
        ObjectArrayList thisStackList = new ObjectArrayList(this.inputs.size());
        for (GTRecipeInput thisInputs : this.inputs) {
            thisStackList.addAll(Arrays.asList(thisInputs.getInputStacks()));
        }
        return (Boolean)otherRecipe.matchesItems((List<ItemStack>)thisStackList).getLeft();
    }

    public int hashFluidList(List<GTRecipeInput> fluids) {
        int hash = 0;
        for (GTRecipeInput fluidInput : fluids) {
            hash = 31 * hash + fluidInput.hashCode();
        }
        return hash;
    }

    private boolean hasSameFluidInputs(Recipe otherRecipe) {
        ObjectArrayList otherFluidList = new ObjectArrayList(otherRecipe.fluidInputs.size());
        for (GTRecipeInput otherInputs : otherRecipe.fluidInputs) {
            FluidStack fluidStack = otherInputs.getInputFluidStack();
            otherFluidList.add(fluidStack);
        }
        if (!((Boolean)this.matchesFluid((List<FluidStack>)otherFluidList).getLeft()).booleanValue()) {
            return false;
        }
        ObjectArrayList thisFluidsList = new ObjectArrayList(this.fluidInputs.size());
        for (GTRecipeInput thisFluidInputs : this.fluidInputs) {
            FluidStack fluidStack = thisFluidInputs.getInputFluidStack();
            thisFluidsList.add(fluidStack);
        }
        return (Boolean)otherRecipe.matchesFluid((List<FluidStack>)thisFluidsList).getLeft();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("inputs", this.inputs).append("outputs", this.outputs).append("chancedOutputs", this.chancedOutputs).append("fluidInputs", this.fluidInputs).append("fluidOutputs", this.fluidOutputs).append("duration", this.duration).append("EUt", this.EUt).append("hidden", this.hidden).append("CTRecipe", this.isCTRecipe).toString();
    }

    public List<GTRecipeInput> getInputs() {
        return this.inputs;
    }

    public NonNullList<ItemStack> getOutputs() {
        return this.outputs;
    }

    public List<ItemStack> getResultItemOutputs(int recipeTier, int machineTier, RecipeMap<?> recipeMap) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>((Collection<ItemStack>)GTUtility.copyStackList(this.getOutputs()));
        List<ChanceEntry> chancedOutputsList = this.getChancedOutputs();
        ArrayList<ItemStack> resultChanced = new ArrayList<ItemStack>();
        for (ChanceEntry chancedOutput : chancedOutputsList) {
            int outputChance = recipeMap.getChanceFunction().chanceFor(chancedOutput.getChance(), chancedOutput.getBoostPerTier(), recipeTier, machineTier);
            if (GTValues.RNG.nextInt(Recipe.getMaxChancedValue()) > outputChance) continue;
            ItemStack stackToAdd = chancedOutput.getItemStack();
            GTUtility.addStackToItemStackList(stackToAdd, resultChanced);
        }
        outputs.addAll(resultChanced);
        return outputs;
    }

    public Pair<List<ItemStack>, List<ChanceEntry>> getItemAndChanceOutputs(int outputLimit) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        List<ChanceEntry> chancedOutputs = new ArrayList<ChanceEntry>(this.getChancedOutputs());
        if (outputLimit == -1) {
            outputs.addAll((Collection<ItemStack>)GTUtility.copyStackList(this.getOutputs()));
        } else if (this.getOutputs().size() >= outputLimit) {
            outputs.addAll(GTUtility.copyStackList(this.getOutputs()).subList(0, Math.min(outputLimit, this.getOutputs().size())));
            chancedOutputs.clear();
        } else if (!this.getOutputs().isEmpty() && this.getOutputs().size() + chancedOutputs.size() >= outputLimit) {
            outputs.addAll((Collection<ItemStack>)GTUtility.copyStackList(this.getOutputs()));
            int numChanced = outputLimit - this.getOutputs().size();
            chancedOutputs = chancedOutputs.subList(0, Math.min(numChanced, chancedOutputs.size()));
        } else if (this.getOutputs().isEmpty()) {
            chancedOutputs = chancedOutputs.subList(0, Math.min(outputLimit, chancedOutputs.size()));
        } else {
            outputs.addAll((Collection<ItemStack>)GTUtility.copyStackList(this.getOutputs()));
        }
        return Pair.of(outputs, chancedOutputs);
    }

    public List<ItemStack> getAllItemOutputs() {
        ArrayList<ItemStack> recipeOutputs = new ArrayList<ItemStack>((Collection<ItemStack>)this.outputs);
        for (ChanceEntry entry : this.chancedOutputs) {
            recipeOutputs.add(entry.getItemStack());
        }
        return recipeOutputs;
    }

    public List<ChanceEntry> getChancedOutputs() {
        return this.chancedOutputs;
    }

    public List<GTRecipeInput> getFluidInputs() {
        return this.fluidInputs;
    }

    public boolean hasInputFluid(FluidStack fluid) {
        for (GTRecipeInput fluidInput : this.fluidInputs) {
            FluidStack fluidStack = fluidInput.getInputFluidStack();
            if (fluid.getFluid() != fluidStack.getFluid()) continue;
            return fluidStack.isFluidEqual(fluid);
        }
        return false;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }

    public List<FluidStack> getAllFluidOutputs(int outputLimit) {
        return outputLimit == -1 ? this.fluidOutputs : this.fluidOutputs.subList(0, Math.min(this.fluidOutputs.size(), outputLimit));
    }

    public int getDuration() {
        return this.duration;
    }

    public int getEUt() {
        return this.EUt;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean getIsCTRecipe() {
        return this.isCTRecipe;
    }

    public boolean isGroovyRecipe() {
        return this.groovyRecipe;
    }

    public boolean hasValidInputsForDisplay() {
        Iterator<GTRecipeInput> iterator = this.inputs.iterator();
        if (iterator.hasNext()) {
            GTRecipeInput ingredient = iterator.next();
            if (ingredient.isOreDict() && OreDictionary.getOres((String)OreDictionary.getOreName((int)ingredient.getOreDict())).stream().anyMatch(s -> !s.func_190926_b())) {
                return true;
            }
            return Arrays.stream(ingredient.getInputStacks()).anyMatch(s -> !s.func_190926_b());
        }
        for (GTRecipeInput fluidInput : this.fluidInputs) {
            FluidStack fluidIngredient = fluidInput.getInputFluidStack();
            if (fluidIngredient == null || fluidIngredient.amount <= 0) continue;
            return true;
        }
        return false;
    }

    public <T> T getProperty(RecipeProperty<T> property, T defaultValue) {
        return this.recipePropertyStorage.getRecipePropertyValue(property, defaultValue);
    }

    public Object getPropertyRaw(String key) {
        return this.recipePropertyStorage.getRawRecipePropertyValue(key);
    }

    public Set<Map.Entry<RecipeProperty<?>, Object>> getPropertyValues() {
        return this.recipePropertyStorage.getRecipeProperties();
    }

    public Set<String> getPropertyKeys() {
        return this.recipePropertyStorage.getRecipePropertyKeys();
    }

    public boolean hasProperty(RecipeProperty<?> property) {
        return this.recipePropertyStorage.hasRecipeProperty(property);
    }

    public int getPropertyCount() {
        return this.recipePropertyStorage.getSize();
    }

    public int getUnhiddenPropertyCount() {
        return (int)this.recipePropertyStorage.getRecipeProperties().stream().filter(property -> !((RecipeProperty)property.getKey()).isHidden()).count();
    }

    public IRecipePropertyStorage getRecipePropertyStorage() {
        return this.recipePropertyStorage;
    }

    public static class ChanceEntry {
        private final ItemStack itemStack;
        private final int chance;
        private final int boostPerTier;

        public ChanceEntry(ItemStack itemStack, int chance, int boostPerTier) {
            this.itemStack = itemStack.func_77946_l();
            this.chance = chance;
            this.boostPerTier = boostPerTier;
        }

        public ItemStack getItemStack() {
            return this.itemStack.func_77946_l();
        }

        public ItemStack getItemStackRaw() {
            return this.itemStack;
        }

        public int getChance() {
            return this.chance;
        }

        public int getBoostPerTier() {
            return this.boostPerTier;
        }

        public ChanceEntry copy() {
            return new ChanceEntry(this.itemStack, this.chance, this.boostPerTier);
        }
    }
}

