/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import crafttweaker.mc1120.actions.ActionAddFurnaceRecipe;
import crafttweaker.mc1120.furnace.MCFurnaceManager;
import gregtech.api.GTValues;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipes.DummyRecipe;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterial;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.ItemMaterialInfo;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.DummyContainer;
import gregtech.api.util.GTLog;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.ShapedOreEnergyTransferRecipe;
import gregtech.api.util.world.DummyWorld;
import gregtech.common.ConfigHolder;
import gregtech.common.crafting.FluidReplaceRecipe;
import gregtech.common.crafting.GTShapedOreRecipe;
import gregtech.common.crafting.GTShapelessOreRecipe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class ModHandler {
    private ModHandler() {
    }

    public static boolean isWater(@Nullable FluidStack fluid) {
        if (fluid == null) {
            return false;
        }
        if (fluid.isFluidEqual(new FluidStack(FluidRegistry.WATER, 1))) {
            return true;
        }
        if (fluid.isFluidEqual(Materials.DistilledWater.getFluid(1))) {
            return true;
        }
        for (String fluidName : ConfigHolder.machines.boilerFluids) {
            Fluid f = FluidRegistry.getFluid((String)fluidName);
            if (f == null || !fluid.isFluidEqual(new FluidStack(f, 1))) continue;
            return true;
        }
        return false;
    }

    public static FluidStack getBoilerFluidFromContainer(@Nonnull IFluidHandler fluidHandler, boolean doDrain) {
        return ModHandler.getBoilerFluidFromContainer(fluidHandler, 1, doDrain);
    }

    public static FluidStack getBoilerFluidFromContainer(@Nonnull IFluidHandler fluidHandler, int amount, boolean doDrain) {
        if (amount == 0) {
            return null;
        }
        FluidStack drainedWater = fluidHandler.drain(Materials.Water.getFluid(amount), doDrain);
        if (drainedWater == null || drainedWater.amount == 0) {
            drainedWater = fluidHandler.drain(Materials.DistilledWater.getFluid(amount), doDrain);
        }
        if (drainedWater == null || drainedWater.amount == 0) {
            String fluidName;
            Fluid f;
            String[] stringArray = ConfigHolder.machines.boilerFluids;
            int n = stringArray.length;
            for (int i = 0; i < n && ((f = FluidRegistry.getFluid((String)(fluidName = stringArray[i]))) == null || (drainedWater = fluidHandler.drain(new FluidStack(f, amount), doDrain)) == null || drainedWater.amount <= 0); ++i) {
            }
        }
        return drainedWater;
    }

    public static boolean isLava(FluidStack fluid) {
        return new FluidStack(FluidRegistry.LAVA, 0).isFluidEqual(fluid);
    }

    public static FluidStack getLava(int amount) {
        return new FluidStack(FluidRegistry.LAVA, amount);
    }

    public static boolean isSteam(FluidStack fluid) {
        return ModHandler.getSteam(1).isFluidEqual(fluid);
    }

    public static FluidStack getSteam(int amount) {
        return Objects.requireNonNull(Materials.Steam.getFluid(amount));
    }

    public static boolean isMaterialWood(Material material) {
        return material == Materials.Wood || material == Materials.TreatedWood;
    }

    public static int getFuelValue(ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack);
    }

    public static ItemStack getBurningFuelRemainder(ItemStack fuelStack) {
        float remainderChance;
        ItemStack remainder;
        if (OreDictUnifier.getOreDictionaryNames(fuelStack).contains("fuelCoke")) {
            remainder = OreDictUnifier.get(OrePrefix.dust, Materials.Ash);
            remainderChance = 0.5f;
        } else {
            MaterialStack materialStack = OreDictUnifier.getMaterial(fuelStack);
            if (materialStack == null) {
                return ItemStack.field_190927_a;
            }
            if (materialStack.material == Materials.Charcoal) {
                remainder = OreDictUnifier.get(OrePrefix.dust, Materials.Ash);
                remainderChance = 0.3f;
            } else if (materialStack.material == Materials.Coal) {
                remainder = OreDictUnifier.get(OrePrefix.dust, Materials.DarkAsh);
                remainderChance = 0.35f;
            } else if (materialStack.material == Materials.Coke) {
                remainder = OreDictUnifier.get(OrePrefix.dust, Materials.Ash);
                remainderChance = 0.5f;
            } else {
                return ItemStack.field_190927_a;
            }
        }
        return GTValues.RNG.nextFloat() <= remainderChance ? remainder : ItemStack.field_190927_a;
    }

    public static void addSmeltingRecipe(UnificationEntry input, ItemStack output) {
        List<ItemStack> allStacks = OreDictUnifier.getAll(input);
        for (ItemStack inputStack : allStacks) {
            ModHandler.addSmeltingRecipe(inputStack, output, 0.0f);
        }
    }

    public static void addSmeltingRecipe(UnificationEntry input, ItemStack output, float experience) {
        List<ItemStack> allStacks = OreDictUnifier.getAll(input);
        for (ItemStack inputStack : allStacks) {
            ModHandler.addSmeltingRecipe(inputStack, output, experience);
        }
    }

    public static void addSmeltingRecipe(ItemStack input, ItemStack output, float experience) {
        boolean skip = false;
        if (input.func_190926_b()) {
            GTLog.logger.error((Object)new IllegalArgumentException("Input cannot be an empty ItemStack"));
            skip = true;
            RecipeMap.setFoundInvalidRecipe(true);
        }
        if (output.func_190926_b()) {
            GTLog.logger.error((Object)new IllegalArgumentException("Output cannot be an empty ItemStack"));
            skip = true;
            RecipeMap.setFoundInvalidRecipe(true);
        }
        if (skip) {
            return;
        }
        FurnaceRecipes recipes = FurnaceRecipes.func_77602_a();
        if (recipes.func_151395_a(input).func_190926_b()) {
            recipes.func_151394_a(input, output, experience);
        }
    }

    public static void addMirroredShapedRecipe(String regName, ItemStack result, Object ... recipe) {
        ModHandler.addMirroredShapedRecipe(false, regName, result, recipe);
    }

    public static void addMirroredShapedRecipe(boolean withUnificationData, String regName, ItemStack result, Object ... recipe) {
        result = OreDictUnifier.getUnificated(result);
        boolean skip = false;
        if (result.func_190926_b()) {
            GTLog.logger.error((Object)new IllegalArgumentException("Result cannot be an empty ItemStack. Recipe: " + regName));
            skip = true;
        }
        boolean bl = skip = skip || ModHandler.validateRecipe(regName, recipe);
        if (skip) {
            RecipeMap.setFoundInvalidRecipe(true);
            return;
        }
        IRecipe shapedOreRecipe = (IRecipe)new GTShapedOreRecipe(false, new ResourceLocation("gregtech", "general"), result.func_77946_l(), ModHandler.finalizeShapedRecipeInput(recipe)).setMirrored(true).setRegistryName(regName);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)shapedOreRecipe);
        if (withUnificationData) {
            OreDictUnifier.registerOre(result, ModHandler.getRecyclingIngredients(result.func_190916_E(), recipe));
        }
    }

    public static void addShapedRecipe(String regName, ItemStack result, Object ... recipe) {
        ModHandler.addShapedRecipe(false, regName, result, false, recipe);
    }

    public static void addFluidReplaceRecipe(String regName, ItemStack result, Object ... recipe) {
        ModHandler.addFluidReplaceRecipe(regName, result, false, recipe);
    }

    public static void addShapedNBTClearingRecipe(String regName, ItemStack result, Object ... recipe) {
        ModHandler.addShapedRecipe(false, regName, result, true, recipe);
    }

    public static void addShapedRecipe(boolean withUnificationData, String regName, ItemStack result, Object ... recipe) {
        ModHandler.addShapedRecipe(withUnificationData, regName, result, false, recipe);
    }

    public static void addShapedRecipe(boolean withUnificationData, String regName, ItemStack result, boolean isNBTClearing, Object ... recipe) {
        boolean skip = false;
        if (result.func_190926_b()) {
            GTLog.logger.error((Object)new IllegalArgumentException("Result cannot be an empty ItemStack. Recipe: " + regName));
            skip = true;
        }
        boolean bl = skip = skip || ModHandler.validateRecipe(regName, recipe);
        if (skip) {
            RecipeMap.setFoundInvalidRecipe(true);
            return;
        }
        IRecipe shapedOreRecipe = (IRecipe)new GTShapedOreRecipe(isNBTClearing, null, result.func_77946_l(), ModHandler.finalizeShapedRecipeInput(recipe)).setMirrored(false).setRegistryName(regName);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)shapedOreRecipe);
        if (withUnificationData) {
            OreDictUnifier.registerOre(result, ModHandler.getRecyclingIngredients(result.func_190916_E(), recipe));
        }
    }

    public static void addFluidReplaceRecipe(String regName, ItemStack result, boolean isNBTClearing, Object ... recipe) {
        boolean skip = false;
        if (result.func_190926_b()) {
            GTLog.logger.error((Object)new IllegalArgumentException("Result cannot be an empty ItemStack. Recipe: " + regName));
            skip = true;
        }
        boolean bl = skip = skip || ModHandler.validateRecipe(regName, recipe);
        if (skip) {
            RecipeMap.setFoundInvalidRecipe(true);
            return;
        }
        IRecipe shapedOreRecipe = (IRecipe)new FluidReplaceRecipe(isNBTClearing, null, result.func_77946_l(), ModHandler.finalizeShapedRecipeInput(recipe)).setMirrored(false).setRegistryName(regName);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)shapedOreRecipe);
    }

    public static void addShapedEnergyTransferRecipe(String regName, ItemStack result, Predicate<ItemStack> chargePredicate, boolean overrideCharge, boolean transferMaxCharge, Object ... recipe) {
        boolean skip = false;
        if (result.func_190926_b()) {
            GTLog.logger.error((Object)new IllegalArgumentException("Result cannot be an empty ItemStack. Recipe: " + regName));
            skip = true;
        }
        boolean bl = skip = skip || ModHandler.validateRecipe(regName, recipe);
        if (skip) {
            RecipeMap.setFoundInvalidRecipe(true);
            return;
        }
        IRecipe shapedOreRecipe = (IRecipe)new ShapedOreEnergyTransferRecipe(null, result.func_77946_l(), chargePredicate, overrideCharge, transferMaxCharge, ModHandler.finalizeShapedRecipeInput(recipe)).setMirrored(false).setRegistryName(regName);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)shapedOreRecipe);
    }

    private static boolean validateRecipe(String regName, Object ... recipe) {
        boolean skip = false;
        if (recipe == null) {
            GTLog.logger.error((Object)new IllegalArgumentException("Recipe cannot be null"));
            skip = true;
        } else if (recipe.length == 0) {
            GTLog.logger.error((Object)new IllegalArgumentException("Recipe cannot be empty"));
            skip = true;
        } else if (Arrays.asList(recipe).contains(null) || Arrays.asList(recipe).contains(ItemStack.field_190927_a)) {
            String recipeMessage = Arrays.stream(recipe).map(o -> o == null ? "NULL" : o).map(o -> o == ItemStack.field_190927_a ? "EMPTY STACK" : o).map(Object::toString).map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));
            GTLog.logger.error((Object)new IllegalArgumentException("Recipe cannot contain null elements or Empty ItemStacks. Recipe: " + recipeMessage));
            skip = true;
        } else {
            ModContainer container = Loader.instance().activeModContainer();
            if (ForgeRegistries.RECIPES.containsKey(new ResourceLocation(container == null ? "gregtech" : container.getModId().toLowerCase(), regName))) {
                String recipeMessage = Arrays.stream(recipe).map(Object::toString).map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));
                GTLog.logger.error((Object)new IllegalArgumentException("Tried to register recipe, " + regName + ", with duplicate key. Recipe: " + recipeMessage));
                skip = true;
            }
        }
        return skip;
    }

    public static Object[] finalizeShapedRecipeInput(Object ... recipe) {
        for (int i = 0; i < recipe.length; i = (int)((byte)(i + 1))) {
            recipe[i] = ModHandler.finalizeIngredient(recipe[i]);
        }
        int idx = 0;
        ArrayList<Object> recipeList = new ArrayList<Object>(Arrays.asList(recipe));
        while (recipe[idx] instanceof String) {
            StringBuilder s = new StringBuilder((String)recipe[idx++]);
            while (s.length() < 3) {
                s.append(" ");
            }
            if (s.length() > 3) {
                throw new IllegalArgumentException("Recipe row cannot be larger than 3. Index: " + idx);
            }
            for (char c : s.toString().toCharArray()) {
                IGTTool tool = ToolHelper.getToolFromSymbol(Character.valueOf(c));
                if (tool == null || tool.getOreDictName() == null) continue;
                recipeList.add(Character.valueOf(c));
                recipeList.add(tool.getOreDictName());
            }
        }
        return recipeList.toArray();
    }

    public static Object finalizeIngredient(Object ingredient) {
        if (ingredient instanceof MetaItem.MetaValueItem) {
            ingredient = ((MetaItem.MetaValueItem)ingredient).getStackForm();
        } else if (ingredient instanceof Enum) {
            ingredient = ((Enum)ingredient).name();
        } else if (ingredient instanceof OrePrefix) {
            ingredient = ((OrePrefix)ingredient).name();
        } else if (ingredient instanceof UnificationEntry) {
            UnificationEntry entry = (UnificationEntry)ingredient;
            if (ConfigHolder.misc.debug && entry.material != null && !entry.orePrefix.isIgnored(entry.material) && !entry.orePrefix.doGenerateItem(entry.material)) {
                GTLog.logger.error((Object)new IllegalArgumentException("Attempted to create recipe for invalid/missing Unification Entry " + ingredient));
            }
            ingredient = ingredient.toString();
        } else if (!(ingredient instanceof ItemStack || ingredient instanceof Item || ingredient instanceof Block || ingredient instanceof String || ingredient instanceof Character || ingredient instanceof Boolean || ingredient instanceof Ingredient)) {
            throw new IllegalArgumentException(ingredient.getClass().getSimpleName() + " type is not suitable for crafting input.");
        }
        return ingredient;
    }

    public static ItemMaterialInfo getRecyclingIngredients(int outputCount, Object ... recipe) {
        HashMap<Character, Integer> inputCountMap = new HashMap<Character, Integer>();
        HashMap materialStacksExploded = new HashMap();
        int itr = 0;
        while (recipe[itr] instanceof String) {
            String s = (String)recipe[itr];
            for (char c2 : s.toCharArray()) {
                if (ToolHelper.getToolFromSymbol(Character.valueOf(c2)) != null) continue;
                int count = inputCountMap.getOrDefault(Character.valueOf(c2), 0);
                inputCountMap.put(Character.valueOf(c2), count + 1);
            }
            ++itr;
        }
        char lastChar = ' ';
        for (int i = itr; i < recipe.length; ++i) {
            OrePrefix prefix;
            ItemStack stack;
            Object ingredient = recipe[i];
            if (ingredient instanceof Character) {
                lastChar = ((Character)ingredient).charValue();
                continue;
            }
            if (lastChar == ' ') {
                return null;
            }
            if (ingredient instanceof MetaItem.MetaValueItem) {
                stack = ((MetaItem.MetaValueItem)ingredient).getStackForm();
            } else if (ingredient instanceof UnificationEntry) {
                stack = OreDictUnifier.get((UnificationEntry)ingredient);
            } else if (ingredient instanceof ItemStack) {
                stack = (ItemStack)ingredient;
            } else if (ingredient instanceof Item) {
                stack = new ItemStack((Item)ingredient, 1);
            } else if (ingredient instanceof Block) {
                stack = new ItemStack((Block)ingredient, 1);
            } else {
                if (!(ingredient instanceof String)) continue;
                stack = OreDictUnifier.get((String)ingredient);
            }
            BiConsumer<MaterialStack, Character> func = (ms, c) -> {
                long amount = materialStacksExploded.getOrDefault(ms.material, 0L);
                materialStacksExploded.put(ms.material, ms.amount * (long)((Integer)inputCountMap.get(c)).intValue() + amount);
            };
            ItemMaterialInfo info = OreDictUnifier.getMaterialInfo(stack);
            if (info != null) {
                for (MaterialStack ms2 : info.getMaterials()) {
                    if (ms2.material instanceof MarkerMaterial) continue;
                    func.accept(ms2, Character.valueOf(lastChar));
                }
                continue;
            }
            MaterialStack materialStack = OreDictUnifier.getMaterial(stack);
            if (materialStack != null && !(materialStack.material instanceof MarkerMaterial)) {
                func.accept(materialStack, Character.valueOf(lastChar));
            }
            if ((prefix = OreDictUnifier.getPrefix(stack)) == null || prefix.secondaryMaterials.isEmpty()) continue;
            for (MaterialStack ms3 : prefix.secondaryMaterials) {
                func.accept(ms3, Character.valueOf(lastChar));
            }
        }
        return new ItemMaterialInfo(materialStacksExploded.entrySet().stream().map(e -> new MaterialStack((Material)e.getKey(), (Long)e.getValue() / (long)outputCount)).sorted(Comparator.comparingLong(m -> -m.amount)).collect(Collectors.toList()));
    }

    public static void addShapelessRecipe(String regName, ItemStack result, Object ... recipe) {
        ModHandler.addShapelessRecipe(regName, result, false, recipe);
    }

    public static void addShapelessNBTClearingRecipe(String regName, ItemStack result, Object ... recipe) {
        ModHandler.addShapelessRecipe(regName, result, true, recipe);
    }

    public static void addShapelessRecipe(String regName, ItemStack result, boolean isNBTClearing, Object ... recipe) {
        boolean skip = false;
        if (result.func_190926_b()) {
            GTLog.logger.error((Object)new IllegalArgumentException("Result cannot be an empty ItemStack. Recipe: " + regName));
            skip = true;
        }
        boolean bl = skip = skip || ModHandler.validateRecipe(regName, recipe);
        if (skip) {
            RecipeMap.setFoundInvalidRecipe(true);
            return;
        }
        for (int i = 0; i < recipe.length; i = (int)((byte)(i + 1))) {
            if (recipe[i] instanceof MetaItem.MetaValueItem) {
                recipe[i] = ((MetaItem.MetaValueItem)recipe[i]).getStackForm();
                continue;
            }
            if (recipe[i] instanceof Enum) {
                recipe[i] = ((Enum)recipe[i]).name();
                continue;
            }
            if (recipe[i] instanceof OrePrefix) {
                recipe[i] = ((OrePrefix)recipe[i]).name();
                continue;
            }
            if (recipe[i] instanceof UnificationEntry) {
                recipe[i] = recipe[i].toString();
                continue;
            }
            if (recipe[i] instanceof Character) {
                IGTTool tool = ToolHelper.getToolFromSymbol(Character.valueOf(((Character)recipe[i]).charValue()));
                if (tool == null || tool.getOreDictName() == null) {
                    throw new IllegalArgumentException("Tool name is not found for char " + recipe[i]);
                }
                recipe[i] = tool.getOreDictName();
                continue;
            }
            if (recipe[i] instanceof ItemStack || recipe[i] instanceof Item || recipe[i] instanceof Block || recipe[i] instanceof String) continue;
            throw new IllegalArgumentException(recipe.getClass().getSimpleName() + " type is not suitable for crafting input.");
        }
        IRecipe shapelessRecipe = (IRecipe)new GTShapelessOreRecipe(isNBTClearing, null, result.func_77946_l(), recipe).setRegistryName(regName);
        try {
            Field field = ShapelessOreRecipe.class.getDeclaredField("isSimple");
            field.setAccessible(true);
            field.setBoolean(shapelessRecipe, false);
        }
        catch (ReflectiveOperationException exception) {
            GTLog.logger.error("Failed to mark shapeless recipe as complex", (Throwable)exception);
        }
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)shapelessRecipe);
    }

    public static Collection<ItemStack> getAllSubItems(ItemStack item) {
        CreativeTabs[] visibleTags;
        if (item.func_77952_i() != Short.MAX_VALUE) {
            return Collections.singleton(item);
        }
        NonNullList stackList = NonNullList.func_191196_a();
        for (CreativeTabs creativeTab : visibleTags = item.func_77973_b().getCreativeTabs()) {
            NonNullList thisList = NonNullList.func_191196_a();
            item.func_77973_b().func_150895_a(creativeTab, thisList);
            block1: for (ItemStack newStack : thisList) {
                for (ItemStack alreadyExists : stackList) {
                    if (!ItemStack.func_77989_b((ItemStack)alreadyExists, (ItemStack)newStack)) continue;
                    continue block1;
                }
                stackList.add((Object)newStack);
            }
        }
        return stackList;
    }

    public static boolean removeFurnaceSmelting(UnificationEntry input) {
        boolean result = false;
        List<ItemStack> allStacks = OreDictUnifier.getAll(input);
        for (ItemStack inputStack : allStacks) {
            result = result || ModHandler.removeFurnaceSmelting(inputStack);
        }
        return result;
    }

    public static boolean removeFurnaceSmelting(ItemStack input) {
        if (input.func_190926_b()) {
            GTLog.logger.error((Object)new IllegalArgumentException("Cannot remove furnace recipe with empty input."));
            RecipeMap.setFoundInvalidRecipe(true);
            return false;
        }
        boolean wasRemoved = FurnaceRecipes.func_77602_a().func_77599_b().keySet().removeIf(currentStack -> currentStack.func_77973_b() == input.func_77973_b() && (currentStack.func_77960_j() == Short.MAX_VALUE || currentStack.func_77960_j() == input.func_77960_j()));
        if (ConfigHolder.misc.debug) {
            if (wasRemoved) {
                GTLog.logger.info("Removed Smelting Recipe for Input: {}", (Object)input.func_82833_r());
            } else {
                GTLog.logger.error("Failed to Remove Smelting Recipe for Input: {}", (Object)input.func_82833_r());
            }
        }
        return wasRemoved;
    }

    public static int removeRecipes(ItemStack output) {
        int recipesRemoved = ModHandler.removeRecipes((IRecipe recipe) -> ItemStack.func_77989_b((ItemStack)recipe.func_77571_b(), (ItemStack)output));
        if (ConfigHolder.misc.debug) {
            if (recipesRemoved != 0) {
                GTLog.logger.info("Removed {} Recipe(s) with Output: {}", (Object)recipesRemoved, (Object)output.func_82833_r());
            } else {
                GTLog.logger.error("Failed to Remove Recipe with Output: {}", (Object)output.func_82833_r());
            }
        }
        return recipesRemoved;
    }

    public static int removeRecipes(Predicate<IRecipe> predicate) {
        int recipesRemoved = 0;
        IForgeRegistry registry = ForgeRegistries.RECIPES;
        ArrayList<IRecipe> toRemove = new ArrayList<IRecipe>();
        for (IRecipe recipe2 : registry) {
            if (!predicate.test(recipe2)) continue;
            toRemove.add(recipe2);
            ++recipesRemoved;
        }
        toRemove.forEach(recipe -> registry.register(new DummyRecipe().setRegistryName(recipe.getRegistryName())));
        return recipesRemoved;
    }

    public static void removeRecipeByName(ResourceLocation location) {
        if (ConfigHolder.misc.debug) {
            String recipeName = location.toString();
            if (ForgeRegistries.RECIPES.containsKey(location)) {
                GTLog.logger.info("Removed Recipe with Name: {}", (Object)recipeName);
            } else {
                GTLog.logger.error("Failed to Remove Recipe with Name: {}", (Object)recipeName);
            }
        }
        ForgeRegistries.RECIPES.register(new DummyRecipe().setRegistryName(location));
    }

    public static void removeRecipeByName(String recipeName) {
        ModHandler.removeRecipeByName(new ResourceLocation(recipeName));
    }

    public static void removeTieredRecipeByName(String recipeName, int startTier, int endTier) {
        for (int i = startTier; i <= endTier; ++i) {
            ModHandler.removeRecipeByName(String.format("%s%s", recipeName, GTValues.VN[i].toLowerCase()));
        }
    }

    public static Pair<IRecipe, ItemStack> getRecipeOutput(World world, ItemStack ... recipe) {
        if (recipe == null || recipe.length == 0) {
            return ImmutablePair.of(null, (Object)ItemStack.field_190927_a);
        }
        if (world == null) {
            world = DummyWorld.INSTANCE;
        }
        InventoryCrafting craftingGrid = new InventoryCrafting((Container)new DummyContainer(), 3, 3);
        for (int i = 0; i < 9 && i < recipe.length; ++i) {
            ItemStack recipeStack = recipe[i];
            if (recipeStack == null || recipeStack.func_190926_b()) continue;
            craftingGrid.func_70299_a(i, recipeStack);
        }
        for (IRecipe tmpRecipe : CraftingManager.field_193380_a) {
            if (!tmpRecipe.func_77569_a(craftingGrid, world)) continue;
            ItemStack itemStack = tmpRecipe.func_77572_b(craftingGrid);
            return ImmutablePair.of((Object)tmpRecipe, (Object)itemStack);
        }
        return ImmutablePair.of(null, (Object)ItemStack.field_190927_a);
    }

    public static ItemStack getSmeltingOutput(ItemStack input) {
        if (input.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return OreDictUnifier.getUnificated(FurnaceRecipes.func_77602_a().func_151395_a(input));
    }

    public static void removeSmeltingEBFMetals() {
        boolean isCTLoaded = Loader.isModLoaded((String)"crafttweaker");
        Field actionAddFurnaceRecipe$output = null;
        Map furnaceList = FurnaceRecipes.func_77602_a().func_77599_b();
        Iterator recipeIterator = furnaceList.entrySet().iterator();
        block4: while (recipeIterator.hasNext()) {
            Material material;
            Map.Entry recipe = recipeIterator.next();
            ItemStack output = (ItemStack)recipe.getValue();
            ItemStack input = (ItemStack)recipe.getKey();
            MaterialStack ms = OreDictUnifier.getMaterial(output);
            if (ms == null || !(material = ms.material).hasProperty(PropertyKey.BLAST)) continue;
            ItemStack dust = OreDictUnifier.get(OrePrefix.dust, material);
            ItemStack ingot = OreDictUnifier.get(OrePrefix.ingot, material);
            if (!ingot.func_77969_a(output) || !dust.func_77969_a(input)) continue;
            if (isCTLoaded) {
                if (actionAddFurnaceRecipe$output == null) {
                    try {
                        actionAddFurnaceRecipe$output = ActionAddFurnaceRecipe.class.getDeclaredField("output");
                        actionAddFurnaceRecipe$output.setAccessible(true);
                    }
                    catch (NoSuchFieldException e) {
                        GTLog.logger.error("Could not reflect Furnace output field", (Throwable)e);
                        return;
                    }
                }
                for (ActionAddFurnaceRecipe aafr : MCFurnaceManager.recipesToAdd) {
                    try {
                        if (actionAddFurnaceRecipe$output.get(aafr) != output) continue;
                        if (!ConfigHolder.misc.debug) continue block4;
                        GTLog.logger.info("Not removing Smelting Recipe for EBF material {} as it is added via CT", (Object)LocalizationUtils.format(material.getUnlocalizedName(), new Object[0]));
                        continue block4;
                    }
                    catch (IllegalAccessException e) {
                        GTLog.logger.error("Could not get Furnace recipe output from field", (Throwable)e);
                    }
                }
            }
            recipeIterator.remove();
            if (!ConfigHolder.misc.debug) continue;
            GTLog.logger.info("Removing Smelting Recipe for EBF material {}", (Object)LocalizationUtils.format(material.getUnlocalizedName(), new Object[0]));
        }
    }
}

