/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pattern;

import gregtech.api.pattern.PatternError;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockWorldState {
    protected World world;
    protected BlockPos pos;
    protected IBlockState state;
    protected TileEntity tileEntity;
    protected boolean tileEntityInitialized;
    protected PatternMatchContext matchContext;
    protected Map<TraceabilityPredicate.SimplePredicate, Integer> globalCount;
    protected Map<TraceabilityPredicate.SimplePredicate, Integer> layerCount;
    protected TraceabilityPredicate predicate;
    protected PatternError error;

    public void update(World worldIn, BlockPos posIn, PatternMatchContext matchContext, Map<TraceabilityPredicate.SimplePredicate, Integer> globalCount, Map<TraceabilityPredicate.SimplePredicate, Integer> layerCount, TraceabilityPredicate predicate) {
        this.world = worldIn;
        this.pos = posIn;
        this.state = null;
        this.tileEntity = null;
        this.tileEntityInitialized = false;
        this.matchContext = matchContext;
        this.globalCount = globalCount;
        this.layerCount = layerCount;
        this.predicate = predicate;
        this.error = null;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public void setError(PatternError error) {
        this.error = error;
        if (error != null) {
            error.setWorldState(this);
        }
    }

    public PatternMatchContext getMatchContext() {
        return this.matchContext;
    }

    public IBlockState getBlockState() {
        if (this.state == null) {
            this.state = this.world.func_180495_p(this.pos);
        }
        return this.state;
    }

    @Nullable
    public TileEntity getTileEntity() {
        if (this.tileEntity == null && !this.tileEntityInitialized) {
            this.tileEntity = this.world.func_175625_s(this.pos);
            this.tileEntityInitialized = true;
        }
        return this.tileEntity;
    }

    public BlockPos getPos() {
        return this.pos.func_185334_h();
    }

    public IBlockState getOffsetState(EnumFacing face) {
        if (this.pos instanceof BlockPos.MutableBlockPos) {
            ((BlockPos.MutableBlockPos)this.pos).func_189536_c(face);
            IBlockState blockState = this.world.func_180495_p(this.pos);
            ((BlockPos.MutableBlockPos)this.pos).func_189536_c(face.func_176734_d());
            return blockState;
        }
        return this.world.func_180495_p(this.pos.func_177972_a(face));
    }

    public World getWorld() {
        return this.world;
    }
}

