/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.metaitem;

import gregtech.api.capability.impl.GTFluidHandlerItemStack;
import gregtech.api.capability.impl.GTSimpleFluidHandlerItemStack;
import gregtech.api.items.metaitem.stats.IItemCapabilityProvider;
import gregtech.api.items.metaitem.stats.IItemComponent;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;

public class FilteredFluidStats
implements IItemComponent,
IItemCapabilityProvider {
    public final int capacity;
    public final boolean allowPartialFill;
    private final Function<FluidStack, Boolean> fillPredicate;

    public FilteredFluidStats(int capacity, boolean allowPartialFill, Function<FluidStack, Boolean> fillPredicate) {
        this.capacity = capacity;
        this.allowPartialFill = allowPartialFill;
        this.fillPredicate = fillPredicate;
    }

    @Override
    public ICapabilityProvider createProvider(ItemStack itemStack) {
        if (this.allowPartialFill) {
            return new GTFluidHandlerItemStack(itemStack, this.capacity){

                public boolean canFillFluidType(FluidStack fluid) {
                    return super.canFillFluidType(fluid) && (Boolean)FilteredFluidStats.this.fillPredicate.apply(fluid) != false;
                }
            };
        }
        return new GTSimpleFluidHandlerItemStack(itemStack, this.capacity){

            public boolean canFillFluidType(FluidStack fluid) {
                return super.canFillFluidType(fluid) && (Boolean)FilteredFluidStats.this.fillPredicate.apply(fluid) != false;
            }
        };
    }
}

