/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import com.google.common.base.Preconditions;
import gregtech.api.gui.INativeWidget;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.ISizeProvider;
import gregtech.api.gui.Widget;
import gregtech.api.gui.impl.ModularUIGui;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class SlotWidget
extends Widget
implements INativeWidget {
    protected final Slot slotReference;
    protected final boolean canTakeItems;
    protected final boolean canPutItems;
    protected INativeWidget.SlotLocationInfo locationInfo = new INativeWidget.SlotLocationInfo(false, false);
    protected IGuiTexture[] backgroundTexture;
    protected Runnable changeListener;
    private String tooltipText;
    private Object[] tooltipArgs;

    public SlotWidget(IInventory inventory, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        super(new Position(xPosition, yPosition), new Size(18, 18));
        this.canTakeItems = canTakeItems;
        this.canPutItems = canPutItems;
        this.slotReference = this.createSlot(inventory, slotIndex);
    }

    public SlotWidget(IItemHandler itemHandler, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        super(new Position(xPosition, yPosition), new Size(18, 18));
        this.canTakeItems = canTakeItems;
        this.canPutItems = canPutItems;
        this.slotReference = this.createSlot(itemHandler, slotIndex, true);
    }

    public SlotWidget(IItemHandler itemHandler, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems, boolean canShiftClickInto) {
        super(new Position(xPosition, yPosition), new Size(18, 18));
        this.canTakeItems = canTakeItems;
        this.canPutItems = canPutItems;
        this.slotReference = this.createSlot(itemHandler, slotIndex, canShiftClickInto);
    }

    @Override
    public void setSizes(ISizeProvider sizes) {
        super.setSizes(sizes);
        this.onPositionUpdate();
    }

    protected Slot createSlot(IInventory inventory, int index) {
        return new WidgetSlot(inventory, index, 0, 0);
    }

    protected Slot createSlot(IItemHandler itemHandler, int index, boolean canShiftClickInto) {
        return new WidgetSlotItemHandler(itemHandler, index, 0, 0, canShiftClickInto);
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        ((ISlotWidget)this.slotReference).setHover(this.isMouseOverElement(mouseX, mouseY) && this.isActive());
        if (this.tooltipText != null && this.isMouseOverElement(mouseX, mouseY) && !this.slotReference.func_75216_d()) {
            List<String> hoverList = Arrays.asList(I18n.func_135052_a((String)this.tooltipText, (Object[])this.tooltipArgs).split("/n"));
            this.drawHoveringText(ItemStack.field_190927_a, hoverList, 300, mouseX, mouseY);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        ModularUIGui modularUIGui;
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.backgroundTexture != null) {
            for (IGuiTexture backgroundTexture : this.backgroundTexture) {
                backgroundTexture.draw(pos.x, pos.y, size.width, size.height);
            }
        }
        ItemStack itemStack = this.slotReference.func_75211_c();
        ModularUIGui modularUIGui2 = modularUIGui = this.gui == null ? null : this.gui.getModularUIGui();
        if (itemStack.func_190926_b() && modularUIGui != null && modularUIGui.getDragSplitting() && modularUIGui.getDragSplittingSlots().contains(this.slotReference)) {
            int splitSize = modularUIGui.getDragSplittingSlots().size();
            itemStack = this.gui.entityPlayer.field_71071_by.func_70445_o();
            if (!itemStack.func_190926_b() && splitSize > 1 && Container.func_94527_a((Slot)this.slotReference, (ItemStack)itemStack, (boolean)true)) {
                itemStack = itemStack.func_77946_l();
                Container.func_94525_a(modularUIGui.getDragSplittingSlots(), (int)modularUIGui.field_146987_F, (ItemStack)itemStack, (int)(this.slotReference.func_75211_c().func_190926_b() ? 0 : this.slotReference.func_75211_c().func_190916_E()));
                int k = Math.min(itemStack.func_77976_d(), this.slotReference.func_178170_b(itemStack));
                if (itemStack.func_190916_E() > k) {
                    itemStack.func_190920_e(k);
                }
            }
        }
        if (!itemStack.func_190926_b()) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179126_j();
            GlStateManager.func_179101_C();
            GlStateManager.func_179140_f();
            RenderHelper.func_74518_a();
            RenderHelper.func_74519_b();
            RenderHelper.func_74520_c();
            GlStateManager.func_179094_E();
            RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
            itemRender.func_180450_b(itemStack, pos.x + 1, pos.y + 1);
            itemRender.func_180453_a(Minecraft.func_71410_x().field_71466_p, itemStack, pos.x + 1, pos.y + 1, null);
            GlStateManager.func_179141_d();
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
        }
        if (this.isActive()) {
            if (this.slotReference instanceof ISlotWidget && this.isMouseOverElement(mouseX, mouseY)) {
                GlStateManager.func_179097_i();
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                SlotWidget.drawSolidRect(this.getPosition().x + 1, this.getPosition().y + 1, 16, 16, -2130706433);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179126_j();
                GlStateManager.func_179147_l();
            }
        } else {
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            SlotWidget.drawSolidRect(this.getPosition().x + 1, this.getPosition().y + 1, 16, 16, -1090519040);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            ModularUIGui modularUIGui = this.gui.getModularUIGui();
            boolean last = modularUIGui.getDragSplitting();
            this.gui.getModularUIGui().superMouseClicked(mouseX, mouseY, button);
            if (last != modularUIGui.getDragSplitting()) {
                modularUIGui.field_146988_G = button;
                if (button == 0) {
                    modularUIGui.field_146987_F = 0;
                } else if (button == 1) {
                    modularUIGui.field_146987_F = 1;
                } else if (Minecraft.func_71410_x().field_71474_y.field_74322_I.isActiveAndMatches(button - 100)) {
                    modularUIGui.field_146987_F = 2;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            this.gui.getModularUIGui().superMouseReleased(mouseX, mouseY, button);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            this.gui.getModularUIGui().superMouseClickMove(mouseX, mouseY, button, timeDragged);
            return true;
        }
        return false;
    }

    @Override
    protected void onPositionUpdate() {
        if (this.slotReference != null && this.sizes != null) {
            Position position = this.getPosition();
            this.slotReference.field_75223_e = position.x + 1 - this.sizes.getGuiLeft();
            this.slotReference.field_75221_f = position.y + 1 - this.sizes.getGuiTop();
        }
    }

    public SlotWidget setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public SlotWidget(IItemHandlerModifiable itemHandler, int slotIndex, int xPosition, int yPosition) {
        this((IItemHandler)itemHandler, slotIndex, xPosition, yPosition, true, true);
    }

    public SlotWidget(IInventory inventory, int slotIndex, int xPosition, int yPosition) {
        this(inventory, slotIndex, xPosition, yPosition, true, true);
    }

    public SlotWidget setBackgroundTexture(IGuiTexture ... backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public SlotWidget setLocationInfo(boolean isPlayerInventory, boolean isHotbarSlot) {
        this.locationInfo = new INativeWidget.SlotLocationInfo(isPlayerInventory, isHotbarSlot);
        return this;
    }

    public SlotWidget setTooltipText(String tooltipText, Object ... args) {
        Preconditions.checkNotNull((Object)tooltipText, (Object)"tooltipText");
        this.tooltipText = tooltipText;
        this.tooltipArgs = args;
        return this;
    }

    @Override
    public INativeWidget.SlotLocationInfo getSlotLocationInfo() {
        return this.locationInfo;
    }

    public boolean canPutStack(ItemStack stack) {
        return this.isEnabled() && this.canPutItems;
    }

    public boolean canTakeStack(EntityPlayer player) {
        return this.isEnabled() && this.canTakeItems;
    }

    public boolean isEnabled() {
        return this.isActive() && this.isVisible();
    }

    @Override
    public boolean canMergeSlot(ItemStack stack) {
        return this.isEnabled();
    }

    public void onSlotChanged() {
        this.gui.holder.markAsDirty();
    }

    @Override
    public ItemStack slotClick(int dragType, ClickType clickTypeIn, EntityPlayer player) {
        return null;
    }

    @Override
    public final Slot getHandle() {
        return this.slotReference;
    }

    public class WidgetSlotItemHandler
    extends SlotItemHandler
    implements ISlotWidget {
        boolean isHover;
        final boolean canShiftClickInto;

        public WidgetSlotItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition, boolean canShiftClickInto) {
            super(itemHandler, index, xPosition, yPosition);
            this.canShiftClickInto = canShiftClickInto;
        }

        @Override
        public void setHover(boolean isHover) {
            this.isHover = isHover;
        }

        @Override
        public boolean isHover() {
            return this.isHover;
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return SlotWidget.this.canPutStack(stack) && super.func_75214_a(stack);
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            return SlotWidget.this.canTakeStack(playerIn) && super.func_82869_a(playerIn);
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            super.func_75215_d(stack);
            if (SlotWidget.this.changeListener != null) {
                SlotWidget.this.changeListener.run();
            }
        }

        @Nonnull
        public final ItemStack func_190901_a(@Nonnull EntityPlayer thePlayer, @Nonnull ItemStack stack) {
            return SlotWidget.this.onItemTake(thePlayer, super.func_190901_a(thePlayer, stack), false);
        }

        public void func_75218_e() {
            SlotWidget.this.onSlotChanged();
        }

        public boolean func_111238_b() {
            return SlotWidget.this.isEnabled();
        }

        public boolean canShiftClickInto() {
            return this.canShiftClickInto;
        }
    }

    protected class WidgetSlot
    extends Slot
    implements ISlotWidget {
        boolean isHover;

        public WidgetSlot(IInventory inventory, int index, int xPosition, int yPosition) {
            super(inventory, index, xPosition, yPosition);
        }

        @Override
        public void setHover(boolean isHover) {
            this.isHover = isHover;
        }

        @Override
        public boolean isHover() {
            return this.isHover;
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return SlotWidget.this.canPutStack(stack) && super.func_75214_a(stack);
        }

        public boolean func_82869_a(@Nonnull EntityPlayer playerIn) {
            return SlotWidget.this.canTakeStack(playerIn) && super.func_82869_a(playerIn);
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            super.func_75215_d(stack);
            if (SlotWidget.this.changeListener != null) {
                SlotWidget.this.changeListener.run();
            }
        }

        @Nonnull
        public final ItemStack func_190901_a(@Nonnull EntityPlayer thePlayer, @Nonnull ItemStack stack) {
            return SlotWidget.this.onItemTake(thePlayer, super.func_190901_a(thePlayer, stack), false);
        }

        public void func_75218_e() {
            SlotWidget.this.onSlotChanged();
        }

        public boolean func_111238_b() {
            return SlotWidget.this.isEnabled();
        }
    }

    public static interface ISlotWidget {
        public void setHover(boolean var1);

        public boolean isHover();
    }
}

