/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.block;

import gregtech.api.GregTechAPI;
import gregtech.api.block.IStateHarvestLevel;
import gregtech.api.util.GTUtility;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VariantBlock<T extends Enum<T>>
extends Block {
    protected PropertyEnum<T> VARIANT;
    protected T[] VALUES;

    public VariantBlock(Material materialIn) {
        super(materialIn);
        if (this.VALUES.length > 0 && this.VALUES[0] instanceof IStateHarvestLevel) {
            for (T t : this.VALUES) {
                IStateHarvestLevel stateHarvestLevel = (IStateHarvestLevel)t;
                IBlockState state = this.getState(t);
                this.setHarvestLevel(stateHarvestLevel.getHarvestTool(state), stateHarvestLevel.getHarvestLevel(state), state);
            }
        }
        this.func_149647_a(GregTechAPI.TAB_GREGTECH);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(this.VARIANT, this.VALUES[0]));
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        for (T variant : this.VALUES) {
            list.add((Object)this.getItemVariant(variant));
        }
    }

    public IBlockState getState(T variant) {
        return this.func_176223_P().func_177226_a(this.VARIANT, variant);
    }

    public T getState(IBlockState blockState) {
        return (T)((Enum)((Object)blockState.func_177229_b(this.VARIANT)));
    }

    public T getState(ItemStack stack) {
        return this.getState(this.func_176203_a(stack.func_77952_i()));
    }

    public ItemStack getItemVariant(T variant) {
        return this.getItemVariant(variant, 1);
    }

    public ItemStack getItemVariant(T variant, int amount) {
        return new ItemStack((Block)this, amount, ((Enum)variant).ordinal());
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        Class enumClass = GTUtility.getActualTypeParameter(((Object)((Object)this)).getClass(), VariantBlock.class, 0);
        this.VARIANT = PropertyEnum.func_177709_a((String)"variant", enumClass);
        this.VALUES = (Enum[])enumClass.getEnumConstants();
        return new BlockStateContainer((Block)this, new IProperty[]{this.VARIANT});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(@Nonnull ItemStack stack, @Nullable World player, List<String> tooltip, @Nonnull ITooltipFlag advanced) {
        String unlocalizedTooltip;
        String unlocalizedVariantTooltip = this.func_149739_a() + ".tooltip";
        if (I18n.func_188566_a((String)unlocalizedVariantTooltip)) {
            tooltip.addAll(Arrays.asList(I18n.func_135052_a((String)unlocalizedVariantTooltip, (Object[])new Object[0]).split("/n")));
        }
        if (I18n.func_188566_a((String)(unlocalizedTooltip = stack.func_77977_a() + ".tooltip"))) {
            tooltip.addAll(Arrays.asList(I18n.func_135052_a((String)unlocalizedTooltip, (Object[])new Object[0]).split("/n")));
        }
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return this.func_176201_c(state);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.VARIANT, this.VALUES[meta % this.VALUES.length]);
    }

    public int func_176201_c(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b(this.VARIANT))).ordinal();
    }
}

