/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.entities.mobs.dungeon.skeletalking.projectile;

import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.skeletalking.EntitySkeletalKing;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.skeletalking.projectile.EntityWitherling;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.skeletalking.projectile.Skeleton;
import com.sofodev.armorplus.common.util.TextUtils;
import com.sofodev.armorplus.common.util.Utils;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWitherMinion
extends EntityFireball
implements IThrowableEntity {
    private static final DataParameter<Boolean> INVULNERABLE = EntityDataManager.func_187226_a(EntityWitherMinion.class, (DataSerializer)DataSerializers.field_187198_h);
    private Entity shooter;

    public EntityWitherMinion(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.3125f, 0.3125f);
    }

    public EntityWitherMinion(World worldIn, EntityLivingBase shooter, double accelX, double accelY, double accelZ) {
        super(worldIn, shooter, accelX, accelY, accelZ);
        this.func_70105_a(0.3125f, 0.3125f);
        this.shooter = shooter;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityWitherMinion(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(worldIn, x, y, z, accelX, accelY, accelZ);
        this.func_70105_a(0.3125f, 0.3125f);
    }

    public static void registerFixesWitherMinion(DataFixer fixer) {
        EntityFireball.func_189743_a((DataFixer)fixer, (String)"WitherMinion");
    }

    private static void setDropChance(EntityWitherling minion, EntityEquipmentSlot ... slots) {
        Arrays.stream(slots).forEachOrdered(slot -> minion.func_184642_a((EntityEquipmentSlot)slot, 0.0f));
    }

    protected float func_82341_c() {
        return super.func_82341_c();
    }

    public boolean func_70027_ad() {
        return false;
    }

    protected void func_70227_a(RayTraceResult result) {
        int min;
        if (this.field_70170_p.field_72995_K || this.field_70235_a == null || !(result.field_72308_g instanceof EntityLivingBase)) {
            return;
        }
        BlockPos blockPos = new BlockPos(result.field_72308_g);
        String phaseText = "%sRise Minions, Rise!!!";
        int amountWarriorMax = 4;
        int amountArcherMax = 3;
        int amountPaladinMax = 2;
        int warriorBound = this.field_70146_Z.nextInt(amountWarriorMax) + 1;
        int archerBound = this.field_70146_Z.nextInt(amountArcherMax) + 1;
        int paladinBound = this.field_70146_Z.nextInt(amountPaladinMax) + 1;
        if (this.checkPhase(1200.0f, 0.0f)) {
            for (min = 0; min < warriorBound; ++min) {
                EntityWitherling minionWarrior;
                if (this.checkPhase(1200.0f)) {
                    minionWarrior = this.create(blockPos);
                    this.setMinionStats(minionWarrior, Skeleton.WARRIOR_0);
                    continue;
                }
                if (this.checkPhase(1000.0f)) {
                    minionWarrior = this.create(blockPos);
                    this.setMinionStats(minionWarrior, Skeleton.WARRIOR_1);
                    continue;
                }
                minionWarrior = this.create(blockPos);
                this.spawnMinions(minionWarrior, Skeleton.WARRIOR_2, Skeleton.WARRIOR_3, Skeleton.WARRIOR_4, Skeleton.WARRIOR_5);
            }
        }
        if (this.checkPhase(800.0f, 0.0f)) {
            for (min = 0; min < archerBound; ++min) {
                EntityWitherling minionArcher = this.create(blockPos);
                this.spawnMinions(minionArcher, Skeleton.ARCHER_1, Skeleton.ARCHER_2, Skeleton.ARCHER_3, Skeleton.ARCHER_4);
            }
        }
        if (this.checkPhase(400.0f, 0.0f)) {
            for (min = 0; min < paladinBound; ++min) {
                EntityWitherling minionPaladin;
                if (this.checkPhase(400.0f)) {
                    minionPaladin = this.create(blockPos);
                    this.setMinionStats(minionPaladin, Skeleton.PALADIN_1);
                    continue;
                }
                if (!this.checkPhase(200.0f)) continue;
                minionPaladin = this.create(blockPos);
                this.setMinionStats(minionPaladin, Skeleton.PALADIN_2);
            }
        }
        if (result.field_72308_g instanceof EntityPlayer) {
            ((EntityPlayer)result.field_72308_g).func_146105_b((ITextComponent)TextUtils.translate(TextFormatting.RED, phaseText, TextFormatting.ITALIC), true);
        }
        this.func_70106_y();
    }

    private void spawnMinions(EntityWitherling minion, Skeleton one, Skeleton two, Skeleton three, Skeleton four) {
        if (this.checkPhase(800.0f)) {
            this.setMinionStats(minion, one);
        } else if (this.checkPhase(600.0f)) {
            this.setMinionStats(minion, two);
        } else if (this.checkPhase(400.0f)) {
            this.setMinionStats(minion, three);
        } else if (this.checkPhase(200.0f)) {
            this.setMinionStats(minion, four);
        }
    }

    private EntityWitherling create(BlockPos pos) {
        EntityWitherling minion = new EntityWitherling(this.field_70170_p);
        minion.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)minion, true, new Class[0]));
        minion.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)minion, EntityLiving.class, 0, false, false, EntitySkeletalKing.ANY_ENTITY));
        minion.func_70634_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        minion.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)minion)), null);
        this.field_70170_p.func_72838_d((Entity)minion);
        return minion;
    }

    private boolean checkPhase(float phase) {
        return this.checkPhase(phase, phase - 200.0f);
    }

    private boolean checkPhase(float phase, float rangeEnd) {
        float health = this.field_70235_a.func_110143_aJ();
        return health <= phase && health > rangeEnd;
    }

    private void setMinionStats(EntityWitherling witherSkeleton, Skeleton data) {
        this.setMinionStats(witherSkeleton, data.getName(), data.getHealth(), data.getWeapon(), data.getOffHand(), Utils.getItemStacks(data.getArmor()));
    }

    private void setMinionStats(EntityWitherling minion, String type, double maxHealth, ItemStack mainHand, ItemStack offHand, NonNullList<ItemStack> equipedArmor) {
        minion.func_96094_a(String.format("%sSkeletal King's %s", TextFormatting.YELLOW, type));
        minion.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(maxHealth);
        minion.func_70691_i(minion.func_110138_aP());
        minion.func_70606_j(minion.func_110138_aP());
        minion.func_184174_b(false);
        minion.func_184611_a(EnumHand.MAIN_HAND, mainHand);
        minion.func_184611_a(EnumHand.OFF_HAND, offHand);
        minion.func_184201_a(EntityEquipmentSlot.HEAD, (ItemStack)equipedArmor.get(0));
        minion.func_184201_a(EntityEquipmentSlot.CHEST, (ItemStack)equipedArmor.get(1));
        minion.func_184201_a(EntityEquipmentSlot.LEGS, (ItemStack)equipedArmor.get(2));
        minion.func_184201_a(EntityEquipmentSlot.FEET, (ItemStack)equipedArmor.get(3));
        EntityWitherMinion.setDropChance(minion, EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET);
        minion.func_174805_g(true);
        minion.func_82142_c(false);
        minion.func_184224_h(false);
        minion.func_98053_h(true);
        minion.field_98038_p = true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(INVULNERABLE, (Object)false);
    }

    protected boolean func_184564_k() {
        return false;
    }

    public Entity getThrower() {
        return this.shooter;
    }

    public void setThrower(Entity entity) {
        this.shooter = entity;
    }
}

