/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry;

import com.sofodev.armorplus.api.caps.abilities.MaterialType;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.ModBlocks;
import com.sofodev.armorplus.common.registry.items.ItemCombinedMap;
import com.sofodev.armorplus.common.registry.items.ItemFragment;
import com.sofodev.armorplus.common.registry.items.ItemUltimateParts;
import com.sofodev.armorplus.common.registry.items.armors.APArmorMaterial;
import com.sofodev.armorplus.common.registry.items.armors.ArmorMaterials;
import com.sofodev.armorplus.common.registry.items.armors.base.ItemArmorV2;
import com.sofodev.armorplus.common.registry.items.armors.base.ItemEnhancedArmor;
import com.sofodev.armorplus.common.registry.items.armors.base.ItemSpecialArmor;
import com.sofodev.armorplus.common.registry.items.armors.base.ItemUltimateArmor;
import com.sofodev.armorplus.common.registry.items.armors.horse.ItemBaseHorseArmor;
import com.sofodev.armorplus.common.registry.items.arrows.ArrowType;
import com.sofodev.armorplus.common.registry.items.arrows.ItemSpecialArrow;
import com.sofodev.armorplus.common.registry.items.base.ItemAdvanced;
import com.sofodev.armorplus.common.registry.items.base.ItemBase;
import com.sofodev.armorplus.common.registry.items.base.ItemCosmetic;
import com.sofodev.armorplus.common.registry.items.base.ItemSpecialBattleAxe;
import com.sofodev.armorplus.common.registry.items.base.ItemSpecialBow;
import com.sofodev.armorplus.common.registry.items.base.ItemSpecialPickaxe;
import com.sofodev.armorplus.common.registry.items.base.ItemSpecialSword;
import com.sofodev.armorplus.common.registry.items.base.special.Pickaxes;
import com.sofodev.armorplus.common.registry.items.books.ItemAPBook;
import com.sofodev.armorplus.common.registry.items.books.ItemLoreBook;
import com.sofodev.armorplus.common.registry.items.consumables.ItemRedstoneApple;
import com.sofodev.armorplus.common.registry.items.consumables.ItemTGOTG;
import com.sofodev.armorplus.common.registry.items.dev.ItemDevTool;
import com.sofodev.armorplus.common.registry.items.dev.ItemSpawnStructure;
import com.sofodev.armorplus.common.registry.items.enums.Cosmetics;
import com.sofodev.armorplus.common.registry.items.enums.MetalItems;
import com.sofodev.armorplus.common.registry.items.materials.ItemLavaCrystal;
import com.sofodev.armorplus.common.registry.items.materials.ItemMaterial;
import com.sofodev.armorplus.common.util.ModRegistryUtils;
import com.sofodev.armorplus.common.util.Utils;
import com.sofodev.armorplus.common.worldgen.nbt.StructureGenNBT;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="armorplus")
public class ModItems {
    public static ItemAPBook bookInfo = new ItemAPBook();
    public static ItemLoreBook bookLore = new ItemLoreBook();
    public static ItemBase steelIngot = new ItemBase(MetalItems.STEEL_INGOT);
    public static ItemBase electricalIngot = new ItemBase(MetalItems.ELECTRICAL_INGOT);
    public static ItemRedstoneApple itemRedstoneApple = new ItemRedstoneApple();
    public static ItemLavaCrystal itemLavaCrystal = new ItemLavaCrystal();
    public static ItemTGOTG itemTGOTG = new ItemTGOTG();
    public static ItemMaterial materials = new ItemMaterial();
    public static ItemAdvanced chainmail = new ItemAdvanced("chainmail", TextFormatting.GRAY, "Chainmail");
    public static ItemAdvanced guardianScale = new ItemAdvanced("guardian_scale", TextFormatting.AQUA, "Guardian Scale");
    public static ItemAdvanced witherBone = new ItemAdvanced("wither_bone", TextFormatting.WHITE, "Wither Bone");
    public static ItemAdvanced enderDragonScale = new ItemAdvanced("ender_dragon_scale", TextFormatting.DARK_PURPLE, "Ender Dragon Scale");
    public static ItemAdvanced theUltimateMaterial = new ItemAdvanced("the_ultimate_material", TextFormatting.GREEN, "The Ultimate MaterialType");
    public static ItemSpecialArmor[] coal = new ItemSpecialArmor[4];
    public static ItemSpecialArmor[] emerald = new ItemSpecialArmor[4];
    public static ItemSpecialArmor[] lapis = new ItemSpecialArmor[4];
    public static ItemSpecialArmor[] redstone = new ItemSpecialArmor[4];
    public static ItemSpecialArmor[] obsidian = new ItemSpecialArmor[4];
    public static ItemSpecialArmor[] lava = new ItemSpecialArmor[4];
    public static ItemSpecialArmor[] chicken = new ItemSpecialArmor[4];
    public static ItemSpecialArmor[] slime = new ItemSpecialArmor[4];
    public static ItemSpecialArmor[] guardian = new ItemSpecialArmor[4];
    public static ItemSpecialArmor[] superStar = new ItemSpecialArmor[4];
    public static ItemSpecialArmor[] enderDragon = new ItemSpecialArmor[4];
    public static ItemSpecialArmor[] ardite = new ItemSpecialArmor[4];
    public static ItemSpecialArmor[] cobalt = new ItemSpecialArmor[4];
    public static ItemSpecialArmor[] manyullyn = new ItemSpecialArmor[4];
    public static ItemSpecialArmor[] pigIron = new ItemSpecialArmor[4];
    public static ItemSpecialArmor[] knightSlime = new ItemSpecialArmor[4];
    public static ItemUltimateArmor[] theUltimate = new ItemUltimateArmor[4];
    public static ItemSpecialSword[] sword = new ItemSpecialSword[9];
    public static ItemSpecialBattleAxe[] battleAxe = new ItemSpecialBattleAxe[9];
    public static ItemSpecialBow[] bow = new ItemSpecialBow[9];
    public static ItemSpecialPickaxe[] pickaxe = new ItemSpecialPickaxe[9];
    public static ItemUltimateParts theUltimateParts = new ItemUltimateParts();
    public static ItemDevTool itemDevTool = new ItemDevTool();
    public static ItemCosmetic twitchItem = new ItemCosmetic(Cosmetics.TWITCH);
    public static ItemCosmetic beamItem = new ItemCosmetic(Cosmetics.BEAM);
    public static ItemCosmetic theDragonTeamItem = new ItemCosmetic(Cosmetics.THE_DRAGON_TEAM);
    public static ItemCosmetic moddedCityItem = new ItemCosmetic(Cosmetics.MODDED_CITY);
    public static ItemCosmetic jonBamsItem = new ItemCosmetic(Cosmetics.JON_BAMS);
    public static ItemCosmetic btmMoon = new ItemCosmetic(Cosmetics.BTM_MOON);
    public static ItemCosmetic m1Jordan = new ItemCosmetic(Cosmetics.M1JORDAN);
    public static ItemCosmetic teamRapture = new ItemCosmetic(Cosmetics.TEAM_RAPTURE);
    public static ItemSpecialArrow itemCoalArrow = new ItemSpecialArrow(ArrowType.COAL);
    public static ItemSpecialArrow itemLapisArrow = new ItemSpecialArrow(ArrowType.LAPIS);
    public static ItemSpecialArrow itemRedstoneArrow = new ItemSpecialArrow(ArrowType.REDSTONE);
    public static ItemSpecialArrow itemEmeraldArrow = new ItemSpecialArrow(ArrowType.EMERALD);
    public static ItemSpecialArrow itemObsidianArrow = new ItemSpecialArrow(ArrowType.OBSIDIAN);
    public static ItemSpecialArrow itemLavaArrow = new ItemSpecialArrow(ArrowType.INFUSED_LAVA);
    public static ItemSpecialArrow itemGuardianArrow = new ItemSpecialArrow(ArrowType.GUARDIAN);
    public static ItemSpecialArrow itemSuperStarArrow = new ItemSpecialArrow(ArrowType.SUPER_STAR);
    public static ItemSpecialArrow itemEnderDragonArrow = new ItemSpecialArrow(ArrowType.ENDER_DRAGON);
    public static ItemBaseHorseArmor[] horseArmors = new ItemBaseHorseArmor[9];
    public static APArmorMaterial[] horseMaterial = new APArmorMaterial[]{APArmorMaterial.COAL, APArmorMaterial.LAPIS, APArmorMaterial.REDSTONE, APArmorMaterial.EMERALD, APArmorMaterial.OBSIDIAN, APArmorMaterial.INFUSED_LAVA, APArmorMaterial.GUARDIAN, APArmorMaterial.SUPER_STAR, APArmorMaterial.ENDER_DRAGON};
    public static ItemSpawnStructure towerSpawnItem = new ItemSpawnStructure("tower_spawn_item", StructureGenNBT.TOWER);
    public static ItemSpawnStructure enderDungeonFloor1SpawnItem = new ItemSpawnStructure("ender_dungeon_floor_1_spawn_item", StructureGenNBT.ENDER_DUNGEON_FLOOR_1);
    public static ItemArmorV2[] coalExp = new ItemArmorV2[4];
    public static ItemArmorV2[] chickenExp = new ItemArmorV2[4];
    public static ItemArmorV2[] slimeExp = new ItemArmorV2[4];
    public static ItemArmorV2[] emeraldExp = new ItemArmorV2[4];
    public static ItemArmorV2[] lapisExp = new ItemArmorV2[4];
    public static ItemArmorV2[] redstoneExp = new ItemArmorV2[4];
    public static ItemArmorV2[] obsidianExp = new ItemArmorV2[4];
    public static ItemArmorV2[] lavaExp = new ItemArmorV2[4];
    public static ItemArmorV2[] guardianExp = new ItemArmorV2[4];
    public static ItemArmorV2[] superStarExp = new ItemArmorV2[4];
    public static ItemArmorV2[] enderDragonExp = new ItemArmorV2[4];
    public static ItemArmorV2[] arditeExp = new ItemArmorV2[4];
    public static ItemArmorV2[] cobaltExp = new ItemArmorV2[4];
    public static ItemArmorV2[] manyullynExp = new ItemArmorV2[4];
    public static ItemArmorV2[] pigIronExp = new ItemArmorV2[4];
    public static ItemArmorV2[] knightSlimeExp = new ItemArmorV2[4];
    public static ItemArmorV2[] ultimateExp = new ItemArmorV2[4];
    public static ItemEnhancedArmor[] iron = new ItemEnhancedArmor[4];
    public static ItemEnhancedArmor[] chain = new ItemEnhancedArmor[4];
    public static ItemEnhancedArmor[] gold = new ItemEnhancedArmor[4];
    public static ItemEnhancedArmor[] diamond = new ItemEnhancedArmor[4];
    public static ItemFragment[] fragments = new ItemFragment[4];
    public static ItemCombinedMap[] maps = new ItemCombinedMap[ItemCombinedMap.Variants.values().length];

    public static void registerItems() {
        IntStream.range(0, horseArmors.length).forEach(i -> {
            ModItems.horseArmors[i] = new ItemBaseHorseArmor(horseMaterial[i]);
        });
        ModRegistryUtils.register(chicken, APArmorMaterial.CHICKEN);
        ModRegistryUtils.register(slime, APArmorMaterial.SLIME);
        ModRegistryUtils.register(coal, APArmorMaterial.COAL);
        ModRegistryUtils.register(lapis, APArmorMaterial.LAPIS);
        ModRegistryUtils.register(redstone, APArmorMaterial.REDSTONE);
        ModRegistryUtils.register(emerald, APArmorMaterial.EMERALD);
        ModRegistryUtils.register(obsidian, APArmorMaterial.OBSIDIAN);
        ModRegistryUtils.register(lava, APArmorMaterial.INFUSED_LAVA);
        ModRegistryUtils.register(guardian, APArmorMaterial.GUARDIAN);
        ModRegistryUtils.register(superStar, APArmorMaterial.SUPER_STAR);
        ModRegistryUtils.register(enderDragon, APArmorMaterial.ENDER_DRAGON);
        ModRegistryUtils.registerAll(theUltimate);
        ModRegistryUtils.registerAll(sword);
        ModRegistryUtils.registerAll(battleAxe);
        ModRegistryUtils.registerAll(bow);
        if (ModConfig.Experimental.enableExperimentalMode) {
            ModRegistryUtils.register(chickenExp, MaterialType.CHICKEN);
            ModRegistryUtils.register(slimeExp, MaterialType.SLIME);
            ModRegistryUtils.register(coalExp, MaterialType.COAL);
            ModRegistryUtils.register(lapisExp, MaterialType.LAPIS);
            ModRegistryUtils.register(redstoneExp, MaterialType.REDSTONE);
            ModRegistryUtils.register(emeraldExp, MaterialType.EMERALD);
            ModRegistryUtils.register(obsidianExp, MaterialType.OBSIDIAN);
            ModRegistryUtils.register(lavaExp, MaterialType.INFUSED_LAVA);
            ModRegistryUtils.register(guardianExp, MaterialType.GUARDIAN);
            ModRegistryUtils.register(superStarExp, MaterialType.SUPER_STAR);
            ModRegistryUtils.register(enderDragonExp, MaterialType.ENDER_DRAGON);
            ModRegistryUtils.register(ultimateExp, MaterialType.ULTIMATE);
            ModRegistryUtils.register(arditeExp, MaterialType.ARDITE);
            ModRegistryUtils.register(cobaltExp, MaterialType.COBALT);
            ModRegistryUtils.register(manyullynExp, MaterialType.MANYULLYN);
            ModRegistryUtils.register(pigIronExp, MaterialType.PIG_IRON);
            ModRegistryUtils.register(knightSlimeExp, MaterialType.KNIGHT_SLIME);
        }
        ModRegistryUtils.register(chain, ArmorMaterials.ENHANCED_CHAIN_ARMOR, "chainmail");
        ModRegistryUtils.register(iron, ArmorMaterials.ENHANCED_IRON_ARMOR, "iron");
        ModRegistryUtils.register(gold, ArmorMaterials.ENHANCED_GOLD_ARMOR, "gold");
        ModRegistryUtils.register(diamond, ArmorMaterials.ENHANCED_DIAMOND_ARMOR, "diamond");
        IntStream.range(0, pickaxe.length).forEach(i -> {
            ModItems.pickaxe[i] = new ItemSpecialPickaxe(Pickaxes.values()[i]);
        });
        IntStream.range(0, fragments.length).forEach(i -> {
            ModItems.fragments[i] = new ItemFragment(ItemFragment.Fragments.values()[i]);
        });
        IntStream.range(0, maps.length).forEach(i -> {
            ModItems.maps[i] = new ItemCombinedMap(ItemCombinedMap.Variants.values()[i]);
        });
    }

    public static void registerTCItems() {
        ModRegistryUtils.register(ardite, APArmorMaterial.ARDITE);
        ModRegistryUtils.register(cobalt, APArmorMaterial.COBALT);
        ModRegistryUtils.register(manyullyn, APArmorMaterial.MANYULLYN);
        ModRegistryUtils.register(pigIron, APArmorMaterial.PIG_IRON);
        ModRegistryUtils.register(knightSlime, APArmorMaterial.KNIGHT_SLIME);
    }

    private static void registerItemBlock(RegistryEvent.Register<Item> event, ResourceLocation ... registryNames) {
        Arrays.stream(registryNames).forEachOrdered(regName -> {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(regName);
            if (Utils.areNotNull(block, block.getRegistryName())) {
                ItemBlock itemBlock = new ItemBlock(block);
                itemBlock.setRegistryName(block.getRegistryName());
                event.getRegistry().register((IForgeRegistryEntry)itemBlock);
            }
        });
    }

    private static void registerItemBlock(RegistryEvent.Register<Item> event, String ... locations) {
        Arrays.stream(locations).forEach(name -> ModItems.registerItemBlock(event, Utils.setRL(name)));
    }

    private static void registerItemBlock(RegistryEvent.Register<Item> event, Block ... blocks) {
        Arrays.stream(blocks).forEach(block -> ModItems.registerItemBlock(event, block.getRegistryName()));
    }

    private static void registerAllItemBlocks(RegistryEvent.Register<Item> event, Block[] ... blockArray) {
        Arrays.stream(blockArray).forEachOrdered(blockList -> ModItems.registerItemBlock(event, blockList));
    }

    private static void registerAllItems(RegistryEvent.Register<Item> event, Item[] ... itemsArray) {
        Arrays.stream(itemsArray).forEachOrdered(itemList -> ModItems.registerAllItems(event, itemList));
    }

    private static void registerAllItems(RegistryEvent.Register<Item> event, Item ... itemsArray) {
        Arrays.stream(itemsArray).filter(Utils::isNotNull).forEachOrdered(anItemsArray -> event.getRegistry().register((IForgeRegistryEntry)anItemsArray));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ModItems.registerItemBlock(event, ModBlocks.benches);
        ModItems.registerItemBlock(event, new Block[]{ModBlocks.oreLavaCrystal, ModBlocks.blockCompressedObsidian, ModBlocks.steelBlock, ModBlocks.electricalBlock, ModBlocks.blockLavaNetherBrick, ModBlocks.lavaCactus, ModBlocks.lavaInfuser, ModBlocks.lavaInfuserInfusing, ModBlocks.blockLavaInfusedObsidian, ModBlocks.blockLavaCrystal, ModBlocks.blockInfusedLavaCrystal, ModBlocks.blockCompressedLavaCrystal, ModBlocks.blockCompressedInfusedLavaCrystal, ModBlocks.blockMeltingObsidian});
        ModItems.registerAllItemBlocks(event, new Block[][]{ModBlocks.stoneBricks, ModBlocks.stoneBrickTowers, ModBlocks.stoneBrickCorners, ModBlocks.stonebrickWalls});
        ModItems.registerItemBlock(event, ModBlocks.trophies);
        ModItems.registerItemBlock(event, ModBlocks.blockSwordDisplays);
        ModItems.registerItemBlock(event, ModBlocks.blockEmptyDisplay);
        ModItems.registerItemBlock(event, ModBlocks.enderBlocks);
        ModItems.registerAllItems(event, new Item[]{bookInfo, bookLore, steelIngot, electricalIngot, itemRedstoneApple, itemLavaCrystal, itemTGOTG, itemDevTool, theUltimateParts, itemCoalArrow, itemLapisArrow, itemRedstoneArrow, itemEmeraldArrow, itemObsidianArrow, itemLavaArrow, itemGuardianArrow, itemSuperStarArrow, itemEnderDragonArrow});
        ModItems.registerAllItems(event, materials);
        ModItems.registerAllItems(event, towerSpawnItem, enderDungeonFloor1SpawnItem);
        ModItems.registerAllItems(event, twitchItem, beamItem, theDragonTeamItem, moddedCityItem, jonBamsItem, btmMoon, m1Jordan, teamRapture);
        ModItems.registerAllItems(event, new Item[][]{coal, lapis, redstone, emerald, obsidian, lava, chicken, slime, guardian, superStar, enderDragon, theUltimate, ardite, cobalt, manyullyn, pigIron, knightSlime});
        if (ModConfig.Experimental.enableExperimentalMode) {
            ModItems.registerAllItems(event, new Item[][]{coalExp, lapisExp, redstoneExp, emeraldExp, obsidianExp, lavaExp, chickenExp, slimeExp, guardianExp, superStarExp, enderDragonExp, ultimateExp, arditeExp, cobaltExp, manyullynExp, pigIronExp, knightSlimeExp});
        }
        ModItems.registerAllItems(event, (Item[])horseArmors);
        ModItems.registerAllItems(event, new Item[][]{sword, battleAxe, bow});
        ModItems.registerAllItems(event, new Item[][]{chain, iron, gold, diamond});
        ModItems.registerAllItems(event, new Item[][]{pickaxe, fragments, maps});
    }
}

