/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.client.misc;

import com.sofodev.armorplus.client.misc.RenderCosmetics;
import com.sofodev.armorplus.client.misc.ThreadCosmeticsFetcher;
import com.sofodev.armorplus.client.utils.RenderEntityHelper;
import com.sofodev.armorplus.common.registry.entities.mobs.dungeon.skeletalking.EntitySkeletalKing;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="armorplus")
public class CosmeticsRenderInit {
    private static final HashMap<String, RenderCosmetics> COSMETICS_FOR_PEOPLE_LIST = new HashMap();

    public CosmeticsRenderInit() {
        new ThreadCosmeticsFetcher();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void parse(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            int meta;
            String[] values = properties.getProperty(key).split("@");
            if (values.length <= 0) continue;
            String registryName = values[0];
            try {
                meta = Integer.parseInt(values[1]);
            }
            catch (Exception e) {
                meta = 0;
            }
            ItemStack stack = ItemStack.field_190927_a;
            ResourceLocation resLoc = new ResourceLocation(registryName);
            if (Item.field_150901_e.func_148741_d((Object)resLoc)) {
                stack = ItemStackUtils.getItemStack((Object)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(resLoc)), (int)meta);
            } else if (Block.field_149771_c.func_148741_d((Object)resLoc)) {
                stack = ItemStackUtils.getItemStack((Object)Objects.requireNonNull(ForgeRegistries.BLOCKS.getValue(resLoc)), (int)meta);
            }
            if (stack.func_190926_b()) continue;
            COSMETICS_FOR_PEOPLE_LIST.put(key, new RenderCosmetics(stack));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    @SideOnly(value=Side.CLIENT)
    public static void onPlayerRender(RenderPlayerEvent.Pre event) {
        if (!COSMETICS_FOR_PEOPLE_LIST.isEmpty()) {
            for (Map.Entry<String, RenderCosmetics> entry : COSMETICS_FOR_PEOPLE_LIST.entrySet()) {
                String playerName = event.getEntityPlayer().func_70005_c_();
                if (entry.getKey() == null || !entry.getKey().equalsIgnoreCase(playerName)) continue;
                if (playerName.equals("sokratis12GR")) {
                    boolean canShow;
                    EntityPlayer player = event.getEntityPlayer();
                    boolean bl = canShow = player.func_82150_aj() || !player.func_175148_a(EnumPlayerModelParts.CAPE) || player.func_70644_a(MobEffects.field_76441_p);
                    if (canShow) {
                        return;
                    }
                    EntitySkeletalKing king = new EntitySkeletalKing((World)Minecraft.func_71410_x().field_71441_e);
                    RenderEntityHelper.renderBoss((Entity)king, event.getEntityPlayer(), event.getPartialRenderTick());
                }
                RenderCosmetics.render(entry.getValue(), event.getEntityPlayer(), event.getPartialRenderTick());
                break;
            }
        }
    }
}

