/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.api.caps.ailments;

import com.sofodev.armorplus.api.caps.abilities.ISpecialItem;
import com.sofodev.armorplus.api.caps.ailments.Ailment;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AilmentHandler {
    @CapabilityInject(value=IAilment.class)
    public static final Capability<IAilment> CAPABILITY_AILMENTS = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IAilment.class, (Capability.IStorage)new Storage(), (Callable)new Factory());
        MinecraftForge.EVENT_BUS.register((Object)new AilmentHandler());
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (ModConfig.Experimental.enableExperimentalMode && ((ItemStack)event.getObject()).func_77973_b() instanceof ISpecialItem) {
            event.addCapability(Utils.setRL("ailments"), (ICapabilityProvider)new Provider());
        }
    }

    public static IAilment getHandler(ItemStack stack) {
        if (ModConfig.Experimental.enableExperimentalMode && stack.func_77973_b() instanceof ISpecialItem) {
            return stack.hasCapability(CAPABILITY_AILMENTS, null) ? (IAilment)stack.getCapability(CAPABILITY_AILMENTS, null) : null;
        }
        return null;
    }

    public static class Factory
    implements Callable<IAilment> {
        @Override
        public IAilment call() throws Exception {
            return new DefaultAilment();
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        IAilment instance = (IAilment)CAPABILITY_AILMENTS.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability.equals(CAPABILITY_AILMENTS);
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? CAPABILITY_AILMENTS.cast((Object)this.instance) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)CAPABILITY_AILMENTS.getStorage().writeNBT(CAPABILITY_AILMENTS, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            CAPABILITY_AILMENTS.getStorage().readNBT(CAPABILITY_AILMENTS, (Object)this.instance, null, (NBTBase)nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<IAilment> {
        public NBTBase writeNBT(Capability<IAilment> capability, IAilment instance, EnumFacing side) {
            NBTTagCompound tag = new NBTTagCompound();
            if (instance != null) {
                NBTTagList tagList = new NBTTagList();
                List<Ailment> ailments = instance.getAilments();
                List ailment = ailments.stream().map(Ailment::getSafeName).collect(Collectors.toList());
                ailment.stream().map(NBTTagString::new).forEach(arg_0 -> ((NBTTagList)tagList).func_74742_a(arg_0));
                tag.func_74782_a("ailments", (NBTBase)tagList);
            }
            return tag;
        }

        public void readNBT(Capability<IAilment> capability, IAilment instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            NBTTagList tagList = tag.func_150295_c("ailments", 8);
            int bound = tagList.func_74745_c();
            List<Ailment> ailments = IntStream.range(0, bound).mapToObj(arg_0 -> ((NBTTagList)tagList).func_150307_f(arg_0)).map(Ailment::getAilment).collect(Collectors.toList());
            instance.setAilments(ailments);
        }
    }

    public static class DefaultAilment
    extends IForgeRegistryEntry.Impl<DefaultAilment>
    implements IAilment {
        private ArrayList<Ailment> ailments = new ArrayList();

        @Override
        public List<Ailment> getAilments() {
            return this.ailments;
        }

        @Override
        public void setAilments(List<Ailment> abilities) {
            this.ailments.clear();
            this.ailments.addAll(abilities);
        }

        @Override
        public void addAilment(Ailment ability) {
            if (!this.ailments.contains((Object)ability)) {
                this.ailments.add(ability);
            }
        }

        @Override
        public void removeAilment(Ailment ability) {
            if (!this.ailments.isEmpty()) {
                this.ailments.remove((Object)ability);
            }
        }
    }

    public static interface IAilment {
        public List<Ailment> getAilments();

        public void setAilments(List<Ailment> var1);

        public void addAilment(Ailment var1);

        public void removeAilment(Ailment var1);
    }
}

