/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui.widget;

import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.ValidatedSlot;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui.ConcreteContainer;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui.client.GuiDrawing;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui.widget.WWidget;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WItemSlot
extends WWidget {
    private final List<Slot> peers = Lists.newArrayList();
    private IInventory inventory;
    private int startIndex = 0;
    private int slotsWide = 1;
    private int slotsHigh = 1;
    private boolean big = false;

    public WItemSlot(IInventory inventory, int startIndex, int slotsWide, int slotsHigh, boolean big, boolean ltr) {
        this.inventory = inventory;
        this.startIndex = startIndex;
        this.slotsWide = slotsWide;
        this.slotsHigh = slotsHigh;
        this.big = big;
    }

    private WItemSlot() {
    }

    public static WItemSlot of(IInventory inventory, int index) {
        WItemSlot w = new WItemSlot();
        w.inventory = inventory;
        w.startIndex = index;
        return w;
    }

    public static WItemSlot of(IInventory inventory, int startIndex, int slotsWide, int slotsHigh) {
        WItemSlot w = new WItemSlot();
        w.inventory = inventory;
        w.startIndex = startIndex;
        w.slotsWide = slotsWide;
        w.slotsHigh = slotsHigh;
        return w;
    }

    public static WItemSlot outputOf(IInventory inventory, int index) {
        WItemSlot w = new WItemSlot();
        w.inventory = inventory;
        w.startIndex = index;
        w.big = true;
        return w;
    }

    public static WItemSlot ofPlayerStorage(IInventory inventory) {
        WItemSlot w = new WItemSlot();
        w.inventory = inventory;
        w.startIndex = 9;
        w.slotsWide = 9;
        w.slotsHigh = 3;
        return w;
    }

    @Override
    public int getWidth() {
        return this.slotsWide * 18;
    }

    @Override
    public int getHeight() {
        return this.slotsHigh * 18;
    }

    @Override
    public void createPeers(ConcreteContainer c) {
        this.peers.clear();
        int index = this.startIndex;
        for (int y = 0; y < this.slotsHigh; ++y) {
            for (int x = 0; x < this.slotsWide; ++x) {
                ValidatedSlot slot = new ValidatedSlot(this.inventory, index, this.getAbsoluteX() + x * 18, this.getAbsoluteY() + y * 18);
                this.peers.add(slot);
                c.addSlotPeer(slot);
                ++index;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void paintBackground(int x, int y) {
        for (int xi = 0; xi < this.slotsWide; ++xi) {
            for (int yi = 0; yi < this.slotsHigh; ++yi) {
                if (this.big) {
                    GuiDrawing.drawBeveledPanel(xi * 18 + x - 4, yi * 18 + y - 4, 24, 24, -2013265920, 0x22000000, -1996488705);
                    continue;
                }
                GuiDrawing.drawBeveledPanel(xi * 18 + x - 1, yi * 18 + y - 1, 18, 18, -2013265920, 0x22000000, -1996488705);
            }
        }
    }
}

