/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.tile;

import com.elytradev.architecture.common.block.BlockArchitecture;
import com.elytradev.architecture.common.block.BlockHelper;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.helpers.Vector3;
import com.elytradev.architecture.common.utils.ReflectionUtils;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class TileArchitecture
extends TileEntity {
    protected static Field changedSectionFilter = ReflectionUtils.getFieldDef(ReflectionUtils.classForName("net.minecraft.server.management.PlayerChunkMapEntry"), "changedSectionFilter", "field_187288_h");
    public ForgeChunkManager.Ticket chunkTicket;
    protected boolean updateChunk;
    private byte side;
    private byte turn;

    public static ItemStack blockStackWithTileEntity(Block block, int size, TileArchitecture te) {
        return TileArchitecture.blockStackWithTileEntity(block, size, 0, te);
    }

    public static ItemStack blockStackWithTileEntity(Block block, int size, int meta, TileArchitecture te) {
        ItemStack stack = new ItemStack(block, size, meta);
        if (te != null) {
            NBTTagCompound tag = new NBTTagCompound();
            te.writeToItemStackNBT(tag);
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public void sendTileEntityUpdate() {
        SPacketUpdateTileEntity packet = this.func_189518_D_();
        if (packet != null) {
            BlockPos pos = this.func_174877_v();
            int x = pos.func_177958_n() >> 4;
            int z = pos.func_177952_p() >> 4;
            WorldServer world = (WorldServer)this.func_145831_w();
            PlayerList cm = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
            PlayerChunkMap pm = world.func_184164_w();
            for (EntityPlayerMP player : cm.func_181057_v()) {
                if (!pm.func_72694_a(player, x, z)) continue;
                player.field_71135_a.func_147359_a((Packet)packet);
            }
        }
    }

    public int getX() {
        return this.field_174879_c.func_177958_n();
    }

    public int getY() {
        return this.field_174879_c.func_177956_o();
    }

    public int getZ() {
        return this.field_174879_c.func_177952_p();
    }

    public void setSide(int side) {
        this.setSide((byte)side);
    }

    public void setTurn(int turn) {
        this.setTurn((byte)turn);
    }

    public Trans3 localToGlobalRotation() {
        return this.localToGlobalTransformation(Vector3.zero);
    }

    public Trans3 localToGlobalTransformation() {
        return this.localToGlobalTransformation(Vector3.blockCenter(this.field_174879_c));
    }

    public Trans3 localToGlobalTransformation(Vector3 origin) {
        return this.localToGlobalTransformation(origin, this.field_145850_b.func_180495_p(this.field_174879_c));
    }

    public Trans3 localToGlobalTransformation(Vector3 origin, IBlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof BlockArchitecture) {
            return ((BlockArchitecture)block).localToGlobalTransformation((IBlockAccess)this.field_145850_b, this.field_174879_c, state, this, origin);
        }
        return new Trans3(origin);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.syncWithClient()) {
            this.func_189515_b(nbt);
        }
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        if (this.syncWithClient()) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_189515_b(nbt);
            if (this.updateChunk) {
                nbt.func_74757_a("updateChunk", true);
                this.updateChunk = false;
            }
            return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.func_145839_a(nbt);
        if (nbt.func_74767_n("updateChunk")) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    boolean syncWithClient() {
        return true;
    }

    public void markBlockForUpdate() {
        this.updateChunk = true;
        BlockHelper.markBlockForUpdate(this.field_145850_b, this.field_174879_c);
    }

    public void markForUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            int x = this.field_174879_c.func_177958_n();
            int y = this.field_174879_c.func_177956_o();
            int z = this.field_174879_c.func_177952_p();
            PlayerChunkMap pm = ((WorldServer)this.field_145850_b).func_184164_w();
            PlayerChunkMapEntry entry = pm.func_187301_b(x >> 4, z >> 4);
            if (entry != null) {
                int oldFlags = ReflectionUtils.getIntField(entry, changedSectionFilter);
                entry.func_187265_a(x & 0xF, y, z & 0xF);
                ReflectionUtils.setIntField(entry, changedSectionFilter, oldFlags);
            }
        }
    }

    public void playSoundEffect(SoundEvent name, float volume, float pitch) {
        this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, name, SoundCategory.BLOCKS, volume, pitch);
    }

    public abstract void onAddedToWorld();

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setSide(nbt.func_74771_c("side"));
        this.setTurn(nbt.func_74771_c("turn"));
        this.readContentsFromNBT(nbt);
    }

    public void readFromItemStack(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            this.readFromItemStackNBT(nbt);
        }
    }

    public void readFromItemStackNBT(NBTTagCompound nbt) {
        this.readContentsFromNBT(nbt);
    }

    public void readContentsFromNBT(NBTTagCompound nbt) {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.getSide() != 0) {
            nbt.func_74774_a("side", this.getSide());
        }
        if (this.getTurn() != 0) {
            nbt.func_74774_a("turn", this.getTurn());
        }
        this.writeContentsToNBT(nbt);
        return nbt;
    }

    public void writeToItemStackNBT(NBTTagCompound nbt) {
        this.writeContentsToNBT(nbt);
    }

    public void writeContentsToNBT(NBTTagCompound nbt) {
    }

    public void markChanged() {
        this.func_70296_d();
        this.markForUpdate();
    }

    public void markBlockChanged() {
        this.func_70296_d();
        this.markBlockForUpdate();
    }

    public void func_145843_s() {
        this.releaseChunkTicket();
        super.func_145843_s();
    }

    public void releaseChunkTicket() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
    }

    public ItemStack newItemStack(int size) {
        return TileArchitecture.blockStackWithTileEntity(this.func_145838_q(), size, this);
    }

    public byte getSide() {
        return this.side;
    }

    public void setSide(byte side) {
        this.side = side;
    }

    public byte getTurn() {
        return this.turn;
    }

    public void setTurn(byte turn) {
        this.turn = turn;
    }
}

