/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.core.AppEng;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class PacketInformPlayer
extends AppEngPacket {
    private IAEItemStack actualItem = null;
    private IAEItemStack reportedItem = null;
    private final InfoType type;

    public PacketInformPlayer(ByteBuf stream) throws IOException {
        this.type = InfoType.values()[stream.readInt()];
        switch (this.type) {
            case PARTIAL_ITEM_EXTRACTION: {
                this.reportedItem = AEItemStack.fromPacket(stream);
                this.actualItem = AEItemStack.fromPacket(stream);
                break;
            }
            case NO_ITEMS_EXTRACTED: {
                this.reportedItem = AEItemStack.fromPacket(stream);
            }
        }
    }

    public PacketInformPlayer(IAEItemStack expected, IAEItemStack actual, InfoType type) throws IOException {
        this.reportedItem = expected;
        this.actualItem = actual;
        this.type = type;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(type.ordinal());
        this.reportedItem.writeToPacket(data);
        if (this.actualItem != null) {
            this.actualItem.writeToPacket(data);
        }
        this.configureWrite(data);
    }

    @Override
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        Object msg = null;
        if (this.type == InfoType.PARTIAL_ITEM_EXTRACTION) {
            AppEng.proxy.getPlayers().get(0).func_146105_b((ITextComponent)new TextComponentString("System reported " + this.reportedItem.getStackSize() + " " + this.reportedItem.getItem().func_77653_i(this.reportedItem.getDefinition()) + " available but could only extract " + this.actualItem.getStackSize()), false);
        } else if (this.type == InfoType.NO_ITEMS_EXTRACTED) {
            AppEng.proxy.getPlayers().get(0).func_146105_b((ITextComponent)new TextComponentString("System reported " + this.reportedItem.getStackSize() + " " + this.reportedItem.getItem().func_77653_i(this.reportedItem.getDefinition()) + " available but could not extract anything"), false);
        }
    }

    public static enum InfoType {
        PARTIAL_ITEM_EXTRACTION,
        NO_ITEMS_EXTRACTED;

    }
}

