/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IOrientable;
import appeng.block.AEBaseBlock;
import appeng.block.UnlistedDirection;
import appeng.block.networking.BlockCableBus;
import appeng.core.sync.GuiBridge;
import appeng.helpers.ICustomCollision;
import appeng.items.tools.quartz.ToolQuartzCuttingKnife;
import appeng.tile.AEBaseInvTile;
import appeng.tile.AEBaseTile;
import appeng.tile.networking.TileCableBus;
import appeng.tile.storage.TileSkyChest;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class AEBaseTileBlock
extends AEBaseBlock
implements ITileEntityProvider {
    @Nonnull
    private Class<? extends AEBaseTile> tileEntityType;
    public static final UnlistedDirection FORWARD = new UnlistedDirection("forward");
    public static final UnlistedDirection UP = new UnlistedDirection("up");

    public AEBaseTileBlock(Material mat) {
        super(mat);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!(state instanceof IExtendedBlockState)) {
            return state;
        }
        Object tile = this.getTileEntity(world, pos);
        if (tile == null) {
            return state;
        }
        IExtendedBlockState extState = (IExtendedBlockState)state;
        return extState.withProperty((IUnlistedProperty)FORWARD, (Object)((AEBaseTile)tile).getForward()).withProperty((IUnlistedProperty)UP, (Object)((AEBaseTile)tile).getUp());
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, this.getAEStates(), new IUnlistedProperty[]{FORWARD, UP});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public void setTileEntity(Class<? extends AEBaseTile> c) {
        this.tileEntityType = c;
        this.setInventory(AEBaseInvTile.class.isAssignableFrom(c));
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.hasBlockTileEntity();
    }

    private boolean hasBlockTileEntity() {
        return this.tileEntityType != null;
    }

    public Class<? extends AEBaseTile> getTileEntityClass() {
        return this.tileEntityType;
    }

    @Nullable
    public <T extends AEBaseTile> T getTileEntity(IBlockAccess w, int x, int y, int z) {
        return this.getTileEntity(w, new BlockPos(x, y, z));
    }

    @Nullable
    public <T extends AEBaseTile> T getTileEntity(IBlockAccess w, BlockPos pos) {
        if (!this.hasBlockTileEntity()) {
            return null;
        }
        TileEntity te = w.func_175625_s(pos);
        if (this.tileEntityType.isInstance(te)) {
            return (T)((AEBaseTile)te);
        }
        return null;
    }

    public final TileEntity func_149915_a(World var1, int var2) {
        if (this.hasBlockTileEntity()) {
            try {
                return this.tileEntityType.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Failed to create a new instance of an illegal class " + this.tileEntityType, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to create a new instance of " + this.tileEntityType + ", because lack of permissions", e);
            }
        }
        return null;
    }

    public void func_180663_b(World w, BlockPos pos, IBlockState state) {
        Object te = this.getTileEntity((IBlockAccess)w, pos);
        if (te != null) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            if (((AEBaseTile)te).dropItems()) {
                ((AEBaseTile)te).getDrops(w, pos, drops);
            } else {
                ((AEBaseTile)te).getNoDrops(w, pos, drops);
            }
            Platform.spawnDrops(w, pos, drops);
        }
        super.func_180663_b(w, pos, state);
    }

    @Override
    public final EnumFacing[] getValidRotations(World w, BlockPos pos) {
        Object obj = this.getTileEntity((IBlockAccess)w, pos);
        if (obj != null && ((AEBaseTile)obj).canBeRotated()) {
            return EnumFacing.field_82609_l;
        }
        return super.getValidRotations(w, pos);
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        Object te = this.getTileEntity((IBlockAccess)world, pos);
        if (te instanceof IColorableTile) {
            AEColor newColor;
            IColorableTile ct = (IColorableTile)te;
            AEColor c = ct.getColor();
            if (c != (newColor = AEColor.values()[color.func_176765_a()])) {
                ct.recolourBlock(side, newColor, null);
                return true;
            }
            return false;
        }
        return super.recolorBlock(world, pos, side, color);
    }

    @Override
    public int func_180641_l(IBlockState state, World w, BlockPos pos) {
        AEBaseInvTile invTile;
        Object te = this.getTileEntity((IBlockAccess)w, pos);
        if (te instanceof AEBaseInvTile && (invTile = (AEBaseInvTile)te).getInternalInventory().getSlots() > 0) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)invTile.getInternalInventory());
        }
        return 0;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, worldIn, pos, eventID, eventParam);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(eventID, eventParam);
    }

    public void func_180633_a(World w, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack is) {
        Object te;
        if (is.func_82837_s() && (te = this.getTileEntity((IBlockAccess)w, pos)) instanceof AEBaseTile) {
            ((AEBaseTile)w.func_175625_s(pos)).setName(is.func_82833_r());
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player != null && !player.func_184586_b(hand).func_190926_b()) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (Platform.isWrench(player, heldItem, pos) && player.func_70093_af()) {
                IBlockState blockState = world.func_180495_p(pos);
                Block block = blockState.func_177230_c();
                if (block == null) {
                    return false;
                }
                Object tile = this.getTileEntity((IBlockAccess)world, pos);
                if (tile == null) {
                    return false;
                }
                if (tile instanceof TileCableBus || tile instanceof TileSkyChest) {
                    return false;
                }
                Object[] itemDropCandidates = Platform.getBlockDrops(world, pos);
                ItemStack op = new ItemStack((Block)this);
                for (ItemStack itemStack : itemDropCandidates) {
                    NBTTagCompound tag;
                    if (!Platform.itemComparisons().isEqualItemType(itemStack, op) || (tag = ((AEBaseTile)tile).downloadSettings(SettingsFrom.DISMANTLE_ITEM)) == null) continue;
                    itemStack.func_77982_d(tag);
                }
                if (block.removedByPlayer(blockState, world, pos, player, false)) {
                    ArrayList itemsToDrop = Lists.newArrayList((Object[])itemDropCandidates);
                    Platform.spawnDrops(world, pos, itemsToDrop);
                    world.func_175698_g(pos);
                }
                return false;
            }
            if (heldItem.func_77973_b() instanceof IMemoryCard && !(this instanceof BlockCableBus)) {
                IMemoryCard memoryCard = (IMemoryCard)heldItem.func_77973_b();
                Object tileEntity = this.getTileEntity((IBlockAccess)world, pos);
                if (tileEntity == null) {
                    return false;
                }
                String name = this.func_149739_a();
                if (player.func_70093_af()) {
                    NBTTagCompound data = ((AEBaseTile)tileEntity).downloadSettings(SettingsFrom.MEMORY_CARD);
                    if (data != null) {
                        memoryCard.setMemoryCardContents(heldItem, name, data);
                        memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                    }
                } else {
                    String savedName = memoryCard.getSettingsName(heldItem);
                    NBTTagCompound data = memoryCard.getData(heldItem);
                    if (this.func_149739_a().equals(savedName)) {
                        ((AEBaseTile)tileEntity).uploadSettings(SettingsFrom.MEMORY_CARD, data, player);
                        memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                    } else {
                        memoryCard.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
                    }
                }
                return true;
            }
            if (heldItem.func_77973_b() instanceof ToolQuartzCuttingKnife && !(this instanceof BlockCableBus)) {
                if (ForgeEventFactory.onItemUseStart((EntityLivingBase)player, (ItemStack)heldItem, (int)1) <= 0) {
                    return false;
                }
                Object tile = this.getTileEntity((IBlockAccess)world, pos);
                if (tile == null) {
                    return false;
                }
                Platform.openGUI(player, tile, AEPartLocation.fromFacing(facing), GuiBridge.GUI_RENAMER);
                return true;
            }
        }
        return this.onActivated(world, pos, player, hand, player.func_184586_b(hand), facing, hitX, hitY, hitZ);
    }

    @Override
    public IOrientable getOrientable(IBlockAccess w, BlockPos pos) {
        return this.getTileEntity(w, pos);
    }

    @Override
    public ICustomCollision getCustomCollision(World w, BlockPos pos) {
        Object te = this.getTileEntity((IBlockAccess)w, pos);
        if (te instanceof ICustomCollision) {
            return (ICustomCollision)te;
        }
        return super.getCustomCollision(w, pos);
    }
}

