/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page;

import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookEye;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.common.multiblock.Multiblock;
import vazkii.patchouli.common.multiblock.MultiblockRegistry;
import vazkii.patchouli.common.multiblock.SerializedMultiblock;

public class PageMultiblock
extends PageWithText {
    String name;
    @SerializedName(value="multiblock_id")
    String multiblockId;
    @SerializedName(value="multiblock")
    SerializedMultiblock serializedMultiblock;
    @SerializedName(value="enable_visualize")
    boolean showVisualizeButton = true;
    transient Multiblock multiblockObj;
    transient GuiButton visualizeButton;
    private final transient Set<TileEntity> erroredTiles = Collections.newSetFromMap(new WeakHashMap());

    @Override
    public void build(BookEntry entry, int pageNum) {
        IMultiblock mb;
        if (this.multiblockId != null && !this.multiblockId.isEmpty() && (mb = MultiblockRegistry.MULTIBLOCKS.get(new ResourceLocation(this.multiblockId))) instanceof Multiblock) {
            this.multiblockObj = (Multiblock)mb;
        }
        if (this.multiblockObj == null && this.serializedMultiblock != null) {
            this.multiblockObj = this.serializedMultiblock.toMultiblock();
        }
        if (this.multiblockObj == null) {
            throw new IllegalArgumentException("No multiblock located for " + this.multiblockId);
        }
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        if (this.showVisualizeButton) {
            this.visualizeButton = new GuiButtonBookEye(parent, 12, 97);
            this.addButton(this.visualizeButton);
        }
    }

    @Override
    public int getTextHeight() {
        return 115;
    }

    @Override
    public void render(int mouseX, int mouseY, float pticks) {
        int x = 5;
        int y = 7;
        GlStateManager.func_179147_l();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GuiBook.drawFromTexture(this.book, x, y, 405, 149, 106, 106);
        this.parent.drawCenteredStringNoShadow(this.name, 58, 0, this.book.headerColor);
        if (this.multiblockObj != null) {
            this.renderMultiblock();
        }
        super.render(mouseX, mouseY, pticks);
    }

    @Override
    protected void onButtonClicked(GuiButton button) {
        if (button == this.visualizeButton) {
            String entryKey = this.parent.getEntry().getResource().toString();
            PersistentData.DataHolder.BookData.Bookmark bookmark = new PersistentData.DataHolder.BookData.Bookmark(entryKey, this.pageNum / 2);
            MultiblockVisualizationHandler.setMultiblock(this.multiblockObj, this.name, bookmark, true);
            this.parent.addBookmarkButtons();
            if (!PersistentData.data.clickedVisualize) {
                PersistentData.data.clickedVisualize = true;
                PersistentData.save();
            }
        }
    }

    private void renderMultiblock() {
        float maxX = 90.0f;
        float maxY = 90.0f;
        float diag = (float)Math.sqrt(this.multiblockObj.sizeX * this.multiblockObj.sizeX + this.multiblockObj.sizeZ * this.multiblockObj.sizeZ);
        float height = this.multiblockObj.sizeY;
        float scaleX = maxX / diag;
        float scaleY = maxY / height;
        float scale = -Math.min(scaleX, scaleY);
        int xPos = 58;
        int yPos = 60;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)xPos, (float)yPos, (float)100.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)(-((float)this.multiblockObj.sizeX) / 2.0f), (float)(-((float)this.multiblockObj.sizeY) / 2.0f), (float)0.0f);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.setIdentity();
        GlStateManager.func_179114_b((float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        rotMat.rotX((float)Math.toRadians(30.0));
        float offX = (float)(-this.multiblockObj.sizeX) / 2.0f;
        float offZ = (float)(-this.multiblockObj.sizeZ) / 2.0f + 1.0f;
        float time = (float)this.parent.ticksInBook * 0.5f;
        if (!GuiScreen.func_146272_n()) {
            time += ClientTicker.partialTicks;
        }
        GlStateManager.func_179109_b((float)(-offX), (float)0.0f, (float)(-offZ));
        GlStateManager.func_179114_b((float)time, (float)0.0f, (float)1.0f, (float)0.0f);
        rotMat.rotY((float)Math.toRadians(-time));
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        rotMat.rotY((float)Math.toRadians(-45.0));
        GlStateManager.func_179109_b((float)offX, (float)0.0f, (float)offZ);
        rotMat.transform((Tuple4f)eye);
        this.renderElements(this.multiblockObj, BlockPos.func_177975_b((BlockPos)BlockPos.field_177992_a, (BlockPos)new BlockPos(this.multiblockObj.sizeX - 1, this.multiblockObj.sizeY - 1, this.multiblockObj.sizeZ - 1)), eye);
        GlStateManager.func_179121_F();
    }

    private void renderElements(Multiblock mb, Iterable<? extends BlockPos> blocks, Vector4f eye) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
        TileEntityRendererDispatcher.field_147556_a.field_147560_j = eye.x;
        TileEntityRendererDispatcher.field_147556_a.field_147561_k = eye.y;
        TileEntityRendererDispatcher.field_147556_a.field_147558_l = eye.z;
        TileEntityRendererDispatcher.field_147554_b = eye.x;
        TileEntityRendererDispatcher.field_147555_c = eye.y;
        TileEntityRendererDispatcher.field_147552_d = eye.z;
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            if (layer == BlockRenderLayer.TRANSLUCENT) {
                this.doTileEntityRenderPass(mb, blocks, 0);
            }
            this.doWorldRenderPass(mb, blocks, layer, eye);
            if (layer != BlockRenderLayer.TRANSLUCENT) continue;
            this.doTileEntityRenderPass(mb, blocks, 1);
        }
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
        ForgeHooksClient.setRenderPass((int)-1);
        this.setGlStateForPass(0);
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179121_F();
    }

    private void doWorldRenderPass(Multiblock mb, Iterable<? extends BlockPos> blocks, @Nonnull BlockRenderLayer layer, Vector4f eye) {
        this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
        this.setGlStateForPass(layer);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (BlockPos blockPos : blocks) {
            IBlockState bs = mb.func_180495_p(blockPos);
            Block block = bs.func_177230_c();
            if (!block.canRenderInLayer(bs = bs.func_185899_b((IBlockAccess)mb, blockPos), layer)) continue;
            this.renderBlock(bs, blockPos, mb, Tessellator.func_178181_a().func_178180_c());
        }
        if (layer == BlockRenderLayer.TRANSLUCENT) {
            wr.func_181674_a(eye.x, eye.y, eye.z);
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public void renderBlock(@Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Multiblock mb, @Nonnull BufferBuilder worldRendererIn) {
        try {
            BlockRendererDispatcher blockrendererdispatcher = this.mc.func_175602_ab();
            EnumBlockRenderType type = state.func_185901_i();
            if (type != EnumBlockRenderType.MODEL) {
                blockrendererdispatcher.func_175018_a(state, pos, (IBlockAccess)mb, worldRendererIn);
                return;
            }
            IBakedModel ibakedmodel = blockrendererdispatcher.func_184389_a(state);
            state = state.func_177230_c().getExtendedState(state, (IBlockAccess)mb, pos);
            blockrendererdispatcher.func_175019_b().func_178267_a((IBlockAccess)mb, ibakedmodel, state, pos, worldRendererIn, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void doTileEntityRenderPass(Multiblock mb, Iterable<? extends BlockPos> blocks, int pass) {
        mb.setWorld((World)this.mc.field_71441_e);
        RenderHelper.func_74519_b();
        GlStateManager.func_179145_e();
        ForgeHooksClient.setRenderPass((int)1);
        this.setGlStateForPass(1);
        for (BlockPos blockPos : blocks) {
            TileEntity te = mb.func_175625_s(blockPos);
            BlockPos relPos = new BlockPos((Entity)this.mc.field_71439_g);
            if (te == null || this.erroredTiles.contains(te) || !te.shouldRenderInPass(pass)) continue;
            te.func_145834_a((World)this.mc.field_71441_e);
            te.func_174878_a(relPos.func_177971_a((Vec3i)blockPos));
            try {
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(te, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), ClientTicker.partialTicks);
            }
            catch (Exception e) {
                this.erroredTiles.add(te);
                e.printStackTrace();
            }
        }
        ForgeHooksClient.setRenderPass((int)-1);
        RenderHelper.func_74518_a();
    }

    private void setGlStateForPass(@Nonnull BlockRenderLayer layer) {
        int pass = layer == BlockRenderLayer.TRANSLUCENT ? 1 : 0;
        this.setGlStateForPass(pass);
    }

    private void setGlStateForPass(int layer) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (layer == 0) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
        } else {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179132_a((boolean)false);
        }
    }
}

