/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.integration.gtce.GTCERecipeHelper;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.ProcessorRecipe;
import nc.recipe.RecipeHelper;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.util.NCUtil;
import net.minecraft.item.ItemStack;

public abstract class ProcessorRecipeHandler
extends AbstractRecipeHandler<ProcessorRecipe> {
    public final int itemInputSize;
    public final int fluidInputSize;
    public final int itemOutputSize;
    public final int fluidOutputSize;
    public final boolean isShapeless;
    private final String recipeName;
    private static final Object2BooleanMap<String> GTCE_INTEGRATION = new Object2BooleanOpenHashMap();

    public ProcessorRecipeHandler(@Nonnull String recipeName, int itemInputSize, int fluidInputSize, int itemOutputSize, int fluidOutputSize) {
        this(recipeName, itemInputSize, fluidInputSize, itemOutputSize, fluidOutputSize, true);
    }

    public ProcessorRecipeHandler(@Nonnull String recipeName, int itemInputSize, int fluidInputSize, int itemOutputSize, int fluidOutputSize, boolean isShapeless) {
        this.itemInputSize = itemInputSize;
        this.fluidInputSize = fluidInputSize;
        this.itemOutputSize = itemOutputSize;
        this.fluidOutputSize = fluidOutputSize;
        this.isShapeless = isShapeless;
        this.recipeName = recipeName;
        this.addRecipes();
    }

    @Override
    public void addRecipe(Object ... objects) {
        ArrayList<Object> itemInputs = new ArrayList<Object>();
        ArrayList<Object> fluidInputs = new ArrayList<Object>();
        ArrayList<Object> itemOutputs = new ArrayList<Object>();
        ArrayList<Object> fluidOutputs = new ArrayList<Object>();
        ArrayList<Object> extras = new ArrayList<Object>();
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (i < this.itemInputSize) {
                itemInputs.add(object);
                continue;
            }
            if (i < this.itemInputSize + this.fluidInputSize) {
                fluidInputs.add(object);
                continue;
            }
            if (i < this.itemInputSize + this.fluidInputSize + this.itemOutputSize) {
                itemOutputs.add(object);
                continue;
            }
            if (i < this.itemInputSize + this.fluidInputSize + this.itemOutputSize + this.fluidOutputSize) {
                fluidOutputs.add(object);
                continue;
            }
            extras.add(object);
        }
        ProcessorRecipe recipe = this.buildRecipe(itemInputs, fluidInputs, itemOutputs, fluidOutputs, extras, this.isShapeless);
        this.addRecipe(recipe);
        if (ModCheck.gregtechLoaded() && GTCE_INTEGRATION.getBoolean((Object)this.recipeName) && recipe != null) {
            GTCERecipeHelper.addGTCERecipe(this.recipeName, recipe);
        }
    }

    public static void initGTCEIntegration() {
        boolean[] arr = NCConfig.gtce_recipe_integration;
        GTCE_INTEGRATION.put((Object)"manufactory", arr[0]);
        GTCE_INTEGRATION.put((Object)"isotope_separator", arr[1]);
        GTCE_INTEGRATION.put((Object)"decay_hastener", arr[2]);
        GTCE_INTEGRATION.put((Object)"fuel_reprocessor", arr[3]);
        GTCE_INTEGRATION.put((Object)"alloy_furnace", arr[4]);
        GTCE_INTEGRATION.put((Object)"infuser", arr[5]);
        GTCE_INTEGRATION.put((Object)"melter", arr[6]);
        GTCE_INTEGRATION.put((Object)"supercooler", arr[7]);
        GTCE_INTEGRATION.put((Object)"electrolyser", arr[8]);
        GTCE_INTEGRATION.put((Object)"irradiator", arr[9]);
        GTCE_INTEGRATION.put((Object)"ingot_former", arr[10]);
        GTCE_INTEGRATION.put((Object)"pressurizer", arr[11]);
        GTCE_INTEGRATION.put((Object)"chemical_reactor", arr[12]);
        GTCE_INTEGRATION.put((Object)"salt_mixer", arr[13]);
        GTCE_INTEGRATION.put((Object)"crystallizer", arr[14]);
        GTCE_INTEGRATION.put((Object)"dissolver", arr[15]);
        GTCE_INTEGRATION.put((Object)"extractor", arr[16]);
        GTCE_INTEGRATION.put((Object)"centrifuge", arr[17]);
        GTCE_INTEGRATION.put((Object)"rock_crusher", arr[18]);
    }

    @Nullable
    public ProcessorRecipe buildRecipe(List itemInputs, List fluidInputs, List itemOutputs, List fluidOutputs, List extras, boolean shapeless) {
        IIngredient<ItemStack> output;
        IIngredient<ItemStack> input;
        ArrayList<IItemIngredient> itemIngredients = new ArrayList<IItemIngredient>();
        ArrayList<IItemIngredient> itemProducts = new ArrayList<IItemIngredient>();
        ArrayList<IFluidIngredient> fluidIngredients = new ArrayList<IFluidIngredient>();
        ArrayList<IFluidIngredient> fluidProducts = new ArrayList<IFluidIngredient>();
        for (Object obj : itemInputs) {
            if (obj != null && ProcessorRecipeHandler.isValidItemInputType(obj)) {
                input = RecipeHelper.buildItemIngredient(obj);
                if (input == null) {
                    return null;
                }
                itemIngredients.add((IItemIngredient)input);
                continue;
            }
            return null;
        }
        for (Object obj : fluidInputs) {
            if (obj != null && ProcessorRecipeHandler.isValidFluidInputType(obj)) {
                input = RecipeHelper.buildFluidIngredient(obj);
                if (input == null) {
                    return null;
                }
                fluidIngredients.add((IFluidIngredient)input);
                continue;
            }
            return null;
        }
        for (Object obj : itemOutputs) {
            if (obj != null && ProcessorRecipeHandler.isValidItemOutputType(obj)) {
                output = RecipeHelper.buildItemIngredient(obj);
                if (output == null) {
                    return null;
                }
                itemProducts.add((IItemIngredient)output);
                continue;
            }
            return null;
        }
        for (Object obj : fluidOutputs) {
            if (obj != null && ProcessorRecipeHandler.isValidFluidOutputType(obj)) {
                output = RecipeHelper.buildFluidIngredient(obj);
                if (output == null) {
                    return null;
                }
                fluidProducts.add((IFluidIngredient)output);
                continue;
            }
            return null;
        }
        if (!this.isValidRecipe(itemIngredients, fluidIngredients, itemProducts, fluidProducts)) {
            NCUtil.getLogger().info(this.getRecipeName() + " - a recipe was removed: " + RecipeHelper.getRecipeString(itemIngredients, fluidIngredients, itemProducts, fluidProducts));
        }
        return new ProcessorRecipe(itemIngredients, fluidIngredients, itemProducts, fluidProducts, extras, shapeless);
    }

    public boolean isValidRecipe(List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients, List<IItemIngredient> itemProducts, List<IFluidIngredient> fluidProducts) {
        return itemIngredients.size() == this.itemInputSize && fluidIngredients.size() == this.fluidInputSize && itemProducts.size() == this.itemOutputSize && fluidProducts.size() == this.fluidOutputSize;
    }

    @Override
    public String getRecipeName() {
        return "nuclearcraft_" + this.recipeName;
    }
}

