/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.shape.drag;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.shape.drag.DragShape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DragShapeBox
extends DragShape {
    public DragShapeBox() {
        super("box");
    }

    @Override
    public LittleBoxes getBoxes(LittleBoxes boxes, LittleVec min, LittleVec max, EntityPlayer player, NBTTagCompound nbt, boolean preview, PlacementPosition originalMin, PlacementPosition originalMax) {
        LittleBox box = new LittleBox(min, max);
        if (nbt.func_74767_n("hollow")) {
            int thickness = nbt.func_74762_e("thickness");
            LittleVec size = box.getSize();
            if (thickness * 2 >= size.x || thickness * 2 >= size.y || thickness * 2 >= size.z) {
                boxes.add(box);
            } else {
                boxes.add(new LittleBox(min.x, min.y, min.z, max.x, max.y, min.z + thickness));
                boxes.add(new LittleBox(min.x, min.y + thickness, min.z + thickness, min.x + thickness, max.y - thickness, max.z - thickness));
                boxes.add(new LittleBox(max.x - thickness, min.y + thickness, min.z + thickness, max.x, max.y - thickness, max.z - thickness));
                boxes.add(new LittleBox(min.x, min.y, min.z + thickness, max.x, min.y + thickness, max.z - thickness));
                boxes.add(new LittleBox(min.x, max.y - thickness, min.z + thickness, max.x, max.y, max.z - thickness));
                boxes.add(new LittleBox(min.x, min.y, max.z - thickness, max.x, max.y, max.z));
            }
        } else {
            boxes.add(box);
        }
        return boxes;
    }

    @Override
    public void addExtraInformation(NBTTagCompound nbt, List<String> list) {
        if (nbt.func_74767_n("hollow")) {
            list.add("type: hollow");
            list.add("thickness: " + nbt.func_74762_e("thickness") + " tiles");
        } else {
            list.add("type: solid");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt, LittleGridContext context) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiCheckBox("hollow", 5, 0, nbt.func_74767_n("hollow")));
        controls.add((GuiControl)new GuiSteppedSlider("thickness", 5, 20, 100, 14, nbt.func_74762_e("thickness"), 1, context.size));
        return controls;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt, LittleGridContext context) {
        GuiCheckBox box = (GuiCheckBox)gui.get("hollow");
        nbt.func_74757_a("hollow", box.value);
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
        nbt.func_74768_a("thickness", (int)slider.value);
    }

    @Override
    public void rotate(NBTTagCompound nbt, Rotation rotation) {
    }

    @Override
    public void flip(NBTTagCompound nbt, EnumFacing.Axis axis) {
    }
}

