/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.component;

import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import net.minecraft.world.World;

public interface ISignalComponent {
    public int getBandwidth() throws CorruptedConnectionException, NotYetConnectedException;

    default public void updateState(boolean[] state) {
        try {
            if (!BooleanUtils.equals((boolean[])state, (boolean[])this.getState())) {
                BooleanUtils.set((boolean[])this.getState(), (boolean[])state);
                this.changed();
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    public void changed() throws CorruptedConnectionException, NotYetConnectedException;

    public boolean[] getState() throws CorruptedConnectionException, NotYetConnectedException;

    public SignalComponentType getType();

    public LittleStructure getStructure();

    public World getStructureWorld();
}

