/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.item;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.SubGuiRecipe;
import com.creativemd.littletiles.client.gui.SubGuiRecipeAdvancedSelection;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.client.gui.configure.SubGuiModeSelector;
import com.creativemd.littletiles.client.render.cache.ItemModelCache;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.container.SubContainerConfigure;
import com.creativemd.littletiles.common.container.SubContainerRecipeAdvanced;
import com.creativemd.littletiles.common.item.ItemMultiTiles;
import com.creativemd.littletiles.common.packet.LittleSelectionModePacket;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.selection.mode.SelectionMode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRecipeAdvanced
extends Item
implements ILittleTile,
ICreativeRendered {
    @SideOnly(value=Side.CLIENT)
    public static IBakedModel model;

    public ItemRecipeAdvanced() {
        this.func_77637_a(LittleTiles.littleTab);
        this.field_77787_bX = true;
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("structure") && stack.func_77978_p().func_74775_l("structure").func_74764_b("name")) {
            return stack.func_77978_p().func_74775_l("structure").func_74779_i("name");
        }
        return super.func_77653_i(stack);
    }

    @Override
    public boolean hasLittlePreview(ItemStack stack) {
        return stack.func_77942_o() && (stack.func_77978_p().func_74762_e("count") > 0 || stack.func_77978_p().func_74764_b("children"));
    }

    @Override
    public void saveLittlePreview(ItemStack stack, LittlePreviews previews) {
        LittlePreview.savePreview(previews, stack);
    }

    @Override
    public LittlePreviews getLittlePreview(ItemStack stack) {
        return LittlePreview.getPreview(stack);
    }

    @Override
    public LittlePreviews getLittlePreview(ItemStack stack, boolean allowLowResolution, boolean marked) {
        return LittlePreview.getPreview(stack, allowLowResolution);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUI(EntityPlayer player, ItemStack stack) {
        if (!((ItemRecipeAdvanced)stack.func_77973_b()).hasLittlePreview(stack)) {
            return new SubGuiRecipeAdvancedSelection(stack);
        }
        return new SubGuiRecipe(stack);
    }

    @Override
    public SubContainerConfigure getConfigureContainer(EntityPlayer player, ItemStack stack) {
        return new SubContainerRecipeAdvanced(player, stack);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ArrayList<RenderBox> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74762_e("count") > 0) {
            return LittlePreview.getCubes((ItemStack)stack);
        }
        return new ArrayList<RenderBox>();
    }

    @SideOnly(value=Side.CLIENT)
    public void applyCustomOpenGLHackery(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        if (cameraTransformType == ItemCameraTransforms.TransformType.GUI || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tiles")) {
            if (cameraTransformType == ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179097_i();
            }
            if (model == null) {
                model = mc.func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("littletiles:recipeadvanced_background", "inventory"));
            }
            ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)cameraTransformType, (boolean)false);
            mc.func_175599_af().func_180454_a(new ItemStack(Items.field_151121_aF), model);
            if (cameraTransformType == ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179126_j();
            }
        }
        GlStateManager.func_179121_F();
        if (stack.func_77942_o() && stack.func_77978_p().func_74762_e("count") > 0) {
            LittleVec size = LittlePreview.getSize(stack);
            LittleGridContext context = LittleGridContext.get(stack.func_77978_p());
            double scaler = 1.0 / Math.max(1.0, Math.max(1.0, Math.max(size.getPosX(context), Math.max(size.getPosY(context), size.getPosZ(context)))));
            GlStateManager.func_179139_a((double)scaler, (double)scaler, (double)scaler);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void saveCachedModel(EnumFacing facing, BlockRenderLayer layer, List<BakedQuad> cachedQuads, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        ItemModelCache.cacheModel(stack, facing, cachedQuads);
    }

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getCachedModel(EnumFacing facing, BlockRenderLayer layer, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        return ItemModelCache.requestCache(stack, facing);
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRightClick(World world, EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result) {
        if (this.hasLittlePreview(stack)) {
            return true;
        }
        ItemRecipeAdvanced.getSelectionMode(stack).onRightClick(player, stack, result.func_178782_a());
        PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleSelectionModePacket(result.func_178782_a(), true));
        return true;
    }

    @Override
    public boolean onClickBlock(World world, EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result) {
        if (this.hasLittlePreview(stack)) {
            return true;
        }
        ItemRecipeAdvanced.getSelectionMode(stack).onLeftClick(player, stack, result.func_178782_a());
        PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleSelectionModePacket(result.func_178782_a(), false));
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUIAdvanced(EntityPlayer player, ItemStack stack) {
        return new SubGuiModeSelector(stack, ItemMultiTiles.currentContext, ItemMultiTiles.currentMode){

            @Override
            public void saveConfiguration(LittleGridContext context, PlacementMode mode) {
                ItemMultiTiles.currentContext = context;
                ItemMultiTiles.currentMode = mode;
            }
        };
    }

    @Override
    public PlacementMode getPlacementMode(ItemStack stack) {
        if (!ItemMultiTiles.currentMode.canPlaceStructures() && stack.func_77978_p().func_74764_b("structure")) {
            return PlacementMode.getStructureDefault();
        }
        return ItemMultiTiles.currentMode;
    }

    @Override
    public LittleGridContext getPositionContext(ItemStack stack) {
        return ItemMultiTiles.currentContext;
    }

    @Override
    public LittleVec getCachedSize(ItemStack stack) {
        if (stack.func_77978_p().func_74764_b("size")) {
            return LittlePreview.getSize(stack);
        }
        return null;
    }

    @Override
    public LittleVec getCachedOffset(ItemStack stack) {
        return LittlePreview.getOffset(stack);
    }

    public static SelectionMode getSelectionMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return SelectionMode.getOrDefault(stack.func_77978_p().func_74779_i("selmode"));
    }

    public static void setSelectionMode(ItemStack stack, SelectionMode mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("selmode", mode.name);
    }
}

