/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import java.lang.reflect.Field;
import java.util.Set;
import jeresources.util.ClassScraper;
import jeresources.util.LogHelper;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class ReflectionHelper
extends ObfuscationReflectionHelper {
    public static Class findClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean isInstanceOf(Class clazz, Class checkClass) {
        for (Class instanceOf : ClassScraper.getGeneralizations(clazz)) {
            if (instanceOf != checkClass) continue;
            return true;
        }
        return false;
    }

    public static <T> void injectIntoFields(ASMDataTable asmDataTable, Class annotation, Class<T> type, T instance) {
        String annotationClassName = annotation.getCanonicalName();
        Set asmDataSet = asmDataTable.getAll(annotationClassName);
        for (ASMDataTable.ASMData asmData : asmDataSet) {
            try {
                Class<?> clazz = Class.forName(asmData.getClassName());
                Field field = clazz.getField(asmData.getObjectName());
                if (field.getType() != type) continue;
                field.set(null, instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                LogHelper.warn("Failed to set: {}" + asmData.getClassName() + "." + asmData.getObjectName(), new Object[0]);
            }
        }
    }
}

