/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.Focus;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.ingredients.GuiFluidStackGroup;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.ingredients.GuiIngredientGroup;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.gui.recipes.RecipeTransferButton;
import mezz.jei.gui.recipes.ShapelessIcon;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.ingredients.Ingredients;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.LegacyUtil;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeLayout
implements IRecipeLayoutDrawable {
    private static final int RECIPE_BUTTON_SIZE = 13;
    private static final int RECIPE_BORDER_PADDING = 4;
    public static final int recipeTransferButtonIndex = 100;
    private final int ingredientCycleOffset = (int)(Math.random() * 10000.0 % 2.147483647E9);
    private final IRecipeCategory recipeCategory;
    private final GuiItemStackGroup guiItemStackGroup;
    private final GuiFluidStackGroup guiFluidStackGroup;
    private final Map<IIngredientType, GuiIngredientGroup> guiIngredientGroups;
    @Nullable
    private final RecipeTransferButton recipeTransferButton;
    private final IRecipeWrapper recipeWrapper;
    @Nullable
    private final IFocus<?> focus;
    private final Color highlightColor = new Color(Integer.MAX_VALUE, true);
    @Nullable
    private ShapelessIcon shapelessIcon;
    private final DrawableNineSliceTexture recipeBorder;
    private int posX;
    private int posY;

    @Nullable
    public static <T extends IRecipeWrapper> RecipeLayout create(int index, IRecipeCategory<T> recipeCategory, T recipeWrapper, @Nullable IFocus focus, int posX, int posY) {
        RecipeLayout recipeLayout = new RecipeLayout(index, recipeCategory, recipeWrapper, focus, posX, posY);
        try {
            Ingredients ingredients = new Ingredients();
            recipeWrapper.getIngredients(ingredients);
            recipeCategory.setRecipe(recipeLayout, recipeWrapper, ingredients);
            return recipeLayout;
        }
        catch (LinkageError | RuntimeException e) {
            Log.get().error("Error caught from Recipe Category: {}", (Object)recipeCategory.getClass().getCanonicalName(), (Object)e);
            return null;
        }
    }

    private <T extends IRecipeWrapper> RecipeLayout(int index, IRecipeCategory<T> recipeCategory, T recipeWrapper, @Nullable IFocus<?> focus, int posX, int posY) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        ErrorUtil.checkNotNull(recipeWrapper, "recipeWrapper");
        if (focus != null) {
            focus = Focus.check(focus);
        }
        this.recipeCategory = recipeCategory;
        this.focus = focus;
        IFocus<FluidStack> itemStackFocus = null;
        IFocus<FluidStack> fluidStackFocus = null;
        if (focus != null) {
            Object focusValue = focus.getValue();
            if (focusValue instanceof ItemStack) {
                itemStackFocus = focus;
            } else if (focusValue instanceof FluidStack) {
                fluidStackFocus = focus;
            }
        }
        this.guiItemStackGroup = new GuiItemStackGroup(itemStackFocus, this.ingredientCycleOffset);
        this.guiFluidStackGroup = new GuiFluidStackGroup(fluidStackFocus, this.ingredientCycleOffset);
        this.guiIngredientGroups = new Reference2ObjectArrayMap();
        this.guiIngredientGroups.put(VanillaTypes.ITEM, this.guiItemStackGroup);
        this.guiIngredientGroups.put(VanillaTypes.FLUID, this.guiFluidStackGroup);
        if (index >= 0) {
            IDrawableStatic icon = Internal.getHelpers().getGuiHelper().getRecipeTransfer();
            this.recipeTransferButton = new RecipeTransferButton(100 + index, 0, 0, 13, 13, icon, this);
        } else {
            this.recipeTransferButton = null;
        }
        this.setPosition(posX, posY);
        this.recipeWrapper = recipeWrapper;
        this.recipeBorder = Internal.getHelpers().getGuiHelper().getRecipeBackground();
    }

    @Override
    public void setPosition(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
        if (this.recipeTransferButton != null) {
            int width = this.recipeCategory.getBackground().getWidth();
            int height = this.recipeCategory.getBackground().getHeight();
            this.recipeTransferButton.field_146128_h = posX + width + 4 + 2;
            this.recipeTransferButton.field_146129_i = posY + height - 13;
        }
    }

    @Override
    @Deprecated
    public void draw(Minecraft minecraft, int mouseX, int mouseY) {
        this.drawRecipe(minecraft, mouseX, mouseY);
        this.drawOverlays(minecraft, mouseX, mouseY);
    }

    @Override
    public void drawRecipe(Minecraft minecraft, int mouseX, int mouseY) {
        IDrawable background = this.recipeCategory.getBackground();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        int recipeMouseX = mouseX - this.posX;
        int recipeMouseY = mouseY - this.posY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
        IDrawable categoryBackground = this.recipeCategory.getBackground();
        int width = categoryBackground.getWidth() + 8;
        int height = categoryBackground.getHeight() + 8;
        this.recipeBorder.draw(minecraft, -4, -4, width, height);
        background.draw(minecraft);
        this.recipeCategory.drawExtras(minecraft);
        this.recipeWrapper.drawInfo(minecraft, background.getWidth(), background.getHeight(), recipeMouseX, recipeMouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.shapelessIcon != null) {
            this.shapelessIcon.draw(minecraft, background.getWidth());
        }
        GlStateManager.func_179121_F();
        for (GuiIngredientGroup guiIngredientGroup : this.guiIngredientGroups.values()) {
            guiIngredientGroup.draw(minecraft, this.posX, this.posY, this.highlightColor, mouseX, mouseY);
        }
        if (this.recipeTransferButton != null) {
            float partialTicks = minecraft.func_184121_ak();
            this.recipeTransferButton.func_191745_a(minecraft, mouseX, mouseY, partialTicks);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        GlStateManager.func_179118_c();
    }

    @Override
    public void drawOverlays(Minecraft minecraft, int mouseX, int mouseY) {
        GuiIngredientGroup guiIngredientGroup;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        int recipeMouseX = mouseX - this.posX;
        int recipeMouseY = mouseY - this.posY;
        GuiIngredient hoveredIngredient = null;
        Iterator<GuiIngredientGroup> iterator = this.guiIngredientGroups.values().iterator();
        while (iterator.hasNext() && (hoveredIngredient = (guiIngredientGroup = iterator.next()).getHoveredIngredient(this.posX, this.posY, mouseX, mouseY)) == null) {
        }
        if (this.recipeTransferButton != null) {
            this.recipeTransferButton.drawToolTip(minecraft, mouseX, mouseY);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        if (hoveredIngredient != null) {
            hoveredIngredient.drawOverlays(minecraft, this.posX, this.posY, recipeMouseX, recipeMouseY);
        } else if (this.isMouseOver(mouseX, mouseY)) {
            List<String> categoryTooltipStrings = LegacyUtil.getTooltipStrings(this.recipeCategory, recipeMouseX, recipeMouseY);
            List<String> tooltipStrings = new ArrayList<String>(categoryTooltipStrings);
            List<String> wrapperTooltips = this.recipeWrapper.getTooltipStrings(recipeMouseX, recipeMouseY);
            if (wrapperTooltips != null) {
                tooltipStrings.addAll(wrapperTooltips);
            }
            if (tooltipStrings.isEmpty() && this.shapelessIcon != null) {
                tooltipStrings = this.shapelessIcon.getTooltipStrings(recipeMouseX, recipeMouseY);
            }
            if (tooltipStrings != null && !tooltipStrings.isEmpty()) {
                TooltipRenderer.drawHoveringText(minecraft, tooltipStrings, mouseX, mouseY);
            }
        }
        GlStateManager.func_179118_c();
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        IDrawable background = this.recipeCategory.getBackground();
        Rectangle backgroundRect = new Rectangle(this.posX, this.posY, background.getWidth(), background.getHeight());
        return backgroundRect.contains(mouseX, mouseY) || this.recipeTransferButton != null && this.recipeTransferButton.func_146115_a();
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        GuiIngredient<?> guiIngredient = this.getGuiIngredientUnderMouse(mouseX, mouseY);
        if (guiIngredient != null) {
            return guiIngredient.getDisplayedIngredient();
        }
        return null;
    }

    @Nullable
    public GuiIngredient<?> getGuiIngredientUnderMouse(int mouseX, int mouseY) {
        for (GuiIngredientGroup guiIngredientGroup : this.guiIngredientGroups.values()) {
            GuiIngredient clicked = guiIngredientGroup.getHoveredIngredient(this.posX, this.posY, mouseX, mouseY);
            if (clicked == null) continue;
            return clicked;
        }
        return null;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return this.recipeWrapper.handleClick(minecraft, mouseX - this.posX, mouseY - this.posY, mouseButton);
    }

    @Override
    public GuiItemStackGroup getItemStacks() {
        return this.guiItemStackGroup;
    }

    @Override
    public IGuiFluidStackGroup getFluidStacks() {
        return this.guiFluidStackGroup;
    }

    @Override
    public <T> IGuiIngredientGroup<T> getIngredientsGroup(IIngredientType<T> ingredientType) {
        GuiIngredientGroup<T> guiIngredientGroup = this.guiIngredientGroups.get(ingredientType);
        if (guiIngredientGroup == null) {
            IFocus<?> focus = null;
            if (this.focus != null) {
                Object focusValue = this.focus.getValue();
                if (ingredientType.getIngredientClass().isInstance(focusValue)) {
                    focus = this.focus;
                }
            }
            guiIngredientGroup = new GuiIngredientGroup<T>(ingredientType, focus, this.ingredientCycleOffset);
            this.guiIngredientGroups.put(ingredientType, guiIngredientGroup);
        }
        return guiIngredientGroup;
    }

    @Override
    @Deprecated
    public <T> IGuiIngredientGroup<T> getIngredientsGroup(Class<T> ingredientClass) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IIngredientType<T> ingredientType = ingredientRegistry.getIngredientType(ingredientClass);
        return this.getIngredientsGroup(ingredientType);
    }

    @Override
    public void setRecipeTransferButton(int posX, int posY) {
        if (this.recipeTransferButton != null) {
            this.recipeTransferButton.field_146128_h = posX + this.posX;
            this.recipeTransferButton.field_146129_i = posY + this.posY;
        }
    }

    @Override
    public void setShapeless() {
        this.shapelessIcon = new ShapelessIcon();
    }

    @Override
    @Nullable
    public IFocus<?> getFocus() {
        return this.focus;
    }

    @Nullable
    public RecipeTransferButton getRecipeTransferButton() {
        return this.recipeTransferButton;
    }

    public IRecipeCategory getRecipeCategory() {
        return this.recipeCategory;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }
}

