/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.item;

import com.blakebr0.cucumber.helper.ResourceHelper;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.iface.IModelHelper;
import com.blakebr0.cucumber.item.ItemMeta;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.CompressorRecipeManager;
import com.blakebr0.extendedcrafting.item.ItemSingularity;
import com.blakebr0.extendedcrafting.item.ItemSingularityUltimate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;

public class ItemSingularityCustom
extends ItemMeta
implements IModelHelper,
IEnableable {
    public static final ArrayList<CustomSingularity> singularities = new ArrayList();
    public static final Map<Integer, Integer> singularityColors = new HashMap<Integer, Integer>();
    public static final Map<Integer, Object> singularityMaterials = new HashMap<Integer, Object>();

    public ItemSingularityCustom() {
        super("ec.singularity_custom", ExtendedCrafting.REGISTRY);
        this.func_77637_a(ExtendedCrafting.CREATIVE_TAB);
    }

    public String func_77653_i(ItemStack stack) {
        String localizedMaterialName = "Invalid";
        int meta = stack.func_77960_j();
        if (this.items.containsKey(meta)) {
            String materialName = ((ItemMeta.MetaItem)this.items.get(meta)).getName();
            String assumedTranslationKey = "item.ec.singularity." + materialName;
            localizedMaterialName = I18n.func_94522_b((String)assumedTranslationKey) ? I18n.func_74838_a((String)assumedTranslationKey) : WordUtils.capitalize((String)materialName.replaceAll("_", " "));
        }
        return I18n.func_74837_a((String)"item.ec.singularity.name", (Object[])new Object[]{localizedMaterialName});
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public void configure(Configuration config) {
        ConfigCategory category = config.getCategory("singularity");
        String[] values = config.get(category.getName(), "custom_singularities", new String[0]).getStringList();
        category.get("custom_singularities").setComment("Here you can add your own custom Singularities.\n- Syntax: meta;name;material;color\n- Example: 12;super_potato;minecraft:carrot;123456\n- 'meta' must be different for each, and should not be changed.\n- 'name' should be lower case with underscores for spaces. Singularity is added automatically.\n- Example: 'lots_of_spaghetti' would show 'Lots Of Spaghetti Singularity'.\n- 'material' is an item id or ore dictionary entry. This is for the generic crafting recipe.\n- Note: if you plan on adding your own recipe with the CraftTweaker integration, put 'none'.\n- Examples: 'minecraft:stone' for stone, 'ore:ingotIron' for the ore dictionary entry 'ingotIron'.\n- Note: you can also specify meta for item ids, by adding them to the end of the item id.\n- Example: minecraft:stone:3 for a meta of 3. Make the meta 32767 for wildcard value.\n- 'color' the color of the singularity as a hex value. http://htmlcolorcodes.com/\n- Example: 123456 would color it as whatever that color is.\n - Use the localization key \"item.ec.singularity.<name>\" to set the name of your custom Singularity.\n - Example: item.ec.singularity.carrot=Carrot in your resources/extendedcrafting/lang/en_us.lang\n - and item.ec.singularity.carrot=\u043c\u043e\u0440\u043a\u043e\u0432\u044c in your resources/extendedcrafting/lang/ru_ru.lang\n - Note however that you will need a way to load these resources, such as the mod ResourceLoader.");
        for (String value : values) {
            int color;
            int meta;
            String[] parts = value.split(";");
            if (parts.length != 4) {
                ExtendedCrafting.LOGGER.error("Invalid custom singularity syntax length: " + value);
                continue;
            }
            String name = parts[1];
            String material = parts[2];
            try {
                meta = Integer.parseInt(parts[0]);
                color = Integer.parseInt(parts[3], 16);
            }
            catch (NumberFormatException e) {
                ExtendedCrafting.LOGGER.error("Invalid custom singularity syntax ints: " + value);
                continue;
            }
            singularities.add(new CustomSingularity(meta, name, material, color));
        }
    }

    public void init() {
        for (CustomSingularity sing : singularities) {
            this.addSingularity(sing.meta, sing.name, sing.material, sing.color);
        }
    }

    public void initModels() {
        for (Map.Entry item : this.items.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)((Integer)item.getKey()), (ModelResourceLocation)ResourceHelper.getModelResource((String)"extendedcrafting", (String)"singularity", (String)"inventory"));
        }
    }

    public boolean isEnabled() {
        return ModConfig.confSingularityEnabled;
    }

    public void addSingularity(int meta, String name, String material, int color) {
        singularityColors.put(meta, color);
        singularityMaterials.put(meta, material);
        ItemSingularityUltimate.addSingularityToRecipe(new ItemStack((Item)this, 1, meta));
        this.addItem(meta, name, true);
    }

    public void initRecipes() {
        if (!this.isEnabled()) {
            return;
        }
        for (Map.Entry<Integer, Object> obj : singularityMaterials.entrySet()) {
            Object value = obj.getValue();
            int meta = obj.getKey();
            if (value instanceof String) {
                ItemStack stack;
                Item item;
                if ("none".equalsIgnoreCase((String)value)) continue;
                String[] parts = ((String)value).split(":");
                if (parts.length == 3) {
                    int matMeta;
                    try {
                        matMeta = Integer.parseInt(parts[2]);
                    }
                    catch (NumberFormatException e) {
                        ExtendedCrafting.LOGGER.error("Invalid meta for singularity: " + value.toString());
                        continue;
                    }
                    item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0], parts[1]));
                    if (item == null) continue;
                    stack = new ItemStack(item, 1, matMeta);
                    CompressorRecipeManager.getInstance().addRecipe(new ItemStack((Item)this, 1, meta), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack.func_77946_l()}), ModConfig.confSingularityAmount, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemSingularity.getCatalystStack()}), false, ModConfig.confSingularityRF);
                    continue;
                }
                if (parts.length == 2) {
                    if (((String)value).startsWith("ore:")) {
                        String ore = ((String)value).substring(4);
                        if (!OreDictionary.doesOreNameExist((String)ore) || OreDictionary.getOres((String)ore).isEmpty()) continue;
                        CompressorRecipeManager.getInstance().addRecipe(new ItemStack((Item)this, 1, meta), CraftingHelper.getIngredient((Object)ore), ModConfig.confSingularityAmount, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemSingularity.getCatalystStack()}), false, ModConfig.confSingularityRF);
                        continue;
                    }
                    item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0], parts[1]));
                    if (item == null) continue;
                    stack = new ItemStack(item);
                    CompressorRecipeManager.getInstance().addRecipe(new ItemStack((Item)this, 1, meta), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack.func_77946_l()}), ModConfig.confSingularityAmount, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemSingularity.getCatalystStack()}), false, ModConfig.confSingularityRF);
                    continue;
                }
                ExtendedCrafting.LOGGER.error("Invalid material for singularity: " + value.toString());
                continue;
            }
            ExtendedCrafting.LOGGER.error("Invalid material for singularity: " + value.toString());
        }
    }

    public static class ColorHandler
    implements IItemColor {
        public int func_186726_a(ItemStack stack, int tintIndex) {
            return singularityColors.get(stack.func_77960_j());
        }
    }

    public static class CustomSingularity {
        public final int meta;
        public final String name;
        public final String material;
        public final int color;

        public CustomSingularity(int meta, String name, String material, int color) {
            this.meta = meta;
            this.name = name;
            this.material = material;
            this.color = color;
        }
    }
}

