/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.table;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.endercrafter.IEnderCraftingRecipe;
import com.blakebr0.extendedcrafting.crafting.table.ITieredRecipe;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public abstract class TableRecipeBase
implements ITieredRecipe,
IEnderCraftingRecipe {
    protected final ItemStack output;
    protected final NonNullList<Ingredient> input;
    protected boolean mirrored = true;
    protected final ResourceLocation group;
    protected final int tier;
    protected Map<Integer, Function<ItemStack, ItemStack>> transformers;
    public int enderCrafterRecipeTimeRequired = ModConfig.confEnderTimeRequired;
    private ResourceLocation registryName;

    public TableRecipeBase(int tier, ItemStack result, NonNullList<Ingredient> ingredients) {
        this.group = RecipeHelper.EMPTY_GROUP;
        this.output = result.func_77946_l();
        this.input = ingredients;
        this.tier = tier;
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.input;
    }

    public String func_193358_e() {
        return this.group == null ? "" : this.group.toString();
    }

    protected int getTierFromSize(int size) {
        return size < 10 ? 1 : (size < 26 ? 2 : (size < 50 ? 3 : 4));
    }

    protected int getTierFromGridSize(InventoryCrafting inv) {
        int size = inv.func_70302_i_();
        return size < 10 ? 1 : (size < 26 ? 2 : (size < 50 ? 3 : 4));
    }

    public boolean requiresTier() {
        return this.tier > 0;
    }

    @Override
    public int getEnderCrafterTimeSeconds() {
        return this.enderCrafterRecipeTimeRequired;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList remaining = ITieredRecipe.super.func_179532_b(inv);
        if (this.transformers != null && !this.transformers.isEmpty()) {
            this.transformers.forEach((i, transformer) -> remaining.set(i.intValue(), (Object)((ItemStack)transformer.apply(inv.func_70301_a(i.intValue())))));
        }
        return remaining;
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        this.registryName = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }
}

