/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit;

import com.enderio.core.common.util.DyeColor;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;

public interface IEnderConduit {
    default public int getOutputPriority(@Nonnull EnumFacing dir) {
        Integer res = this.getOutputPriorities().get(dir);
        if (res == null) {
            return 0;
        }
        return res;
    }

    default public void setOutputPriority(@Nonnull EnumFacing dir, int priority) {
        if (priority == 0) {
            this.getOutputPriorities().remove(dir);
        } else {
            this.getOutputPriorities().put(dir, priority);
        }
        this.refreshConnection(dir);
    }

    default public boolean isSelfFeedEnabled(@Nonnull EnumFacing dir) {
        Boolean val = this.getSelfFeed().get(dir);
        if (val == null) {
            return false;
        }
        return val;
    }

    default public void setSelfFeedEnabled(@Nonnull EnumFacing dir, boolean enabled) {
        if (!enabled) {
            this.getSelfFeed().remove(dir);
        } else {
            this.getSelfFeed().put(dir, enabled);
        }
        this.refreshConnection(dir);
    }

    default public boolean isRoundRobinEnabled(@Nonnull EnumFacing dir) {
        Boolean val = this.getRoundRobin().get(dir);
        if (val == null) {
            return false;
        }
        return val;
    }

    default public void setRoundRobinEnabled(@Nonnull EnumFacing dir, boolean enabled) {
        if (!enabled) {
            this.getRoundRobin().remove(dir);
        } else {
            this.getRoundRobin().put(dir, enabled);
        }
        this.refreshConnection(dir);
    }

    @Nonnull
    default public DyeColor getInputColor(@Nonnull EnumFacing dir) {
        DyeColor result = this.getInputColors().get(dir);
        if (result == null) {
            return DyeColor.GREEN;
        }
        return result;
    }

    @Nonnull
    default public DyeColor getOutputColor(@Nonnull EnumFacing dir) {
        DyeColor result = this.getOutputColors().get(dir);
        if (result == null) {
            return DyeColor.GREEN;
        }
        return result;
    }

    default public void setInputColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.getInputColors().put(dir, col);
        this.refreshConnection(dir);
        this.setClientDirty();
    }

    default public void setOutputColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.getOutputColors().put(dir, col);
        this.refreshConnection(dir);
        this.setClientDirty();
    }

    @Nonnull
    public Map<EnumFacing, DyeColor> getInputColors();

    @Nonnull
    public Map<EnumFacing, DyeColor> getOutputColors();

    @Nonnull
    public Map<EnumFacing, Boolean> getSelfFeed();

    @Nonnull
    public Map<EnumFacing, Boolean> getRoundRobin();

    @Nonnull
    public Map<EnumFacing, Integer> getOutputPriorities();

    public void refreshConnection(@Nonnull EnumFacing var1);

    public void setClientDirty();
}

