/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.farmers;

import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IFarmerJoe;
import crazypants.enderio.api.farm.IFarmingTool;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.farmers.CustomSeedFarmer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class MelonFarmer
extends CustomSeedFarmer {
    @Nonnull
    private final Block grownBlock;

    public MelonFarmer(@Nonnull Block plantedBlock, @Nonnull Block grownBlock, @Nonnull ItemStack seeds) {
        super(plantedBlock, seeds);
        this.grownBlock = grownBlock;
    }

    @Override
    public IFarmerJoe.Result tryPrepareBlock(@Nonnull IFarmer farm, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        int xVal = farm.getLocation().func_177958_n() & 1;
        int zVal = farm.getLocation().func_177952_p() & 1;
        if ((pos.func_177958_n() & 1) != xVal ^ (pos.func_177952_p() & 1) != zVal) {
            return this.canPlant(farm.getSeedTypeInSuppliesFor(pos)) ? IFarmerJoe.Result.CLAIM : IFarmerJoe.Result.NEXT;
        }
        return super.tryPrepareBlock(farm, pos, state);
    }

    @Override
    public boolean canHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull IBlockState state) {
        return state.func_177230_c() == this.grownBlock;
    }

    @Override
    @Nonnull
    protected IFarmingTool getHarvestTool() {
        return FarmingTool.AXE;
    }

    @Override
    @Nonnull
    protected FarmNotification getNoHarvestToolNotification() {
        return FarmNotification.NO_AXE;
    }
}

