/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util.blockiterators;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.blockiterators.AbstractBlockIterator;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;

public class CubicBlockIterator
extends AbstractBlockIterator {
    protected final int minX;
    protected final int minY;
    protected final int minZ;
    protected final int maxX;
    protected final int maxY;
    protected final int maxZ;
    protected int curX;
    protected int curY;
    protected int curZ;

    protected CubicBlockIterator(@Nonnull BlockPos base, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(base);
        this.minX = this.curX = minX;
        this.minY = this.curY = minY;
        this.minZ = this.curZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public CubicBlockIterator(@Nonnull BlockPos base, int radius) {
        this(base, base.func_177958_n() - radius, base.func_177956_o() - radius, base.func_177952_p() - radius, base.func_177958_n() + radius, base.func_177956_o() + radius, base.func_177952_p() + radius);
    }

    public CubicBlockIterator(@Nonnull BlockPos pos0, @Nonnull BlockPos pos1) {
        this(pos0, pos0.func_177958_n(), pos0.func_177956_o(), pos0.func_177952_p(), pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p());
    }

    public CubicBlockIterator(@Nonnull BoundingBox bb) {
        this(new BlockPos(bb.func_189972_c()), (int)bb.field_72340_a, (int)bb.field_72338_b, (int)bb.field_72339_c, (int)bb.field_72336_d, (int)bb.field_72337_e, (int)bb.field_72334_f);
    }

    @Override
    @Nonnull
    public BlockPos next() {
        BlockPos ret = new BlockPos(this.curX, this.curY, this.curZ);
        int n = this.curX = this.curX == this.maxX ? this.minX : this.curX + 1;
        this.curY = this.curX == this.minX ? (this.curY == this.maxY ? this.minY : this.curY + 1) : this.curY;
        this.curZ = this.curY == this.minY && this.curX == this.minX ? this.curZ + 1 : this.curZ;
        return ret;
    }

    @Override
    public boolean hasNext() {
        return this.curZ <= this.maxZ;
    }
}

