/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.common.util.NNList;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class EndlessNNIterator<T>
implements Iterable<T>,
NNList.NNIterator<T> {
    private int index = -1;
    @Nonnull
    private final NNList<T> itOver;

    public EndlessNNIterator(@Nonnull NNList<T> itOver) {
        this.itOver = itOver;
        if (itOver.isEmpty()) {
            throw new RuntimeException("Cannot iterate over empty list");
        }
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    @Nonnull
    public T next() {
        if (++this.index >= this.itOver.size()) {
            this.index = 0;
        }
        return this.itOver.get(this.index);
    }

    @Override
    public void remove() {
    }
}

