/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.defaultworldgenerator.lib;

import com.ezrol.terry.minecraft.defaultworldgenerator.lib.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.ProviderNotFoundException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Sha384 {
    private static MessageDigest digest;
    private MessageDigest local;

    public Sha384() {
        if (digest == null) {
            throw new ProviderNotFoundException("Your version of java is missing SHA-384 support (required)");
        }
        try {
            this.local = (MessageDigest)digest.clone();
            this.local.reset();
        }
        catch (CloneNotSupportedException e) {
            Log.fatal(e);
            throw new ProviderNotFoundException("could not clone instance of SHA-384, this is unexpected");
        }
    }

    public Sha384(byte[] initialData) {
        this();
        this.appendToMessage(initialData);
    }

    public Sha384(File file) {
        this();
        long size = file.length();
        long block_size = size == 0L ? 512L : (size > 10240L ? 4096L : size);
        byte[] block = new byte[(int)block_size];
        try {
            FileInputStream f = new FileInputStream(file);
            while (block_size > 0L) {
                block_size = ((InputStream)f).read(block);
                if ((long)block.length == block_size) {
                    this.appendToMessage(block);
                    continue;
                }
                if (block_size >= 0L) {
                    this.appendToMessage(block, (int)block_size);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void appendToMessage(byte[] b) {
        this.local.update(b);
    }

    public void appendToMessage(byte[] b, int size) {
        this.local.update(b, 0, size);
    }

    public String getHexDigest() {
        byte[] digest = this.local.digest();
        StringBuilder rval = new StringBuilder();
        for (byte b : digest) {
            char high = (char)((b & 0xF0) >> 4);
            char low = (char)(b & 0xF);
            high = (char)(high < '\n' ? 48 + high : high - 10 + 97);
            low = (char)(low < '\n' ? 48 + low : low - 10 + 97);
            rval.append(high);
            rval.append(low);
        }
        return rval.toString();
    }

    static {
        try {
            digest = MessageDigest.getInstance("SHA-384");
        }
        catch (NoSuchAlgorithmException e) {
            digest = null;
        }
    }
}

