/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.util;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.DMLRelearned;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class ItemStackDefinitionHelper {
    public static ItemStack itemStackFromString(String itemDefinitionString) {
        return ItemStackDefinitionHelper.itemDefinitionFromString(itemDefinitionString).flatMap(ItemStackDefinitionHelper::itemStackFromItemStackDefinition).orElse(ItemStack.field_190927_a);
    }

    private static Optional<ItemStack> itemStackFromItemStackDefinition(ItemStackDefinition itemStackDefinition) {
        ItemStack result;
        if (itemStackDefinition.isOre) {
            String oreName = itemStackDefinition.registryName.substring(4);
            if (!OreDictionary.doesOreNameExist((String)oreName)) {
                DMLRelearned.logger.warn("ItemStackBuilder: Ore with name \"{}\" does not exist", (Object)oreName);
                return Optional.empty();
            }
            result = ((ItemStack)OreDictionary.getOres((String)oreName).get(0)).func_77946_l();
            result.func_190920_e(itemStackDefinition.stackSize);
            result.func_77964_b(itemStackDefinition.metadata);
        } else {
            Item item = Item.func_111206_d((String)itemStackDefinition.registryName);
            Block block = Block.func_149684_b((String)itemStackDefinition.registryName);
            if (item == null && (block == null || block == Blocks.field_150350_a)) {
                return Optional.empty();
            }
            result = item != null ? new ItemStack(item, itemStackDefinition.stackSize, itemStackDefinition.metadata) : new ItemStack(block, itemStackDefinition.stackSize, itemStackDefinition.metadata);
        }
        result.func_77982_d(itemStackDefinition.nbt);
        return Optional.of(result);
    }

    public static ImmutableList<ItemStack> itemStackListFromStringList(List<String> inputList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String entry : inputList) {
            ItemStack entryStack = ItemStackDefinitionHelper.itemStackFromString(entry);
            if (entryStack.func_190926_b()) continue;
            builder.add((Object)entryStack);
        }
        return builder.build();
    }

    public static Ingredient ingredientFromString(String itemDefinitionString) {
        Optional<ItemStackDefinition> itemStackDefinitionOptional = ItemStackDefinitionHelper.itemDefinitionFromString(itemDefinitionString);
        if (!itemStackDefinitionOptional.isPresent()) {
            return Ingredient.field_193370_a;
        }
        ItemStackDefinition itemStackDefinition = itemStackDefinitionOptional.get();
        if (itemStackDefinition.isOre) {
            String oreName = itemStackDefinition.registryName.substring(4);
            if (!OreDictionary.doesOreNameExist((String)oreName)) {
                DMLRelearned.logger.warn("ItemStackBuilder: Ore with name \"{}\" does not exist", (Object)oreName);
                return Ingredient.field_193370_a;
            }
            return new OreIngredient(oreName);
        }
        ItemStack stack = ItemStackDefinitionHelper.itemStackFromString(itemDefinitionString);
        if (stack.func_190926_b()) {
            return Ingredient.field_193370_a;
        }
        return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
    }

    public static ImmutableList<Ingredient> ingredientListFromStringList(List<String> inputList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String entry : inputList) {
            Ingredient ingredient = ItemStackDefinitionHelper.ingredientFromString(entry);
            if (ingredient.equals(Ingredient.field_193370_a)) continue;
            builder.add((Object)ingredient);
        }
        return builder.build();
    }

    private static Optional<ItemStackDefinition> itemDefinitionFromString(String itemString) {
        if (itemString.isEmpty()) {
            DMLRelearned.logger.warn("ItemStackBuilder: Input string empty");
            return Optional.empty();
        }
        String separator = ",";
        String[] values = itemString.split(",");
        String registryName = values[0];
        if (!registryName.contains(":")) {
            DMLRelearned.logger.warn("ItemStackBuilder: Invalid item name: {}", (Object)registryName);
            return Optional.empty();
        }
        int stackSize = 1;
        if (values.length > 1) {
            try {
                stackSize = Integer.parseInt(values[1]);
            }
            catch (NumberFormatException e) {
                DMLRelearned.logger.warn("ItemStackBuilder: Invalid stack size entry: {}", (Object)values[1]);
                DMLRelearned.logger.warn("Error message: {}", (Object)e.getMessage());
            }
        }
        int metadata = 0;
        if (values.length > 2) {
            try {
                metadata = Integer.parseInt(values[2]);
            }
            catch (NumberFormatException e) {
                DMLRelearned.logger.warn("ItemStackBuilder: Invalid metadata entry: {}", (Object)values[2]);
                DMLRelearned.logger.warn("Error message: {}", (Object)e.getMessage());
            }
        }
        NBTTagCompound nbt = null;
        if (values.length > 3) {
            String nbtString = String.join((CharSequence)",", Arrays.copyOfRange(values, 3, values.length));
            try {
                nbt = JsonToNBT.func_180713_a((String)nbtString);
            }
            catch (NBTException e) {
                DMLRelearned.logger.warn("ItemStackBuilder: Invalid NBT string: {}", (Object)nbtString);
                DMLRelearned.logger.warn("Error message: {}", (Object)e.getMessage());
            }
        }
        return Optional.of(new ItemStackDefinition(registryName, stackSize, metadata, nbt));
    }

    private static class ItemStackDefinition {
        public final String registryName;
        public final boolean isOre;
        public final int stackSize;
        public final int metadata;
        public final NBTTagCompound nbt;

        public ItemStackDefinition(String registryName, int stackSize, int metadata, @Nullable NBTTagCompound nbt) {
            this.registryName = registryName;
            this.isOre = registryName.startsWith("ore:");
            this.stackSize = stackSize;
            this.metadata = metadata;
            this.nbt = nbt;
        }
    }
}

