/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client.gui;

import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.common.capability.CapabilityPlayerTrial;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class GuiTrialOverlay
extends GuiScreen {
    public static GuiTrialOverlay INSTANCE = new GuiTrialOverlay();
    private static final ResourceLocation TEXTURE = new ResourceLocation("deepmoblearning", "textures/gui/trial_overlay.png");
    private final FontRenderer fontRender;
    private final Minecraft mc = Minecraft.func_71410_x();
    private static CapabilityPlayerTrial clientCapability;
    private long lastTick = 0L;
    private static String lastMessage;
    private static int ticksToRender;
    private static int ticksToRenderGlitchNotification;
    private static int ticksToRenderNextWaveMessage;

    private GuiTrialOverlay() {
        this.fontRender = this.mc.field_71466_p;
        this.field_146296_j = this.mc.func_175599_af();
        this.func_183500_a(89, 12);
    }

    public static void initPlayerCapability() {
        clientCapability = (CapabilityPlayerTrial)DMLRelearned.proxy.getClientPlayerTrialCapability();
    }

    public static void handleMessage(String type) {
        GuiTrialOverlay.initPlayerCapability();
        System.out.println("Message received: " + type);
        switch (type) {
            case "GlitchNotification": {
                ticksToRenderGlitchNotification = 80;
                break;
            }
            case "TrialAborted": {
                ticksToRender = 80;
                lastMessage = I18n.func_135052_a((String)"deepmoblearning.trial.message.aborted", (Object[])new Object[0]);
                break;
            }
            case "TrialCompleted": {
                ticksToRender = 120;
                lastMessage = I18n.func_135052_a((String)"deepmoblearning.trial.message.completed", (Object[])new Object[0]);
                break;
            }
            case "WaveNumber": {
                ticksToRender = 80;
                lastMessage = I18n.func_135052_a((String)"deepmoblearning.trial.message.wave_number", (Object[])new Object[]{clientCapability.getCurrentWave() + 1});
                break;
            }
            case "WaveCountdown": {
                ticksToRenderNextWaveMessage = 118;
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        this.doTickChecks();
        if (!this.mc.field_71415_G || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        if (ticksToRender > 0) {
            this.renderMessage();
        }
        if (ticksToRenderGlitchNotification > 0) {
            this.renderGlitchNotification();
        }
        if (ticksToRenderNextWaveMessage > 0) {
            this.renderWaveCountdown();
        }
        if (clientCapability == null) {
            GuiTrialOverlay.initPlayerCapability();
        }
        if (clientCapability.isTrialActive()) {
            this.renderTrialScoreboard();
        }
    }

    private void doTickChecks() {
        if (this.lastTick != this.mc.field_71441_e.func_82737_E()) {
            this.lastTick = this.mc.field_71441_e.func_82737_E();
            if (ticksToRender > 0) {
                --ticksToRender;
            }
            if (ticksToRenderNextWaveMessage > 0) {
                --ticksToRenderNextWaveMessage;
            }
            if (ticksToRenderGlitchNotification > 0) {
                --ticksToRenderGlitchNotification;
            }
        }
    }

    private void renderWaveCountdown() {
        float scale = 1.6f;
        if (ticksToRenderNextWaveMessage / 20 > 0) {
            String nextWave = I18n.func_135052_a((String)"deepmoblearning.trial.message.next_wave", (Object[])new Object[]{ticksToRenderNextWaveMessage / 20});
            int x = this.getScreenCenterX(scale) - this.getHalfLineWidth(nextWave, scale);
            this.renderScaledString(scale, x, 80, nextWave, 0xFFFFFF);
        }
    }

    private void renderMessage() {
        float scale = lastMessage.length() < 8 ? 2.2f : 1.6f;
        int x = this.getScreenCenterX(scale) - this.getHalfLineWidth(lastMessage, scale);
        this.renderScaledString(scale, x, 80, lastMessage, 0xFFFFFF);
    }

    private void renderGlitchNotification() {
        float scale1 = 1.9f;
        float scale2 = 1.2f;
        String notif1 = I18n.func_135052_a((String)"deepmoblearning.trial.message.glitch_1", (Object[])new Object[0]);
        String notif2 = I18n.func_135052_a((String)"deepmoblearning.trial.message.glitch_2", (Object[])new Object[0]);
        int x1 = this.getScreenCenterX(scale1) - this.getHalfLineWidth(notif1, scale1);
        int x2 = this.getScreenCenterX(scale2) - this.getHalfLineWidth(notif2, scale2);
        int width = this.fontRender.func_78256_a(notif1);
        this.mc.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.getScreenCenterX() - width - 22, 108, 0, 0, 17, 17);
        this.func_73729_b(this.getScreenCenterX() + width + 4, 108, 0, 0, 17, 17);
        this.renderScaledString(scale1, x1, 110, notif1, 13068507);
        this.renderScaledString(scale2, x2, 130, notif2, 0xFFFFFF);
    }

    private void renderTrialScoreboard() {
        int x = this.getRightCornerX() - 50;
        float scale = 1.3f;
        int scaledX = (int)((float)x / scale);
        int y = 145;
        String wave = I18n.func_135052_a((String)"deepmoblearning.trial.message.wave", (Object[])new Object[0]);
        String opponents = I18n.func_135052_a((String)"deepmoblearning.trial.message.opponents", (Object[])new Object[0]);
        String waveCleared = I18n.func_135052_a((String)"deepmoblearning.trial.message.wave_cleared", (Object[])new Object[0]);
        int toKill = clientCapability.getWaveMobTotal() - clientCapability.getDefated();
        String enemiesLeft = I18n.func_135052_a((String)"deepmoblearning.trial.message.enemies_left", (Object[])new Object[]{toKill});
        this.drawItemStack(x - 21, y + 4, new ItemStack(Items.field_151113_aN));
        this.renderScaledString(scale, scaledX, y + 2, wave, 3403740);
        this.func_73731_b(this.fontRender, clientCapability.getCurrentWave() + 1 + "/" + clientCapability.getLastWave(), x + 1, y + 16, 0xFFFFFF);
        ItemStack skull = new ItemStack(Items.field_151144_bL);
        skull.func_77964_b(0);
        this.drawItemStack(x - 21, y + 36, skull);
        this.renderScaledString(scale, scaledX, y + 32, opponents, 3403740);
        if (toKill <= 0) {
            this.func_73731_b(this.fontRender, waveCleared, x + 1, y + 46, 0xFFFFFF);
        } else {
            this.func_73731_b(this.fontRender, enemiesLeft, x + 1, y + 46, 0xFFFFFF);
        }
    }

    private void renderScaledString(float scale, int x, int y, String text, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        this.func_73731_b(this.fontRender, text, x, (int)((float)y / scale), color);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private int getHalfLineWidth(String text, float glScale) {
        return (int)((float)(this.fontRender.func_78256_a(text) / 2) * glScale / glScale);
    }

    private int getScreenCenterX() {
        ScaledResolution scaledResolution = new ScaledResolution(this.mc);
        return scaledResolution.func_78326_a() / 2;
    }

    private int getScreenCenterX(float glScale) {
        return (int)((float)this.getScreenCenterX() / glScale);
    }

    private int getRightCornerX() {
        ScaledResolution scaledResolution = new ScaledResolution(this.mc);
        return scaledResolution.func_78326_a() - this.field_146294_l - 5;
    }

    private void drawItemStack(int x, int y, ItemStack stack) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(this.fontRender, stack, x - 1, y - 1, "");
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
    }

    static {
        lastMessage = "";
        ticksToRender = 0;
        ticksToRenderGlitchNotification = 0;
        ticksToRenderNextWaveMessage = 0;
    }
}

