/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client.gui;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import mustapelto.deepmoblearning.client.gui.buttons.ButtonBase;
import mustapelto.deepmoblearning.common.inventory.ContainerBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class GuiContainerBase
extends GuiContainer {
    protected static final ResourceLocation PLAYER_INVENTORY_TEXTURE = new ResourceLocation("deepmoblearning", "textures/gui/player_inventory.png");
    protected final Minecraft field_146297_k = Minecraft.func_71410_x();
    protected final TextureManager textureManager = this.field_146297_k.func_110434_K();
    protected final FontRenderer field_146289_q;
    protected final World world;
    protected final EntityPlayer player;
    protected boolean buttonListNeedsRebuild = false;
    protected int currentTick = 0;
    protected float lastRedrawTime = 0.0f;
    protected float deltaTime = 0.0f;

    public GuiContainerBase(EntityPlayer player, World world, ContainerBase container, int width, int height) {
        super((Container)container);
        this.field_146289_q = this.field_146297_k.field_71466_p;
        this.player = player;
        this.world = world;
        this.field_146999_f = width;
        this.field_147000_g = height;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.initButtons();
        this.rebuildButtonList();
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.currentTick;
        if (this.buttonListNeedsRebuild) {
            this.rebuildButtonList();
        }
    }

    protected void initButtons() {
    }

    protected void rebuildButtonList() {
        this.buttonListNeedsRebuild = false;
        this.field_146292_n.clear();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.field_146292_n.forEach(button -> {
            if (button instanceof ButtonBase && button.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                this.handleButtonPress((ButtonBase)((Object)button), mouseButton);
            }
        });
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected abstract void handleButtonPress(ButtonBase var1, int var2);

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.getDeltaTime(partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void drawPlayerInventory(int x, int y) {
        this.textureManager.func_110577_a(PLAYER_INVENTORY_TEXTURE);
        this.func_73729_b(x, y, 0, 0, 177, 91);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146292_n.forEach(button -> {
            ImmutableList<String> tooltip;
            if (button instanceof ButtonBase && button.field_146124_l && button.func_146115_a() && !(tooltip = ((ButtonBase)((Object)button)).getTooltip()).isEmpty()) {
                this.func_146283_a((List)tooltip, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
        });
    }

    private void getDeltaTime(float partialTicks) {
        float currentPartial = (float)this.currentTick + partialTicks;
        this.deltaTime = currentPartial - this.lastRedrawTime;
        this.lastRedrawTime = currentPartial;
    }

    protected void drawItemStackWithOverlay(ItemStack stack, int x, int y) {
        int count = stack.func_190916_E();
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(this.field_146289_q, stack, x, y, count > 1 ? String.valueOf(count) : "");
    }
}

