/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.filter;

import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.util.IStringSerializable;

public enum FilterType implements IStringSerializable
{
    PLAYER(0, "player", Items.field_151005_D),
    UNDEAD(1, "undead", "bone"),
    ARTHROPOD(2, "arthropod", Items.field_151070_bp),
    MONSTER(3, "monster", Items.field_151078_bh),
    ANIMAL(4, "animal", "cropWheat"),
    WATER(5, "water", Items.field_151131_as),
    BABY(6, "baby", "egg"),
    PET(7, "pet", Items.field_151117_aB),
    SLIME(8, "slime", Blocks.field_180399_cE),
    FIRERES(9, "fireres", Items.field_151065_br),
    BOSS(10, "boss", "obsidian");

    private static String[] nameList;
    public final int meta;
    public final String type;
    public final Object crafting;

    private FilterType(int meta, String name, Object crafting) {
        this.meta = meta;
        this.type = name;
        this.crafting = crafting;
    }

    public String func_176610_l() {
        return this.type;
    }

    public String toString() {
        return this.type;
    }

    public static FilterType fromMeta(int meta) {
        for (FilterType type : FilterType.values()) {
            if (type.meta != meta) continue;
            return type;
        }
        return PLAYER;
    }

    public static String[] getTypes() {
        if (nameList != null) {
            return nameList;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (FilterType type : FilterType.values()) {
            names.add(type.type);
        }
        nameList = names.toArray(new String[names.size()]);
        return nameList;
    }

    public static boolean isValidTarget(EntityLivingBase living, int meta) {
        switch (meta) {
            case 0: {
                return living instanceof EntityPlayer;
            }
            case 1: {
                return living.func_70668_bt() == EnumCreatureAttribute.UNDEAD;
            }
            case 2: {
                return living.func_70668_bt() == EnumCreatureAttribute.ARTHROPOD;
            }
            case 3: {
                return living instanceof IMob;
            }
            case 4: {
                return living instanceof EntityAnimal;
            }
            case 5: {
                return living instanceof EntityWaterMob || living instanceof EntityGuardian;
            }
            case 6: {
                return living.func_70631_g_();
            }
            case 7: {
                return living instanceof EntityTameable;
            }
            case 8: {
                return living instanceof EntitySlime;
            }
            case 9: {
                return living.func_70045_F() || living.func_70660_b(MobEffects.field_76426_n) != null;
            }
            case 10: {
                return !living.func_184222_aU();
            }
        }
        return false;
    }
}

