/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.blay09.mods.clienttweaks.tweak.AutoJumpMoreLikeAutoDumbAmirite;
import net.blay09.mods.clienttweaks.tweak.AutoLadder;
import net.blay09.mods.clienttweaks.tweak.ClientTweak;
import net.blay09.mods.clienttweaks.tweak.DisablePotionShift;
import net.blay09.mods.clienttweaks.tweak.DoNotUseLastTorch;
import net.blay09.mods.clienttweaks.tweak.HideOffhandItem;
import net.blay09.mods.clienttweaks.tweak.HideOwnEffectParticles;
import net.blay09.mods.clienttweaks.tweak.HideShieldUnlessHoldingWeapon;
import net.blay09.mods.clienttweaks.tweak.MasterVolumeSlider;
import net.blay09.mods.clienttweaks.tweak.NoOffhandTorchWithBlock;
import net.blay09.mods.clienttweaks.tweak.NoOffhandTorchWithEmptyHand;
import net.blay09.mods.clienttweaks.tweak.OffhandTorchWithToolOnly;
import net.blay09.mods.clienttweaks.tweak.Screw3dAnaglyph;
import net.blay09.mods.clienttweaks.tweak.StepAssistIsAnnoying;
import net.blay09.mods.clienttweaks.tweak.UnderlineLooksTerribleInChat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.lwjgl.input.Keyboard;

@Mod(modid="clienttweaks", name="ClientTweaks", acceptedMinecraftVersions="[1.12]", clientSideOnly=true, guiFactory="net.blay09.mods.clienttweaks.GuiFactory")
public class ClientTweaks {
    public static final String MOD_ID = "clienttweaks";
    @Mod.Instance
    public static ClientTweaks instance;
    public static Configuration config;
    private static Map<String, ClientTweak> tweaks;
    private static List<ClientTweak> toggleTweaks;
    public static Set<String> torchItems;
    public static Set<String> torchTools;
    public static Set<String> offhandTorchTools;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (!FMLClientHandler.instance().hasOptifine()) {
            this.registerTweak(new Screw3dAnaglyph());
        }
        this.registerTweak(new AutoJumpMoreLikeAutoDumbAmirite());
        this.registerTweak(new MasterVolumeSlider());
        this.registerTweak(new UnderlineLooksTerribleInChat());
        this.registerTweak(new NoOffhandTorchWithBlock());
        this.registerTweak(new NoOffhandTorchWithEmptyHand());
        this.registerTweak(new OffhandTorchWithToolOnly());
        this.registerTweak(new HideOwnEffectParticles());
        this.registerTweak(new HideOffhandItem());
        this.registerTweak(new StepAssistIsAnnoying());
        this.registerTweak(new AutoLadder());
        this.registerTweak(new DisablePotionShift());
        this.registerTweak(new HideShieldUnlessHoldingWeapon());
        this.registerTweak(new DoNotUseLastTorch());
        config = new Configuration(event.getSuggestedConfigurationFile());
        this.reloadConfig();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (ClientTweak tweak : tweaks.values()) {
            tweak.init(event);
            KeyBinding keyBinding = tweak.registerToggleKeybind();
            if (keyBinding == null) continue;
            toggleTweaks.add(tweak);
        }
    }

    private void reloadConfig() {
        torchItems = Sets.newHashSet((Object[])config.getStringList("Torch Items", "general", new String[]{"minecraft:torch", "tconstruct:stone_torch"}, "Items that count as torches for the offhand-torch tweak options."));
        torchTools = Sets.newHashSet((Object[])config.getStringList("Torch Tools", "general", new String[]{"minecraft:wooden_pickaxe", "minecraft:stone_pickaxe", "minecraft:iron_pickaxe", "minecraft:golden_pickaxe", "minecraft:diamond_pickaxe", "tconstruct:pickaxe", "tconstruct:hammer"}, "Items that will place torches from your hotbar on right-click if enabled."));
        offhandTorchTools = Sets.newHashSet((Object[])config.getStringList("Offhand Torch Tools", "general", new String[]{"tconstruct:shovel", "tconstruct:excavator"}, "Items that will not prevent offhand-torch placement while in offhand, but do not place torches by themselves"));
        for (ClientTweak tweak : tweaks.values()) {
            tweak.setEnabled(config.getBoolean(tweak.getName(), "tweaks", tweak.isEnabledDefault(), tweak.getDescription()));
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            this.reloadConfig();
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (Keyboard.getEventKeyState()) {
            for (ClientTweak tweak : toggleTweaks) {
                if (!tweak.getKeyBinding().isActiveAndMatches(Keyboard.getEventKey())) continue;
                tweak.setEnabled(!tweak.isEnabled());
                config.get("tweaks", tweak.getName(), tweak.isEnabledDefault(), tweak.getDescription()).set(tweak.isEnabled());
                if (config.hasChanged()) {
                    config.save();
                }
                TextComponentString root = new TextComponentString(tweak.getName() + ": ");
                root.func_150257_a((ITextComponent)new TextComponentTranslation(tweak.isEnabled() ? "clienttweaks.on" : "clienttweaks.off", new Object[0]));
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a((ITextComponent)root, 5);
            }
        }
    }

    private void registerTweak(ClientTweak tweak) {
        tweaks.put(tweak.getName(), tweak);
    }

    static {
        tweaks = Maps.newHashMap();
        toggleTweaks = Lists.newArrayList();
        torchItems = Sets.newHashSet();
        torchTools = Sets.newHashSet();
        offhandTorchTools = Sets.newHashSet();
    }
}

