/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui;

import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.BCFontRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.HoverTextSupplier;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventDispatcher;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventListener;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IMouseOver;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.brandonscore.utils.DataUtils;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Mouse;
import scala.Function1;

public class MGuiElementBase<E extends MGuiElementBase<E>>
implements IMouseOver {
    protected static final ResourceLocation WIDGETS_TEXTURES = new ResourceLocation("textures/gui/widgets.png");
    private int xPos;
    private int yPos;
    private int lastTickXPos;
    private int lastTickYPos;
    private int animFrameX;
    private int animFrameY;
    private int animTranslateX;
    private int animTranslateY;
    private int animSpeed;
    private int xSize;
    private int ySize;
    private Point parentRelPos;
    private Point parentInsetRelPos;
    private Insets insets = new Insets(0, 0, 0, 0);
    private boolean enabled = true;
    private boolean elementInitialized = false;
    private Rectangle insetRectangle = new Rectangle();
    private List<String> groups = new ArrayList<String>();
    private MGuiElementBase parentElement = null;
    private Supplier<Boolean> enabledCallback = null;
    private Rectangle rectangle = new Rectangle();
    protected int hoverTime = 0;
    protected int hoverTextDelay = 0;
    protected IDrawCallback preDrawCallback = null;
    protected IDrawCallback postDrawCallback = null;
    protected String id = "";
    protected boolean boundless = false;
    protected boolean drawHoverText = false;
    protected boolean capturesClicks = false;
    protected boolean frameAnimation = false;
    protected boolean disableOnRemove = false;
    protected boolean animatedTranslating = false;
    protected List<MGuiElementBase> toRemove = new ArrayList<MGuiElementBase>();
    protected List<MGuiElementBase> boundSizeElements = new ArrayList<MGuiElementBase>();
    protected List<MGuiElementBase> boundInsetSizeElements = new ArrayList<MGuiElementBase>();
    protected LinkedList<MGuiElementBase> childElements = new LinkedList();
    public int screenWidth;
    public int screenHeight;
    public int displayZLevel = 0;
    public double zOffset = 0.0;
    public Object linkedObject = null;
    public boolean reportXSizeChange = false;
    public boolean reportYSizeChange = false;
    public boolean consumeHoverOverlay = false;
    public Minecraft mc = Minecraft.func_71410_x();
    public IModularGui modularGui;
    public BCFontRenderer fontRenderer;
    protected Consumer<E> onReload;
    protected Consumer<E> onInit;
    protected HoverTextSupplier<?, E> hoverText;
    protected BiFunction<E, Integer, Integer> xPosModifier;
    protected BiFunction<E, Integer, Integer> yPosModifier;
    protected BiFunction<E, Integer, Integer> xSizeModifier;
    protected BiFunction<E, Integer, Integer> ySizeModifier;
    private Vector3 colourRatio;

    public MGuiElementBase() {
        this.fontRenderer = BCFontRenderer.convert(this.mc.field_71466_p);
        this.onReload = null;
        this.onInit = null;
        this.hoverText = null;
        this.xPosModifier = null;
        this.yPosModifier = null;
        this.xSizeModifier = null;
        this.ySizeModifier = null;
        this.colourRatio = new Vector3();
    }

    public MGuiElementBase(int xPos, int yPos) {
        this.fontRenderer = BCFontRenderer.convert(this.mc.field_71466_p);
        this.onReload = null;
        this.onInit = null;
        this.hoverText = null;
        this.xPosModifier = null;
        this.yPosModifier = null;
        this.xSizeModifier = null;
        this.ySizeModifier = null;
        this.colourRatio = new Vector3();
        this.setPos(xPos, yPos);
    }

    public MGuiElementBase(int xPos, int yPos, int xSize, int ySize) {
        this(xPos, yPos);
        this.setSize(xSize, ySize);
    }

    public void addChildElements() {
        if (this.elementInitialized) {
            throw new RuntimeException("MGuiElementBase.addChildElements was fired but child elements have already been added!");
        }
        if (this.onInit != null) {
            this.onInit.accept(this);
        }
        this.elementInitialized = true;
    }

    public void reloadElement() {
        if (this.onReload != null) {
            this.onReload.accept(this);
        }
        for (MGuiElementBase element : this.childElements) {
            element.reloadElement();
        }
    }

    @Deprecated
    public E addReloadCallback(Consumer<E> callBack) {
        this.onReload = this.onReload != null ? this.onReload.andThen(callBack) : callBack;
        return (E)this;
    }

    @Deprecated
    public E addAndFireReloadCallback(Consumer<E> callBack) {
        this.onReload = this.onReload != null ? this.onReload.andThen(callBack) : callBack;
        this.onReload.accept(this);
        return (E)this;
    }

    public E onReload(Consumer<E> callBack) {
        return this.onReload(callBack, true);
    }

    public E onReload(Consumer<E> callBack, boolean callNow) {
        Consumer<E> consumer = this.onReload = this.onReload != null ? this.onReload.andThen(callBack) : callBack;
        if (callNow) {
            this.onReload.accept(this);
        }
        return (E)this;
    }

    public E addInitCallback(Consumer<E> callBack) {
        this.onInit = this.onInit != null ? this.onInit.andThen(callBack) : callBack;
        return (E)this;
    }

    public <C extends MGuiElementBase> C addChild(C child) {
        if (child == this) {
            throw new InvalidParameterException("Attempted to add element to itself as a child element.");
        }
        if (this.childElements.contains(child)) {
            return child;
        }
        this.childElements.add(child);
        this.onChildAdded(child);
        return child;
    }

    public <C extends MGuiElementBase> C addChildFirst(C child) {
        if (this.childElements.contains(child)) {
            return child;
        }
        this.childElements.addFirst(child);
        this.onChildAdded(child);
        return child;
    }

    public E addChildren(Collection<? extends MGuiElementBase> elements) {
        this.childElements.addAll(elements);
        for (MGuiElementBase mGuiElementBase : elements) {
            this.onChildAdded(mGuiElementBase);
        }
        return (E)this;
    }

    protected void onChildAdded(MGuiElementBase childElement) {
        childElement.applyGeneralElementData(this.modularGui, this.mc, this.screenWidth, this.screenHeight, this.fontRenderer);
        childElement.setParent(this);
        if (!childElement.elementInitialized) {
            childElement.addChildElements();
        }
        childElement.reloadElement();
        this.addDefaultListener(childElement);
    }

    protected void addDefaultListener(MGuiElementBase childElement) {
        if (childElement instanceof IGuiEventDispatcher && ((IGuiEventDispatcher)((Object)childElement)).getListener() == null) {
            if (this instanceof IGuiEventListener) {
                ((IGuiEventDispatcher)((Object)childElement)).setListener((IGuiEventListener)((Object)this));
            } else if (this.modularGui instanceof IGuiEventListener) {
                ((IGuiEventDispatcher)((Object)childElement)).setListener((IGuiEventListener)((Object)this.modularGui));
            }
        }
    }

    public <C extends MGuiElementBase> C removeChild(C child) {
        if (child != null && this.childElements.contains(child)) {
            this.toRemove.add(child);
            if (this.disableOnRemove) {
                child.setEnabled(false);
            }
            return child;
        }
        return null;
    }

    public E removeChildByID(String id) {
        for (MGuiElementBase element : this.childElements) {
            if (element.id == null || !element.id.equals(id)) continue;
            this.toRemove.add(element);
        }
        return (E)this;
    }

    public E removeChildByGroup(String group) {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isInGroup(group)) continue;
            this.toRemove.add(element);
        }
        return (E)this;
    }

    public E setChildIDEnabled(String id, boolean enabled) {
        for (MGuiElementBase element : this.childElements) {
            if (element.id == null || !element.id.equals(id)) continue;
            element.enabled = enabled;
            return (E)this;
        }
        return (E)this;
    }

    public E setChildGroupEnabled(String group, boolean enabled) {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isInGroup(group)) continue;
            element.enabled = enabled;
        }
        return (E)this;
    }

    public E setParent(MGuiElementBase parent) {
        this.parentElement = parent;
        if (this.parentRelPos != null) {
            this.setRelPos(this.parentRelPos.x, this.parentRelPos.y);
            this.parentRelPos = null;
        }
        if (this.parentInsetRelPos != null) {
            this.setInsetRelPos(this.parentInsetRelPos.x, this.parentInsetRelPos.y);
            this.parentInsetRelPos = null;
        }
        return (E)this;
    }

    @Nullable
    public MGuiElementBase getParent() {
        return this.parentElement;
    }

    public List<MGuiElementBase> getChildElements() {
        return Collections.unmodifiableList(this.childElements);
    }

    public E addToGroup(String group) {
        this.groups.add(group);
        return (E)this;
    }

    public E removeFromGroup(String group) {
        if (this.groups.contains(group)) {
            this.groups.remove(group);
        }
        return (E)this;
    }

    public E removeFromAllGroups() {
        this.groups.clear();
        return (E)this;
    }

    public boolean isInGroup(String group) {
        return this.groups.contains(group);
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public List<MGuiElementBase> getChildGroup(String group) {
        ArrayList<MGuiElementBase> list = new ArrayList<MGuiElementBase>();
        DataUtils.forEachMatch(this.childElements, elementBase -> elementBase.isInGroup(group), list::add);
        return list;
    }

    public E setId(@Nonnull String id) {
        this.id = id;
        return (E)this;
    }

    public String getId() {
        return this.id;
    }

    public MGuiElementBase findChildById(String id) {
        return DataUtils.firstMatch(this.childElements, elementBase -> elementBase.getId().equals(id));
    }

    public <C extends MGuiElementBase> C findChildById(String id, Class<C> clazz) {
        MGuiElementBase element = DataUtils.firstMatch(this.childElements, elementBase -> elementBase.getId().equals(id) && clazz.isAssignableFrom(elementBase.getClass()));
        return (C)(element == null ? null : (MGuiElementBase)clazz.cast(element));
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return GuiHelper.isInRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), mouseX, mouseY) && this.allowMouseOver(this, mouseX, mouseY);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled() || !element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return this.isMouseOver(mouseX, mouseY) && this.capturesClicks;
    }

    public boolean mouseReleased(int mouseX, int mouseY, int state) {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled() || !element.mouseReleased(mouseX, mouseY, state)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled() || !element.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) continue;
            return true;
        }
        return false;
    }

    public boolean handleMouseInput() {
        int mouseX = Mouse.getEventX() * this.screenWidth / this.mc.field_71443_c;
        int mouseY = this.screenHeight - Mouse.getEventY() * this.screenHeight / this.mc.field_71440_d - 1;
        int scrollDirection = Mouse.getEventDWheel();
        if (scrollDirection != 0) {
            if (this.handleMouseScroll(mouseX, mouseY, scrollDirection)) {
                return true;
            }
            for (MGuiElementBase element : this.childElements) {
                if (!element.isEnabled() || !element.handleMouseScroll(mouseX, mouseY, scrollDirection)) continue;
                return true;
            }
        }
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled() || !element.handleMouseInput()) continue;
            return true;
        }
        return false;
    }

    public boolean handleMouseScroll(int mouseX, int mouseY, int scrollDirection) {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled() || !element.handleMouseScroll(mouseX, mouseY, scrollDirection)) continue;
            return true;
        }
        return false;
    }

    public boolean allowMouseOver(MGuiElementBase elementRequesting, int mouseX, int mouseY) {
        return this.getParent() == null || this.getParent().allowMouseOver(this, mouseX, mouseY);
    }

    public E setCapturesClicks(boolean capturesClicks) {
        this.capturesClicks = capturesClicks;
        return (E)this;
    }

    protected boolean keyTyped(char typedChar, int keyCode) throws IOException {
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled() || !element.keyTyped(typedChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    public boolean onUpdate() {
        int mouseY;
        if (this.frameAnimation && this.animFrameX == 0 && this.animFrameY == 0) {
            this.frameAnimation = false;
        }
        this.lastTickXPos = this.xPos;
        this.lastTickYPos = this.yPos;
        if (this.frameAnimation) {
            this.frameAnimation = false;
            this.translate(this.animFrameX, this.animFrameY);
            this.animFrameY = 0;
            this.animFrameX = 0;
            this.frameAnimation = true;
        }
        if (!this.toRemove.isEmpty()) {
            this.childElements.removeAll(this.toRemove);
            this.toRemove.clear();
            return true;
        }
        int mouseX = Mouse.getX() * this.screenWidth / this.mc.field_71443_c;
        this.hoverTime = this.isMouseOver(mouseX, mouseY = this.screenHeight - Mouse.getY() * this.screenHeight / this.mc.field_71440_d - 1) ? ++this.hoverTime : 0;
        if (this.animatedTranslating) {
            int x = net.minecraft.util.math.MathHelper.func_76125_a((int)this.animTranslateX, (int)(-this.animSpeed), (int)this.animSpeed);
            int y = net.minecraft.util.math.MathHelper.func_76125_a((int)this.animTranslateY, (int)(-this.animSpeed), (int)this.animSpeed);
            this.animTranslateX -= x;
            this.animTranslateY -= y;
            this.animateMoveFrames();
            this.translate(x, y);
            if (this.animTranslateX == 0 && this.animTranslateY == 0) {
                this.animatedTranslating = false;
            }
        }
        for (MGuiElementBase element : this.childElements) {
            if (!element.onUpdate()) continue;
            return true;
        }
        return false;
    }

    public final void preDraw(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.preDrawCallback != null) {
            this.preDrawCallback.call(minecraft, mouseX, mouseY, partialTicks, this.isMouseOver(mouseX, mouseY));
        }
    }

    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.frameAnimation) {
            GlStateManager.func_179094_E();
            double x = ((double)this.lastTickXPos - (double)this.xPos) * (double)partialTicks;
            double y = ((double)this.lastTickYPos - (double)this.yPos) * (double)partialTicks;
            GlStateManager.func_179137_b((double)x, (double)y, (double)0.0);
        }
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled()) continue;
            element.preDraw(minecraft, mouseX, mouseY, partialTicks);
            element.renderElement(minecraft, mouseX, mouseY, partialTicks);
            element.postDraw(minecraft, mouseX, mouseY, partialTicks);
        }
        if (this.frameAnimation) {
            GlStateManager.func_179121_F();
        }
    }

    public final void postDraw(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.postDrawCallback != null) {
            this.postDrawCallback.call(minecraft, mouseX, mouseY, partialTicks, this.isMouseOver(mouseX, mouseY));
        }
    }

    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        List<String> hoverText;
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled() || !element.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks)) continue;
            return true;
        }
        if (this.isHoverTextEnabled() && this.isMouseOver(mouseX, mouseY) && this.hoverTime >= this.hoverTextDelay && !(hoverText = this.getHoverText()).isEmpty()) {
            this.drawHoveringText(hoverText, mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
            return true;
        }
        return this.isMouseOver(mouseX, mouseY) && this.consumeHoverOverlay;
    }

    public int xPos() {
        return this.xPosModifier != null ? this.xPosModifier.apply(this, this.xPos) : this.xPos;
    }

    public int maxXPos() {
        return this.xPos() + this.xSize();
    }

    public int yPos() {
        return this.yPosModifier != null ? this.yPosModifier.apply(this, this.yPos) : this.yPos;
    }

    public int maxYPos() {
        return this.yPos() + this.ySize();
    }

    public E translate(int xAmount, int yAmount) {
        if (this.frameAnimation) {
            this.animFrameX += xAmount;
            this.animFrameY += yAmount;
            return (E)this;
        }
        this.xPos += xAmount;
        this.yPos += yAmount;
        for (MGuiElementBase element : this.childElements) {
            element.translate(xAmount, yAmount);
        }
        return (E)this;
    }

    public E translateAnim(int xAmount, int yAmount, int speed) {
        this.animTranslateX += xAmount;
        this.animTranslateY += yAmount;
        this.animSpeed = speed;
        this.animatedTranslating = true;
        return (E)this;
    }

    @Deprecated
    public E animateMoveFrames() {
        this.frameAnimation = true;
        return (E)this;
    }

    public E setXPos(int x) {
        this.translate(x - this.xPos(), 0);
        return (E)this;
    }

    public E setYPos(int y) {
        this.translate(0, y - this.yPos());
        return (E)this;
    }

    public E setPos(int x, int y) {
        this.translate(x - this.xPos(), y - this.yPos());
        return (E)this;
    }

    public E setPos(MGuiElementBase element) {
        this.setPos(element.xPos(), element.yPos());
        return (E)this;
    }

    public E setRawPos(int x, int y) {
        this.xPos = x;
        this.yPos = y;
        return (E)this;
    }

    public E setPosModifiers(BiFunction<E, Integer, Integer> xMod, BiFunction<E, Integer, Integer> yMod) {
        this.xPosModifier = xMod;
        this.yPosModifier = yMod;
        return (E)this;
    }

    public E setXPosMod(BiFunction<E, Integer, Integer> xMod) {
        this.xPosModifier = xMod;
        return (E)this;
    }

    public E setYPosMod(BiFunction<E, Integer, Integer> yMod) {
        this.yPosModifier = yMod;
        return (E)this;
    }

    public E setXPosMod(Supplier<Integer> xMod) {
        return (E)this.setXPosMod((E e, Integer integer) -> (Integer)xMod.get());
    }

    public E setYPosMod(Supplier<Integer> yMod) {
        return (E)this.setYPosMod((E e, Integer integer) -> (Integer)yMod.get());
    }

    public E setRelPos(int xOffset, int yOffset) {
        if (this.getParent() == null) {
            this.parentRelPos = new Point(xOffset, yOffset);
        } else {
            this.setPos(this.getParent().xPos() + xOffset, this.getParent().yPos() + yOffset);
        }
        return (E)this;
    }

    public E setRelPos(@Nonnull MGuiElementBase relativeTo, int xOffset, int yOffset) {
        this.setPos(relativeTo.xPos() + xOffset, relativeTo.yPos() + yOffset);
        return (E)this;
    }

    public E setRelPosRight(@Nonnull MGuiElementBase relativeTo, int xOffset, int yOffset) {
        this.setPos(relativeTo.maxXPos() + xOffset, relativeTo.yPos() + yOffset);
        return (E)this;
    }

    public E setRelPosBottom(@Nonnull MGuiElementBase relativeTo, int xOffset, int yOffset) {
        this.setPos(relativeTo.xPos() + xOffset, relativeTo.maxYPos() + yOffset);
        return (E)this;
    }

    public E setRelPosBottomRight(@Nonnull MGuiElementBase relativeTo, int xOffset, int yOffset) {
        this.setPos(relativeTo.maxXPos() + xOffset, relativeTo.maxYPos() + yOffset);
        return (E)this;
    }

    public E setInsetRelPos(int xOffset, int yOffset) {
        if (this.getParent() == null) {
            this.parentInsetRelPos = new Point(xOffset, yOffset);
        } else {
            this.setPos(this.getParent().getInsetRect().x + xOffset, this.getParent().getInsetRect().y + yOffset);
        }
        return (E)this;
    }

    public E normalizePosition() {
        if (this.xPos() < 0) {
            this.setXPos(0);
        }
        if (this.yPos() < 0) {
            this.setYPos(0);
        }
        if (this.maxXPos() > this.screenWidth) {
            this.setXPos(this.screenWidth - this.xSize());
        }
        if (this.maxYPos() > this.screenHeight) {
            this.setYPos(this.screenHeight - this.ySize());
        }
        return (E)this;
    }

    public int xSize() {
        return this.xSizeModifier != null ? this.xSizeModifier.apply(this, this.xSize) : this.xSize;
    }

    public int ySize() {
        return this.ySizeModifier != null ? this.ySizeModifier.apply(this, this.ySize) : this.ySize;
    }

    public E setXSize(int xSize) {
        if (this.animatedTranslating) {
            this.animatedTranslating = false;
            this.translate(this.animTranslateX, this.animTranslateY);
            this.animTranslateX = 0;
            this.animTranslateY = 0;
        }
        this.xSize = xSize;
        this.boundSizeElements.forEach(elementBase -> elementBase.setXSize(this.xSize()));
        this.boundInsetSizeElements.forEach(elementBase -> elementBase.setXSize(this.getInsetRect().width));
        this.xSizeChanged(this);
        return (E)this;
    }

    public E setYSize(int ySize) {
        if (this.animatedTranslating) {
            this.animatedTranslating = false;
            this.translate(this.animTranslateX, this.animTranslateY);
            this.animTranslateX = 0;
            this.animTranslateY = 0;
        }
        this.ySize = ySize;
        this.boundSizeElements.forEach(elementBase -> elementBase.setYSize(this.ySize()));
        this.boundInsetSizeElements.forEach(elementBase -> elementBase.setYSize(this.getInsetRect().height));
        this.ySizeChanged(this);
        return (E)this;
    }

    public E setSize(int xSize, int ySize) {
        this.setXSize(xSize);
        this.setYSize(ySize);
        return (E)this;
    }

    public E setSize(MGuiElementBase element) {
        this.setSize(element.xSize(), element.ySize());
        return (E)this;
    }

    public E setSize(Rectangle rect) {
        this.setSize(rect.width, rect.height);
        return (E)this;
    }

    public E addToXSize(int x) {
        this.setXSize(this.xSize() + x);
        return (E)this;
    }

    public E addToYSize(int y) {
        this.setYSize(this.ySize() + y);
        return (E)this;
    }

    public E addToSize(int x, int y) {
        this.addToXSize(x);
        this.addToYSize(y);
        return (E)this;
    }

    public E bindSize(MGuiElementBase element, boolean insetSize) {
        if (insetSize) {
            element.boundInsetSizeElements.add(this);
        } else {
            element.boundSizeElements.add(this);
        }
        return (E)this;
    }

    public E imposeSize(MGuiElementBase element, boolean insetSize) {
        if (insetSize) {
            this.boundInsetSizeElements.add(element);
        } else {
            this.boundSizeElements.add(element);
        }
        return (E)this;
    }

    public E setSizeModifiers(BiFunction<E, Integer, Integer> xMod, BiFunction<E, Integer, Integer> yMod) {
        this.xSizeModifier = xMod;
        this.ySizeModifier = yMod;
        return (E)this;
    }

    public E setXSizeMod(BiFunction<E, Integer, Integer> xMod) {
        this.xSizeModifier = xMod;
        return (E)this;
    }

    public E setYSizeMod(BiFunction<E, Integer, Integer> yMod) {
        this.ySizeModifier = yMod;
        return (E)this;
    }

    public E setXSizeMod(Supplier<Integer> xMod) {
        return (E)this.setXSizeMod((E e, Integer integer) -> (Integer)xMod.get());
    }

    public E setYSizeMod(Supplier<Integer> yMod) {
        return (E)this.setYSizeMod((E e, Integer integer) -> (Integer)yMod.get());
    }

    public void xSizeChanged(MGuiElementBase elementChanged) {
        if (this.getParent() != null) {
            this.getParent().xSizeChanged(this);
        }
    }

    public void ySizeChanged(MGuiElementBase elementChanged) {
        if (this.getParent() != null) {
            this.getParent().ySizeChanged(this);
        }
    }

    public E setPosAndSize(MGuiElementBase element) {
        this.setPos(element);
        this.setSize(element);
        return (E)this;
    }

    public E setPosAndSize(Rectangle rect) {
        this.setPos(rect.x, rect.y);
        this.setSize(rect.width, rect.height);
        return (E)this;
    }

    public E setPosAndSize(int xPos, int yPos, int xSize, int ySize) {
        this.setPos(xPos, yPos);
        this.setSize(xSize, ySize);
        return (E)this;
    }

    public Rectangle getRect() {
        this.rectangle.setBounds(this.xPos(), this.yPos(), this.xSize(), this.ySize());
        return this.rectangle;
    }

    public Rectangle getEnclosingRect() {
        return this.addBoundsToRect(this.getRect().getBounds());
    }

    public Rectangle addBoundsToRect(Rectangle enclosingRect) {
        if (!this.boundless) {
            int enRectMaxX = (int)enclosingRect.getMaxX();
            int enRectMaxY = (int)enclosingRect.getMaxY();
            if (this.getRect().x < enclosingRect.x) {
                enclosingRect.x = this.getRect().x;
                enclosingRect.width = enRectMaxX - enclosingRect.x;
            }
            if (this.getRect().getMaxX() > (double)enRectMaxX) {
                enclosingRect.width = (int)this.getRect().getMaxX() - enclosingRect.x;
            }
            if (this.getRect().y < enclosingRect.y) {
                enclosingRect.y = this.getRect().y;
                enclosingRect.height = enRectMaxY - enclosingRect.y;
            }
            if (this.getRect().getMaxY() > (double)enRectMaxY) {
                enclosingRect.height = (int)this.getRect().getMaxY() - enclosingRect.y;
            }
        }
        for (MGuiElementBase element : this.childElements) {
            if (this.toRemove.contains(element) || !element.isEnabled()) continue;
            element.addBoundsToRect(enclosingRect);
        }
        return enclosingRect;
    }

    public E setInsets(Insets insets) {
        this.insets = insets;
        return (E)this;
    }

    public E setInsets(int top, int left, int bottom, int right) {
        this.insets.set(top, left, bottom, right);
        return (E)this;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Rectangle getInsetRect() {
        this.insetRectangle.setBounds(this.getRect());
        this.insetRectangle.setLocation(this.xPos() + this.getInsets().left, this.yPos() + this.getInsets().top);
        this.insetRectangle.setSize(this.xSize() - (this.getInsets().left + this.getInsets().right), this.ySize() - (this.getInsets().top + this.getInsets().bottom));
        return this.insetRectangle;
    }

    public GuiScreen getScreen() {
        return this.modularGui.getScreen();
    }

    public void bindTexture(ResourceLocation texture) {
        if (this.mc != null) {
            this.mc.func_110434_K().func_110577_a(texture);
        }
    }

    public void applyGeneralElementData(IModularGui modularGui, Minecraft mc, int width, int height, BCFontRenderer fontRenderer) {
        this.mc = mc;
        this.fontRenderer = fontRenderer;
        this.screenWidth = width;
        this.screenHeight = height;
        this.modularGui = modularGui;
        for (MGuiElementBase element : this.childElements) {
            element.applyGeneralElementData(modularGui, mc, width, height, fontRenderer);
        }
    }

    public void initializeElementData(MGuiElementBase initializer) {
        this.mc = initializer.mc;
        if (this.mc == null) {
            this.mc = Minecraft.func_71410_x();
        }
        this.fontRenderer = initializer.fontRenderer;
        this.screenWidth = initializer.screenWidth;
        this.screenHeight = initializer.screenHeight;
        this.modularGui = initializer.modularGui;
        for (MGuiElementBase element : this.childElements) {
            element.applyGeneralElementData(this.modularGui, this.mc, this.screenWidth, this.screenHeight, this.fontRenderer);
        }
    }

    public E setLinkedObject(Object linkedObject) {
        this.linkedObject = linkedObject;
        return (E)this;
    }

    public E setEnabled(boolean enabled) {
        this.enabled = enabled;
        return (E)this;
    }

    public E setEnabledCallback(Supplier<Boolean> enabledCallback) {
        this.enabledCallback = enabledCallback;
        return (E)this;
    }

    public boolean isEnabled() {
        return this.enabledCallback == null ? this.enabled : this.enabledCallback.get();
    }

    public boolean isElementInitialized() {
        return this.elementInitialized;
    }

    public int distFromElement(int x, int y) {
        if (x >= this.xPos() && x <= this.xPos() + this.xSize() && y >= this.yPos() && y <= this.yPos() + this.ySize()) {
            return 0;
        }
        int xDist = x < this.xPos() ? this.xPos() - x : x - (this.xPos() + this.xSize());
        int yDist = y < this.yPos() ? this.yPos() - y : y - (this.yPos() + this.ySize());
        return Math.max(xDist, yDist);
    }

    public List<MGuiElementBase> getElementsAtPosition(int posX, int posY, List<MGuiElementBase> list) {
        if (this.isMouseOver(posX, posY)) {
            list.add(this);
        }
        for (MGuiElementBase element : this.childElements) {
            element.getElementsAtPosition(posX, posY, list);
        }
        return list;
    }

    public <C extends MGuiElementBase> List<C> findChildElementsByClass(Class<C> clazz, List<C> list) {
        if (clazz.isAssignableFrom(this.getClass())) {
            list.add(clazz.cast(this));
        }
        for (MGuiElementBase element : this.childElements) {
            element.findChildElementsByClass(clazz, list);
        }
        return list;
    }

    public E setPreDrawCallback(IDrawCallback preDrawCallback) {
        this.preDrawCallback = preDrawCallback;
        return (E)this;
    }

    public E setPostDrawCallback(IDrawCallback postDrawCallback) {
        this.postDrawCallback = postDrawCallback;
        return (E)this;
    }

    public String toString() {
        return String.format("%s:[x=%s,y=%s,w=%s,h=%s|ix=%s,iy=%s,iw=%s,ih=%s]", this.getClass().getSimpleName(), this.xPos(), this.yPos(), this.xSize(), this.ySize(), this.getInsetRect().x, this.getInsetRect().y, this.getInsetRect().width, this.getInsetRect().height);
    }

    public double getRenderZLevel() {
        return (double)this.modularGui.getZLevel() + this.zOffset;
    }

    public void drawHorizontalLine(double startX, double endX, double y, int color) {
        if (endX < startX) {
            double i = startX;
            startX = endX;
            endX = i;
        }
        this.drawRect(startX, y, endX + 1.0, y + 1.0, color);
    }

    public void drawVerticalLine(double x, double startY, double endY, int color) {
        if (endY < startY) {
            double i = startY;
            startY = endY;
            endY = i;
        }
        this.drawRect(x, startY + 1.0, x + 1.0, endY, color);
    }

    public void drawRect(double left, double top, double right, double bottom, int color) {
        double zLevel = this.getRenderZLevel();
        if (left < right) {
            double i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            double j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(left, bottom, zLevel).func_181675_d();
        buffer.func_181662_b(right, bottom, zLevel).func_181675_d();
        buffer.func_181662_b(right, top, zLevel).func_181675_d();
        buffer.func_181662_b(left, top, zLevel).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        double zLevel = this.getRenderZLevel();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), zLevel).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, zLevel).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawTexturedModalRect(double xCoord, double yCoord, int minU, int minV, int maxU, int maxV) {
        double zLevel = this.getRenderZLevel();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(xCoord + 0.0, yCoord + (double)maxV, zLevel).func_187315_a((double)((float)minU * 0.00390625f), (double)((float)(minV + maxV) * 0.00390625f)).func_181675_d();
        buffer.func_181662_b(xCoord + (double)maxU, yCoord + (double)maxV, zLevel).func_187315_a((double)((float)(minU + maxU) * 0.00390625f), (double)((float)(minV + maxV) * 0.00390625f)).func_181675_d();
        buffer.func_181662_b(xCoord + (double)maxU, yCoord + 0.0, zLevel).func_187315_a((double)((float)(minU + maxU) * 0.00390625f), (double)((float)minV * 0.00390625f)).func_181675_d();
        buffer.func_181662_b(xCoord + 0.0, yCoord + 0.0, zLevel).func_187315_a((double)((float)minU * 0.00390625f), (double)((float)minV * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        double zLevel = this.getRenderZLevel();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)xCoord, (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b((double)(xCoord + widthIn), (double)yCoord, zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b((double)xCoord, (double)yCoord, zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawModalRectWithCustomSizedTexture(double x, double y, double u, double v, double width, double height, double textureWidth, double textureHeight) {
        double zLevel = this.getRenderZLevel();
        double f = 1.0 / textureWidth;
        double f1 = 1.0 / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x, y + height, zLevel).func_187315_a(u * f, (v + height) * f1).func_181675_d();
        buffer.func_181662_b(x + width, y + height, zLevel).func_187315_a((u + width) * f, (v + height) * f1).func_181675_d();
        buffer.func_181662_b(x + width, y, zLevel).func_187315_a((u + width) * f, v * f1).func_181675_d();
        buffer.func_181662_b(x, y, zLevel).func_187315_a(u * f, v * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawScaledCustomSizeModalRect(double xPos, double yPos, double u, double v, double uWidth, double vHeight, double width, double height, double textureSheetWidth, double testureSheetHeight) {
        double zLevel = this.getRenderZLevel();
        double f = 1.0 / textureSheetWidth;
        double f1 = 1.0 / testureSheetHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(xPos, yPos + height, zLevel).func_187315_a(u * f, (v + vHeight) * f1).func_181675_d();
        buffer.func_181662_b(xPos + width, yPos + height, zLevel).func_187315_a((u + uWidth) * f, (v + vHeight) * f1).func_181675_d();
        buffer.func_181662_b(xPos + width, yPos, zLevel).func_187315_a((u + uWidth) * f, v * f1).func_181675_d();
        buffer.func_181662_b(xPos, yPos, zLevel).func_187315_a(u * f, v * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawHoveringText(@Nonnull ItemStack stack, List<String> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, BCFontRenderer font) {
        if (!textLines.isEmpty()) {
            RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, textLines, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, (FontRenderer)font);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            mouseX = event.getX();
            mouseY = event.getY();
            screenWidth = event.getScreenWidth();
            screenHeight = event.getScreenHeight();
            maxTextWidth = event.getMaxWidth();
            font = event.getFontRenderer() == font ? font : BCFontRenderer.convert(event.getFontRenderer());
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = font.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY + tooltipHeight + 6 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 6;
            }
            this.zOffset += 1.0;
            int backgroundColor = -267386864;
            this.drawGradientRect(tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, -267386864, -267386864);
            this.drawGradientRect(tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, -267386864, -267386864);
            this.drawGradientRect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            this.drawGradientRect(tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            this.drawGradientRect(tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            int borderColorStart = 0x505000FF;
            int borderColorEnd = 1344798847;
            this.drawGradientRect(tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, 0x505000FF, 1344798847);
            this.drawGradientRect(tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, 0x505000FF, 1344798847);
            this.drawGradientRect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, 0x505000FF, 0x505000FF);
            this.drawGradientRect(tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, 1344798847, 1344798847);
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, textLines, tooltipX, tooltipY, (FontRenderer)font, tooltipTextWidth, tooltipHeight));
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = textLines.get(lineNumber);
                this.drawString(font, line, tooltipX, tooltipY, -1, true);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            this.zOffset -= 1.0;
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, textLines, tooltipX, tooltipTop, (FontRenderer)font, tooltipTextWidth, tooltipHeight));
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    public int drawString(BCFontRenderer fontRenderer, String text, float x, float y, int colour) {
        return this.drawString(fontRenderer, text, x, y, colour, false);
    }

    public int drawString(BCFontRenderer fontRenderer, String text, float x, float y, int colour, boolean dropShadow) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(this.getRenderZLevel() + 1.0));
        int i = fontRenderer.func_175065_a(text, x, y, colour, dropShadow);
        GlStateManager.func_179121_F();
        return i;
    }

    public void drawCenteredString(BCFontRenderer fontRenderer, String text, float x, float y, int colour, boolean dropShadow) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(this.getRenderZLevel() + 1.0));
        fontRenderer.func_175065_a(text, x - (float)(fontRenderer.func_78256_a(text) / 2), y, colour, dropShadow);
        GlStateManager.func_179121_F();
    }

    public void drawSplitString(BCFontRenderer fontRenderer, String text, float x, float y, int wrapWidth, int colour, boolean dropShadow) {
        for (String s : fontRenderer.func_78271_c(text, wrapWidth)) {
            this.drawString(fontRenderer, s, x, y, colour, dropShadow);
            y += (float)fontRenderer.field_78288_b;
        }
    }

    public void drawCenteredSplitString(BCFontRenderer fontRenderer, String str, float x, float y, int wrapWidth, int colour, boolean dropShadow) {
        for (String s : fontRenderer.func_78271_c(str, wrapWidth)) {
            this.drawCenteredString(fontRenderer, s, x, y, colour, dropShadow);
            y += (float)fontRenderer.field_78288_b;
        }
    }

    public void drawCustomString(BCFontRenderer fr, String text, float x, float y, int width, int colour, GuiAlign alignment, GuiAlign.TextRotation rotation, boolean wrap, boolean trim, boolean dropShadow) {
        if (width <= 0) {
            return;
        }
        if (trim && fr.func_78256_a(text) > width - 4) {
            text = fr.func_78269_a(text, width - 8) + "..";
        }
        if (rotation == GuiAlign.TextRotation.NORMAL) {
            if (wrap) {
                this.drawAlignedSplitString(fr, text, x, y, width, alignment, colour, dropShadow);
            } else {
                this.drawAlignedString(fr, text, x, y, width, alignment, colour, dropShadow, trim);
            }
        } else {
            GlStateManager.func_179094_E();
            if (rotation == GuiAlign.TextRotation.ROT_C) {
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            } else if (rotation == GuiAlign.TextRotation.ROT_CC) {
                GlStateManager.func_179109_b((float)x, (float)(y + (float)width), (float)0.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            } else if (rotation == GuiAlign.TextRotation.ROT_180) {
                GlStateManager.func_179109_b((float)(x + (float)width), (float)(y + (float)fr.func_78267_b(text, width)), (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (wrap) {
                this.drawAlignedSplitString(fr, text, 0.0f, 0.0f, width, alignment, colour, dropShadow);
            } else {
                this.drawAlignedString(fr, text, 0.0f, 0.0f, width, alignment, colour, dropShadow, trim);
            }
            GlStateManager.func_179121_F();
        }
    }

    public void drawAlignedSplitString(BCFontRenderer fontRenderer, String text, float x, float y, int width, GuiAlign alignment, int colour, boolean dropShadow) {
        for (String s : fontRenderer.func_78271_c(text, width)) {
            this.drawAlignedString(fontRenderer, s, x, y, width, alignment, colour, dropShadow, false);
            y += (float)fontRenderer.field_78288_b;
        }
    }

    public void drawAlignedString(BCFontRenderer fr, String text, float x, float y, int width, GuiAlign alignment, int colour, boolean dropShadow, boolean trim) {
        if (trim && fr.func_78256_a(text) > width - 4) {
            text = fr.func_78269_a(text, width - 8) + "..";
        }
        int stringWidth = fr.func_78256_a(text);
        switch (alignment) {
            case LEFT: {
                this.drawString(this.fontRenderer, text, x, y, colour, dropShadow);
                break;
            }
            case CENTER: {
                this.drawString(this.fontRenderer, text, x + (float)((width - stringWidth) / 2), y, colour, dropShadow);
                break;
            }
            case RIGHT: {
                this.drawString(this.fontRenderer, text, x + (float)(width - stringWidth), y, colour, dropShadow);
            }
        }
    }

    public void drawHoveringText(List<String> textLines, int mouseX, int mouseY, BCFontRenderer font, int screenWidth, int screenHeight) {
        this.drawHoveringText(textLines, mouseX, mouseY, font, screenWidth, screenHeight, -1);
    }

    public void drawHoveringText(List<String> textLines, int mouseX, int mouseY, BCFontRenderer font, int screenWidth, int screenHeight, int maxTextWidth) {
        if (!textLines.isEmpty()) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = font.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY + tooltipHeight + 6 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 6;
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            }
            this.zOffset += 1.0;
            int backgroundColor = -267386864;
            this.drawGradientRect(tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, -267386864, -267386864);
            this.drawGradientRect(tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, -267386864, -267386864);
            this.drawGradientRect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            this.drawGradientRect(tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            this.drawGradientRect(tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, -267386864, -267386864);
            int borderColorStart = 0x505000FF;
            int borderColorEnd = 1344798847;
            this.drawGradientRect(tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, 0x505000FF, 1344798847);
            this.drawGradientRect(tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, 0x505000FF, 1344798847);
            this.drawGradientRect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, 0x505000FF, 0x505000FF);
            this.drawGradientRect(tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, 1344798847, 1344798847);
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line;
                line = textLines.get(lineNumber);
                this.drawString(font, line, tooltipX, tooltipY, -1, true);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            this.zOffset -= 1.0;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    public void drawGradientRect(double left, double top, double right, double bottom, int colour1, int colour2) {
        double zLevel = this.getRenderZLevel();
        float alpha1 = (float)(colour1 >> 24 & 0xFF) / 255.0f;
        float red1 = (float)(colour1 >> 16 & 0xFF) / 255.0f;
        float green1 = (float)(colour1 >> 8 & 0xFF) / 255.0f;
        float blue1 = (float)(colour1 & 0xFF) / 255.0f;
        float alpha2 = (float)(colour2 >> 24 & 0xFF) / 255.0f;
        float red2 = (float)(colour2 >> 16 & 0xFF) / 255.0f;
        float green2 = (float)(colour2 >> 8 & 0xFF) / 255.0f;
        float blue2 = (float)(colour2 & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(right, top, zLevel).func_181666_a(red1, green1, blue1, alpha1).func_181675_d();
        buffer.func_181662_b(left, top, zLevel).func_181666_a(red1, green1, blue1, alpha1).func_181675_d();
        buffer.func_181662_b(left, bottom, zLevel).func_181666_a(red2, green2, blue2, alpha2).func_181675_d();
        buffer.func_181662_b(right, bottom, zLevel).func_181666_a(red2, green2, blue2, alpha2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public void drawMultiPassGradientRect(double left, double top, double right, double bottom, int colour1, int colour2, int layers) {
        double zLevel = this.getRenderZLevel();
        float alpha1 = (float)(colour1 >> 24 & 0xFF) / 255.0f;
        float red1 = (float)(colour1 >> 16 & 0xFF) / 255.0f;
        float green1 = (float)(colour1 >> 8 & 0xFF) / 255.0f;
        float blue1 = (float)(colour1 & 0xFF) / 255.0f;
        float alpha2 = (float)(colour2 >> 24 & 0xFF) / 255.0f;
        float red2 = (float)(colour2 >> 16 & 0xFF) / 255.0f;
        float green2 = (float)(colour2 >> 8 & 0xFF) / 255.0f;
        float blue2 = (float)(colour2 & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i < layers; ++i) {
            buffer.func_181662_b(right, top, zLevel).func_181666_a(red1, green1, blue1, alpha1).func_181675_d();
            buffer.func_181662_b(left, top, zLevel).func_181666_a(red1, green1, blue1, alpha1).func_181675_d();
            buffer.func_181662_b(left, bottom, zLevel).func_181666_a(red2, green2, blue2, alpha2).func_181675_d();
            buffer.func_181662_b(right, bottom, zLevel).func_181666_a(red2, green2, blue2, alpha2).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public void drawColouredRect(double posX, double posY, double xSize, double ySize, int colour) {
        this.drawGradientRect(posX, posY, posX + xSize, posY + ySize, colour, colour);
    }

    public void drawBorderedRect(double posX, double posY, double xSize, double ySize, double borderWidth, int fillColour, int borderColour) {
        this.drawColouredRect(posX, posY, xSize, borderWidth, borderColour);
        this.drawColouredRect(posX, posY + ySize - borderWidth, xSize, borderWidth, borderColour);
        this.drawColouredRect(posX, posY + borderWidth, borderWidth, ySize - 2.0 * borderWidth, borderColour);
        this.drawColouredRect(posX + xSize - borderWidth, posY + borderWidth, borderWidth, ySize - 2.0 * borderWidth, borderColour);
        this.drawColouredRect(posX + borderWidth, posY + borderWidth, xSize - 2.0 * borderWidth, ySize - 2.0 * borderWidth, fillColour);
    }

    public void drawShadedRect(int x, int y, int width, int height, int borderWidth, int fill, int topLeftColour, int bottomRightColour, int cornerMixColour) {
        this.drawColouredRect(x + borderWidth, y + borderWidth, width - borderWidth * 2, height - borderWidth * 2, fill);
        this.drawColouredRect(x, y, width - borderWidth, borderWidth, topLeftColour);
        this.drawColouredRect(x, y + borderWidth, borderWidth, height - borderWidth * 2, topLeftColour);
        this.drawColouredRect(x + borderWidth, y + height - borderWidth, width - borderWidth, borderWidth, bottomRightColour);
        this.drawColouredRect(x + width - borderWidth, y + borderWidth, borderWidth, height - borderWidth * 2, bottomRightColour);
        this.drawColouredRect(x + width - borderWidth, y, borderWidth, borderWidth, cornerMixColour);
        this.drawColouredRect(x, y + height - borderWidth, borderWidth, borderWidth, cornerMixColour);
    }

    public static int mixColours(int colour1, int colour2) {
        return MGuiElementBase.mixColours(colour1, colour2, false);
    }

    public static int mixColours(int colour1, int colour2, boolean subtract) {
        int alpha1 = colour1 >> 24 & 0xFF;
        int alpha2 = colour2 >> 24 & 0xFF;
        int red1 = colour1 >> 16 & 0xFF;
        int red2 = colour2 >> 16 & 0xFF;
        int green1 = colour1 >> 8 & 0xFF;
        int green2 = colour2 >> 8 & 0xFF;
        int blue1 = colour1 & 0xFF;
        int blue2 = colour2 & 0xFF;
        int alpha = net.minecraft.util.math.MathHelper.func_76125_a((int)(alpha1 + (subtract ? -alpha2 : alpha2)), (int)0, (int)255);
        int red = net.minecraft.util.math.MathHelper.func_76125_a((int)(red1 + (subtract ? -red2 : red2)), (int)0, (int)255);
        int green = net.minecraft.util.math.MathHelper.func_76125_a((int)(green1 + (subtract ? -green2 : green2)), (int)0, (int)255);
        int blue = net.minecraft.util.math.MathHelper.func_76125_a((int)(blue1 + (subtract ? -blue2 : blue2)), (int)0, (int)255);
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public void renderVanillaButtonTexture(int xPos, int yPos, int xSize, int ySize, boolean hovered, boolean disabled) {
        ResourceHelperBC.bindTexture(WIDGETS_TEXTURES);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = 1;
        if (disabled) {
            k = 0;
        } else if (hovered) {
            k = 2;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int texHeight = Math.min(20, ySize);
        int texPos = 46 + k * 20;
        this.drawTexturedModalRect(xPos, yPos, 0, texPos, xSize % 2 + xSize / 2, texHeight);
        this.drawTexturedModalRect(xSize % 2 + xPos + xSize / 2, yPos, 200 - xSize / 2, texPos, xSize / 2, texHeight);
        if (ySize < 20) {
            this.drawTexturedModalRect(xPos, yPos + 3, 0, texPos + 20 - ySize + 3, xSize % 2 + xSize / 2, ySize - 3);
            this.drawTexturedModalRect(xSize % 2 + xPos + xSize / 2, yPos + 3, 200 - xSize / 2, texPos + 20 - ySize + 3, xSize / 2, ySize - 3);
        } else if (ySize > 20) {
            int y = yPos + 17;
            while (y + 15 < yPos + ySize) {
                this.drawTexturedModalRect(xPos, y, 0, texPos + 2, xSize % 2 + xSize / 2, 15);
                this.drawTexturedModalRect(xSize % 2 + xPos + xSize / 2, y, 200 - xSize / 2, texPos + 2, xSize / 2, 15);
                y += 15;
            }
            this.drawTexturedModalRect(xPos, yPos + ySize - 15, 0, texPos + 5, xSize % 2 + xSize / 2, 15);
            this.drawTexturedModalRect(xSize % 2 + xPos + xSize / 2, yPos + ySize - 15, 200 - xSize / 2, texPos + 5, xSize / 2, 15);
        }
    }

    public void drawTiledTextureRectWithTrim(int xPos, int yPos, int xSize, int ySize, int topTrim, int leftTrim, int bottomTrim, int rightTrim, int texU, int texV, int texWidth, int texHeight) {
        int trimWidth = texWidth - leftTrim - rightTrim;
        int trimHeight = texHeight - topTrim - bottomTrim;
        if (xSize <= texWidth) {
            trimWidth = Math.min(trimWidth, xSize - rightTrim);
        }
        if (xSize <= 0 || ySize <= 0 || trimWidth <= 0 || trimHeight <= 0) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int x = 0; x < xSize; x += trimWidth) {
            int rWidth = Math.min(xSize - x, trimWidth);
            int trimU = x == 0 ? texU : (x + trimWidth <= xSize ? texU + leftTrim : texU + (texWidth - (xSize - x)));
            this.bufferTexturedModalRect(buffer, xPos + x, yPos, trimU, texV, rWidth, topTrim);
            this.bufferTexturedModalRect(buffer, xPos + x, yPos + ySize - bottomTrim, trimU, texV + texHeight - bottomTrim, rWidth, bottomTrim);
            rWidth = Math.min(xSize - x - leftTrim - rightTrim, trimWidth);
            for (int y = 0; y < ySize; y += trimHeight) {
                int trimV;
                int rHeight = Math.min(ySize - y - topTrim - bottomTrim, trimHeight);
                int n = trimV = y + texHeight <= ySize ? texV + topTrim : texV + (texHeight - (ySize - y));
                if (x == 0) {
                    this.bufferTexturedModalRect(buffer, xPos, yPos + y + topTrim, texU, trimV, leftTrim, rHeight);
                    this.bufferTexturedModalRect(buffer, xPos + xSize - rightTrim, yPos + y + topTrim, trimU + texWidth - rightTrim, trimV, rightTrim, rHeight);
                }
                this.bufferTexturedModalRect(buffer, xPos + x + leftTrim, yPos + y + topTrim, texU + leftTrim, texV + topTrim, rWidth, rHeight);
            }
        }
        tessellator.func_78381_a();
    }

    private void bufferTexturedModalRect(BufferBuilder buffer, int x, int y, int textureX, int textureY, int width, int height) {
        double zLevel = this.getRenderZLevel();
        buffer.func_181662_b((double)x, (double)(y + height), zLevel).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, zLevel).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
    }

    public int changeShade(int colour, double shade) {
        double r = (double)(colour >> 16 & 0xFF) / 255.0;
        double g = (double)(colour >> 8 & 0xFF) / 255.0;
        double b = (double)(colour & 0xFF) / 255.0;
        double a = (double)(colour >> 24 & 0xFF) / 255.0;
        this.colourRatio.set(r, g, b);
        if (this.colourRatio.magSquared() == 0.0) {
            this.colourRatio.set(1.0);
        }
        this.colourRatio.normalize();
        r = MathHelper.clip((double)(r + this.colourRatio.x * shade), (double)0.0, (double)1.0);
        g = MathHelper.clip((double)(g + this.colourRatio.y * shade), (double)0.0, (double)1.0);
        b = MathHelper.clip((double)(b + this.colourRatio.z * shade), (double)0.0, (double)1.0);
        return ((int)(a * 255.0) & 0xFF) << 24 | ((int)(r * 255.0) & 0xFF) << 16 | ((int)(g * 255.0) & 0xFF) << 8 | (int)(b * 255.0) & 0xFF;
    }

    public E setHoverTextEnabled(boolean enableHoverText) {
        this.drawHoverText = enableHoverText;
        return (E)this;
    }

    public boolean isHoverTextEnabled() {
        return this.drawHoverText;
    }

    public E setHoverTextDelay(int hoverTextDelay) {
        this.hoverTextDelay = hoverTextDelay;
        return (E)this;
    }

    public E setHoverTextList(HoverTextSupplier<List<String>, E> hoverText) {
        this.hoverText = hoverText;
        this.setHoverTextEnabled(true);
        return (E)this;
    }

    public E setHoverTextArray(HoverTextSupplier<String[], E> hoverText) {
        this.hoverText = hoverText;
        this.setHoverTextEnabled(true);
        return (E)this;
    }

    public E setHoverText(HoverTextSupplier<String, E> hoverText) {
        this.hoverText = hoverText;
        this.setHoverTextEnabled(true);
        return (E)this;
    }

    public E setHoverTextFunc(Function1<E, String> hoverText) {
        this.hoverText = arg_0 -> hoverText.apply(arg_0);
        this.setHoverTextEnabled(true);
        return (E)this;
    }

    public E setHoverText(String singleLine) {
        this.setHoverText((E element) -> singleLine);
        return (E)this;
    }

    public E setHoverText(String ... textLines) {
        this.setHoverTextArray(element -> textLines);
        return (E)this;
    }

    public E setHoverText(List<String> textLines) {
        this.setHoverTextList(element -> textLines);
        return (E)this;
    }

    public List<String> getHoverText() {
        return this.hoverText == null || !this.drawHoverText ? Collections.emptyList() : this.hoverText.getHoverText(this);
    }

    public int getHoverTime() {
        return this.hoverTime;
    }

    public MGuiElementBase<E> $plus$eq(MGuiElementBase<?> other) {
        this.addChild(other);
        return this;
    }

    public static interface IDrawCallback {
        public void call(Minecraft var1, int var2, int var3, float var4, boolean var5);

        public static void resetColour(Minecraft minecraft, int mouseX, int mouseY, float partialTicks, boolean mouseOver) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

