/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class VillagerUtils {
    public static final VillagerRegistry.VillagerProfession PROFESSION_FARMER = VillagerUtils.getProfession("minecraft:farmer");
    public static final int CAREER_ID_FARMER = 1;
    public static final int CAREER_ID_FISHERMAN = 2;
    public static final int CAREER_ID_SHEPHERD = 3;
    public static final int CAREER_ID_FLETCHER = 4;
    public static final VillagerRegistry.VillagerCareer CAREER_FLETCHER = PROFESSION_FARMER.getCareer(4);
    public static final VillagerRegistry.VillagerCareer CAREER_SHEPHERD = PROFESSION_FARMER.getCareer(3);
    public static final VillagerRegistry.VillagerCareer CAREER_FISHERMAN = PROFESSION_FARMER.getCareer(2);
    public static final VillagerRegistry.VillagerCareer CAREER_FARMER = PROFESSION_FARMER.getCareer(1);
    public static final VillagerRegistry.VillagerProfession PROFESSION_LIBRARIAN = VillagerUtils.getProfession("minecraft:librarian");
    public static final int CAREER_ID_LIBRARIAN = 1;
    public static final int CAREER_ID_CARTOGRAPHER = 2;
    public static final VillagerRegistry.VillagerCareer CAREER_LIBRARIAN = PROFESSION_LIBRARIAN.getCareer(1);
    public static final VillagerRegistry.VillagerCareer CAREER_CARTOGRAPHER = PROFESSION_LIBRARIAN.getCareer(2);
    public static final VillagerRegistry.VillagerProfession PROFESSION_PRIEST = VillagerUtils.getProfession("minecraft:priest");
    public static final int CAREER_ID_CLERIC = 1;
    public static final VillagerRegistry.VillagerCareer CAREER_CLERIC = PROFESSION_PRIEST.getCareer(1);
    public static final VillagerRegistry.VillagerProfession PROFESSION_SMITH = VillagerUtils.getProfession("minecraft:smith");
    public static final int CAREER_ID_ARMOR_SMITH = 1;
    public static final int CAREER_ID_WEAPON_SMITH = 2;
    public static final int CAREER_ID_TOOL_SMITH = 3;
    public static final VillagerRegistry.VillagerCareer CAREER_TOOL_SMITH = PROFESSION_SMITH.getCareer(3);
    public static final VillagerRegistry.VillagerCareer CAREER_ARMOR_SMITH = PROFESSION_SMITH.getCareer(1);
    public static final VillagerRegistry.VillagerCareer CAREER_WEAPON_SMITH = PROFESSION_SMITH.getCareer(2);
    public static final VillagerRegistry.VillagerProfession PROFESSION_BUTCHER = VillagerUtils.getProfession("minecraft:butcher");
    public static final int CAREER_ID_BUTCHER = 1;
    public static final int CAREER_ID_LEATHER_WORKER = 2;
    public static final VillagerRegistry.VillagerCareer CAREER_BUTCHER = PROFESSION_BUTCHER.getCareer(1);
    public static final VillagerRegistry.VillagerCareer CAREER_LEATHER_WORKER = PROFESSION_BUTCHER.getCareer(2);
    public static final VillagerRegistry.VillagerProfession PROFESSION_NITWIT = VillagerUtils.getProfession("minecraft:nitwit");
    public static final int CAREER_ID_NITWIT = 1;
    public static final VillagerRegistry.VillagerCareer CAREER_NITWIT = PROFESSION_NITWIT.getCareer(1);

    public static void addVillagerTrade(VillagerRegistry.VillagerCareer career, int level, EntityVillager.ITradeList ... trades) {
        career.addTrade(level, trades);
    }

    @Nullable
    public static VillagerRegistry.VillagerProfession getProfession(String id) {
        return (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation(id));
    }

    public static boolean doesProfessionExist(String professionId) {
        return ForgeRegistries.VILLAGER_PROFESSIONS.containsKey(new ResourceLocation(professionId));
    }

    public static boolean hasCareer(VillagerRegistry.VillagerProfession profession, VillagerRegistry.VillagerCareer career) {
        return VillagerUtils.getCareers(profession).contains(career);
    }

    @Deprecated
    public static List<VillagerRegistry.VillagerCareer> getCareers(VillagerRegistry.VillagerProfession profession) {
        return (List)ReflectionHelper.getPrivateValue(VillagerRegistry.VillagerProfession.class, (Object)profession, (String[])new String[]{"careers"});
    }

    @Deprecated
    public static VillagerRegistry.VillagerProfession getProfession(VillagerRegistry.VillagerCareer career) {
        return (VillagerRegistry.VillagerProfession)ReflectionHelper.getPrivateValue(VillagerRegistry.VillagerCareer.class, (Object)career, (String[])new String[]{"profession"});
    }

    @Deprecated
    public static int getProfessionId(VillagerRegistry.VillagerCareer career) {
        return (Integer)ReflectionHelper.getPrivateValue(VillagerRegistry.VillagerCareer.class, (Object)career, (String[])new String[]{"id"});
    }

    @Deprecated
    public static List<List<EntityVillager.ITradeList>> getRawTradeList(VillagerRegistry.VillagerCareer career) {
        return (List)ReflectionHelper.getPrivateValue(VillagerRegistry.VillagerCareer.class, (Object)career, (String[])new String[]{"trades"});
    }
}

