/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.mixin.bewitchment.common.block.tile.entity;

import com.bewitchment.api.registry.Ritual;
import com.bewitchment.common.block.tile.entity.TileEntityGlyph;
import com.bewitchment.common.ritual.RitualDeluge;
import com.bewitchment.common.ritual.RitualHighMoon;
import com.bewitchment.common.ritual.RitualSandsOfTime;
import com.bewitchment.common.ritual.RitualSolarGlory;
import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.configuration.Config;
import io.github.lxgaming.sledgehammer.configuration.category.MixinCategory;
import io.github.lxgaming.sledgehammer.configuration.category.mixin.BewitchmentMixinCategory;
import io.github.lxgaming.sledgehammer.util.Locale;
import io.github.lxgaming.sledgehammer.util.text.adapter.LocaleAdapter;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TileEntityGlyph.class}, remap=false)
public abstract class TileEntityGlyphMixin {
    @Inject(method={"startRitual"}, at={@At(value="HEAD")}, cancellable=true)
    private void onStartRitual(EntityPlayer player, Ritual rit, CallbackInfo callbackInfo) {
        BewitchmentMixinCategory mixinCategory = Sledgehammer.getInstance().getConfig().map(Config::getMixinCategory).map(MixinCategory::getBewitchmentMixinCategory).orElse(null);
        if (mixinCategory == null) {
            Sledgehammer.getInstance().getLogger().error("BewitchmentMixinCategory is unavailable");
            return;
        }
        if (rit instanceof RitualDeluge) {
            if (mixinCategory.isDisableRitualDeluge()) {
                callbackInfo.cancel();
                LocaleAdapter.sendMessage(player, Locale.MESSAGE_DISABLED, "Ritual of the Deluge");
            }
            return;
        }
        if (rit instanceof RitualHighMoon) {
            if (mixinCategory.isDisableRitualHighMoon()) {
                callbackInfo.cancel();
                LocaleAdapter.sendMessage(player, Locale.MESSAGE_DISABLED, "Ritual of the High Moon");
            }
            return;
        }
        if (rit instanceof RitualSandsOfTime) {
            if (mixinCategory.isDisableRitualSandsOfTime()) {
                callbackInfo.cancel();
                LocaleAdapter.sendMessage(player, Locale.MESSAGE_DISABLED, "Ritual of the Sands of Time");
            }
            return;
        }
        if (rit instanceof RitualSolarGlory) {
            if (mixinCategory.isDisableRitualSolarGlory()) {
                callbackInfo.cancel();
                LocaleAdapter.sendMessage(player, Locale.MESSAGE_DISABLED, "Ritual of Solar Glory");
            }
            return;
        }
    }
}

