/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.configurate.objectmapping;

import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.NonNull;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.ObjectMapper;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.ObjectMappingException;

class GuiceObjectMapper<T>
extends ObjectMapper<T> {
    private final Injector injector;
    private final Key<T> typeKey;

    protected GuiceObjectMapper(@NonNull Injector injector, @NonNull Class<T> clazz) throws ObjectMappingException {
        super(clazz);
        this.injector = injector;
        this.typeKey = Key.get(clazz);
    }

    @Override
    public boolean canCreateInstances() {
        try {
            this.injector.getProvider(this.typeKey);
            return true;
        }
        catch (ConfigurationException ex) {
            return false;
        }
    }

    @Override
    protected T constructObject() throws ObjectMappingException {
        return (T)this.injector.getInstance(this.typeKey);
    }
}

