/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.emoji;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.teamfruit.emojicord.emoji.EmojiText;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class EmojiContext {
    public static final char EMOJI_REPLACE_CHARACTOR = '\u0000';
    public final String text;
    public final Map<Integer, EmojiText.EmojiTextElement> emojis;

    public EmojiContext(String text, Map<Integer, EmojiText.EmojiTextElement> emojis) {
        this.text = text;
        this.emojis = emojis;
    }

    public static class EmojiContextCache {
        public static final long LIFETIME_SEC = 5L;
        public static final EmojiContextCache instance = new EmojiContextCache();
        private final LoadingCache<Pair<String, EnumSet<EmojiContextAttribute>>, EmojiContext> EMOJI_TEXT_MAP = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Pair<String, EnumSet<EmojiContextAttribute>>, EmojiContext>(){

            public EmojiContext load(Pair<String, EnumSet<EmojiContextAttribute>> entry) throws Exception {
                return EmojiContextLoader.getEmojiFormattedString((String)entry.getLeft(), (EnumSet)entry.getRight());
            }
        });

        private EmojiContextCache() {
        }

        @Nonnull
        public EmojiContext getContext(String text, EnumSet<EmojiContextAttribute> attributes) {
            return (EmojiContext)this.EMOJI_TEXT_MAP.getUnchecked((Object)Pair.of((Object)text, attributes));
        }
    }

    public static class EmojiContextLoader {
        public static EmojiContext getEmojiFormattedString(String text, EnumSet<EmojiContextAttribute> attributes) {
            if (!StringUtils.isEmpty((CharSequence)text)) {
                EnumSet<EmojiText.ParseFlag> flags = EnumSet.of(EmojiText.ParseFlag.ESCAPE, EmojiText.ParseFlag.ENCODE, EmojiText.ParseFlag.ENCODE_ALIAS, EmojiText.ParseFlag.PARSE);
                if (attributes.contains((Object)EmojiContextAttribute.CHAT_MESSAGE) || attributes.contains((Object)EmojiContextAttribute.CHAT_INPUT)) {
                    flags.add(EmojiText.ParseFlag.ENCODE_UTF);
                }
                EmojiText emojiText = EmojiText.create(text, flags);
                EmojiContext context = emojiText.getEmojiContext();
                return context;
            }
            return new EmojiContext("", Maps.newHashMap());
        }
    }

    public static enum EmojiContextAttribute {
        CHAT_INPUT,
        CHAT_MESSAGE;

    }
}

