/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.tinkers.materials;

import com.jozufozu.yoyos.tinkers.materials.AxleMaterialStats;
import com.jozufozu.yoyos.tinkers.materials.BodyMaterialStats;
import com.jozufozu.yoyos.tinkers.materials.CordMaterialStats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;

public class YoyoNBT
extends ToolNBT {
    public static final String LOC_Duration = "stat.yoyo.duration.name";
    public static final String LOC_Suffix = "stat.yoyo.duration.suffix";
    public static final String LOC_Infinite = "stat.yoyo.infinite.name";
    public static final String CHORD_LENGTH = "ChordLength";
    public static final String DURATION = "Duration";
    public static final String WEIGHT = "Weight";
    public float weight;
    public float chordLength;
    public int duration = 100;
    private float friction;
    private float leastFriction = -50.0f;

    private void setLeastFriction(float leastFriction) {
        if (this.leastFriction == -50.0f) {
            this.leastFriction = leastFriction;
        }
        this.leastFriction = Math.min(leastFriction, this.leastFriction);
    }

    public YoyoNBT() {
    }

    public YoyoNBT(NBTTagCompound tag) {
        this.read(tag);
    }

    public YoyoNBT side(BodyMaterialStats ... sides) {
        for (BodyMaterialStats stat : sides) {
            this.attack += stat.attack;
            this.durability += stat.durability;
            this.weight += stat.weight;
        }
        this.attack /= (float)sides.length;
        return this;
    }

    public YoyoNBT core(AxleMaterialStats ... cores) {
        for (AxleMaterialStats core : cores) {
            this.friction += core.friction;
            this.setLeastFriction(core.friction);
            this.durability = (int)((float)this.durability * core.modifier);
        }
        return this;
    }

    public YoyoNBT chord(CordMaterialStats ... chords) {
        for (CordMaterialStats chord : chords) {
            this.chordLength += chord.length;
            this.friction += chord.friction;
            this.setLeastFriction(chord.friction);
        }
        this.duration = this.leastFriction <= 0.0f ? -1 : (int)((float)this.duration / this.friction);
        this.chordLength = Math.min(Math.max(this.chordLength, 2.0f), 32.0f);
        return this;
    }

    public void read(NBTTagCompound tag) {
        super.read(tag);
        this.weight = tag.func_74760_g(WEIGHT);
        this.chordLength = tag.func_74760_g(CHORD_LENGTH);
        this.duration = tag.func_74762_e(DURATION);
    }

    public void write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74776_a(WEIGHT, this.weight);
        tag.func_74776_a(CHORD_LENGTH, this.chordLength);
        tag.func_74768_a(DURATION, this.duration);
    }

    public static YoyoNBT from(ItemStack itemStack) {
        return new YoyoNBT(TagUtil.getToolTag((ItemStack)itemStack));
    }
}

