/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.tinkers;

import com.google.common.collect.Lists;
import com.jozufozu.yoyos.Yoyos;
import com.jozufozu.yoyos.common.ModConfig;
import com.jozufozu.yoyos.tinkers.ConfigMaterials;
import com.jozufozu.yoyos.tinkers.ItemYoyoBook;
import com.jozufozu.yoyos.tinkers.TinkersClientProxy;
import com.jozufozu.yoyos.tinkers.TinkersProxy;
import com.jozufozu.yoyos.tinkers.YoyoCore;
import com.jozufozu.yoyos.tinkers.materials.AxleMaterialStats;
import com.jozufozu.yoyos.tinkers.materials.BodyMaterialStats;
import com.jozufozu.yoyos.tinkers.materials.CordMaterialStats;
import com.jozufozu.yoyos.tinkers.modifiers.ModCollecting;
import com.jozufozu.yoyos.tinkers.modifiers.ModExtension;
import com.jozufozu.yoyos.tinkers.modifiers.ModFarming;
import com.jozufozu.yoyos.tinkers.modifiers.ModFloating;
import com.jozufozu.yoyos.tinkers.modifiers.ModGardening;
import com.jozufozu.yoyos.tinkers.modifiers.ModGluey;
import com.jozufozu.yoyos.tinkers.modifiers.ModLubricated;
import com.jozufozu.yoyos.tinkers.traits.TraitSticky;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.MaterialEvent;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;

public class TinkersYoyos {
    public static List<Item> modItems = Lists.newArrayList();
    static List<ToolPart> toolParts = Lists.newArrayList();
    private static List<Pair<Item, ToolPart>> toolPartPatterns = Lists.newArrayList();
    public static final HashMap<String, Set<IMaterialStats>> MASTER_STATS = new HashMap();
    public static Item BOOK;
    public static ToolPart YOYO_AXLE;
    public static ToolPart YOYO_BODY;
    public static ToolPart YOYO_CORD;
    public static ToolCore YOYO;
    public static Modifier EXTENSION;
    public static Modifier FLOATING;
    public static Modifier LUBRICATED;
    public static Modifier GARDENING;
    public static Modifier FARMING;
    public static Modifier GLUEY;
    public static Modifier COLLECTING;
    public static AbstractTrait STICKY;
    public static TinkersProxy proxy;

    @SubscribeEvent
    public static void onRegistryRegister(RegistryEvent.Register<Item> event) {
        Material.UNKNOWN.addStats((IMaterialStats)new BodyMaterialStats(1.0f, 2.0f, 400));
        Material.UNKNOWN.addStats((IMaterialStats)new AxleMaterialStats(0.5f, 1.0f));
        Material.UNKNOWN.addStats((IMaterialStats)new CordMaterialStats(0.2f, 5.0f));
        ConfigMaterials.load();
        Iterator<Map.Entry<String, Set<IMaterialStats>>> iterator = MASTER_STATS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Set<IMaterialStats>> entry = iterator.next();
            Material material = TinkerRegistry.getMaterial((String)entry.getKey());
            if (material == Material.UNKNOWN) continue;
            for (IMaterialStats stat : entry.getValue()) {
                TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)stat);
            }
            iterator.remove();
        }
        TinkerMaterials.slime.addTrait((ITrait)STICKY, "body");
        TinkerMaterials.blueslime.addTrait((ITrait)STICKY, "body");
        TinkerMaterials.magmaslime.addTrait((ITrait)STICKY, "body");
        TinkerMaterials.knightslime.addTrait((ITrait)STICKY, "body");
        TinkersYoyos.registerToolParts();
        TinkersYoyos.registerTools();
        BOOK = TinkersYoyos.registerItem(new ItemYoyoBook(), "book");
        for (Pair<Item, ToolPart> toolPartPattern : toolPartPatterns) {
            TinkersYoyos.registerStencil((Item)toolPartPattern.getLeft(), (ToolPart)toolPartPattern.getRight());
        }
        EXTENSION = new ModExtension();
        EXTENSION.addItem("string");
        EXTENSION.addItem(new ItemStack(Blocks.field_150325_L), 1, 4);
        EXTENSION.addItem(Yoyos.CORD, 1, 8);
        FLOATING = new ModFloating(3);
        FLOATING.addItem(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.PUFFERFISH.func_150976_a()), 1, 1);
        LUBRICATED = new ModLubricated(5);
        LUBRICATED.addItem(new ItemStack(Items.field_151100_aR, 1, 0), 1, 1);
        GARDENING = new ModGardening();
        GARDENING.addItem((Item)Items.field_151097_aZ);
        FARMING = new ModFarming();
        FARMING.addItem(Items.field_151012_L);
        COLLECTING = new ModCollecting();
        COLLECTING.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{new ItemStack((Block)Blocks.field_150438_bZ), new ItemStack((Block)Blocks.field_150486_ae)}));
        GLUEY = new ModGluey();
        GLUEY.addItem("slimeball", 2, 1);
        for (Item item : modItems) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public static void addMaterialStats(MaterialEvent.MaterialRegisterEvent event) {
        Set<IMaterialStats> stats = MASTER_STATS.get(event.material.identifier);
        if (stats == null) {
            return;
        }
        for (IMaterialStats stat : stats) {
            TinkerRegistry.addMaterialStats((Material)event.material, (IMaterialStats)stat);
        }
        MASTER_STATS.remove(event.material.identifier);
    }

    public static void preInit(FMLPreInitializationEvent event) {
        proxy = Yoyos.proxy.runningOnClient() ? new TinkersClientProxy() : new TinkersProxy();
        MinecraftForge.EVENT_BUS.register(TinkersYoyos.class);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
    }

    public static void init(FMLInitializationEvent event) {
        TinkersYoyos.registerToolBuilding();
        proxy.init(event);
    }

    public static void postInit(FMLPostInitializationEvent event) {
        MASTER_STATS.clear();
        for (Material material : TinkerRegistry.getAllMaterials()) {
            for (ITrait trait : material.getAllTraitsForStats("head")) {
                material.addTrait(trait, "body");
            }
            for (ITrait trait : material.getAllTraitsForStats("handle")) {
                material.addTrait(trait, "axle");
            }
        }
    }

    private static void registerToolParts() {
        YOYO_AXLE = TinkersYoyos.registerToolPart(new ToolPart(288), "yoyo_axle");
        YOYO_BODY = TinkersYoyos.registerToolPart(new ToolPart(576), "yoyo_body");
        YOYO_CORD = TinkersYoyos.registerToolPart(new ToolPart(432), "yoyo_cord");
    }

    private static void registerTools() {
        YOYO = (ToolCore)TinkersYoyos.registerItem(new YoyoCore(), "yoyo");
    }

    private static void registerToolBuilding() {
        if (ModConfig.stationCrafting) {
            TinkerRegistry.registerToolStationCrafting((ToolCore)YOYO);
        }
        TinkerRegistry.registerToolForgeCrafting((ToolCore)YOYO);
    }

    private static ToolPart registerToolPart(ToolPart part, String name) {
        ToolPart ret = TinkersYoyos.registerItem(part, name);
        toolPartPatterns.add((Pair<Item, ToolPart>)Pair.of((Object)TinkerTools.pattern, (Object)ret));
        toolParts.add(ret);
        return ret;
    }

    private static void registerStencil(Item pattern, ToolPart toolPart) {
        for (ToolCore toolCore : TinkerRegistry.getTools()) {
            for (PartMaterialType partMaterialType : toolCore.getRequiredComponents()) {
                if (!partMaterialType.getPossibleParts().contains(toolPart)) continue;
                ItemStack stencil = new ItemStack(pattern);
                Pattern.setTagForPart((ItemStack)stencil, (Item)toolPart);
                TinkerRegistry.registerStencilTableCrafting((ItemStack)stencil);
                return;
            }
        }
    }

    private static <T extends Item> T registerItem(T item, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Item: %s", name));
        }
        item.func_77655_b(String.format("%s.%s", "yoyos", name));
        item.setRegistryName(new ResourceLocation("yoyos", name));
        modItems.add(item);
        return item;
    }

    static {
        STICKY = new TraitSticky();
    }
}

