/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.common;

import com.jozufozu.yoyos.Yoyos;
import com.jozufozu.yoyos.common.ModConfig;
import com.jozufozu.yoyos.common.api.IYoyo;
import com.jozufozu.yoyos.network.MessageCollectedDrops;
import com.jozufozu.yoyos.network.YoyoNetwork;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber
public class EntityYoyo
extends Entity
implements IThrowableEntity {
    public static final HashMap<Entity, EntityYoyo> CASTERS = new HashMap();
    private static final DataParameter<ItemStack> YOYO_STACK = EntityDataManager.func_187226_a(EntityYoyo.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Byte> HAND = EntityDataManager.func_187226_a(EntityYoyo.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> RETRACTING = EntityDataManager.func_187226_a(EntityYoyo.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MAX_TIME = EntityDataManager.func_187226_a(EntityYoyo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> REMAINING_TIME = EntityDataManager.func_187226_a(EntityYoyo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> WEIGHT = EntityDataManager.func_187226_a(EntityYoyo.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> CURRENT_LENGTH = EntityDataManager.func_187226_a(EntityYoyo.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> MAX_LENGTH = EntityDataManager.func_187226_a(EntityYoyo.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> MAX_COLLECTED_DROPS = EntityDataManager.func_187226_a(EntityYoyo.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final int MAX_RETRACT_TIME = 40;
    public ArrayList<ItemStack> collectedDrops = new ArrayList();
    public int numCollectedDrops = 0;
    protected boolean needCollectedSync;
    protected EntityPlayer thrower;
    protected ItemStack yoyoStackLastTick = ItemStack.field_190927_a;
    protected IYoyo yoyo = null;
    protected int attackCool;
    protected int attackInterval;
    protected boolean shouldResetCool;
    protected boolean canCancelRetract = true;
    protected int retractionTimeout = 0;
    protected int lastSlot = -1;
    protected boolean shouldGetStats = true;
    protected boolean doesBlockInteraction = true;

    public EntityYoyo(World world) {
        super(world);
        this.func_189654_d(true);
        this.field_70158_ak = true;
        this.field_70130_N = 0.25f;
        this.field_70131_O = 0.25f;
    }

    public EntityYoyo(World world, EntityPlayer player, EnumHand hand) {
        this(world);
        this.thrower = player;
        CASTERS.put((Entity)player, this);
        this.setHand(hand);
        Vec3d handPos = this.getPlayerHandPos(1.0f);
        this.func_70107_b(handPos.field_72450_a, handPos.field_72448_b, handPos.field_72449_c);
        if (!world.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty()) {
            this.func_70107_b(player.field_70165_t, player.field_70163_u + (double)player.field_70131_O * 0.85, player.field_70161_v);
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(YOYO_STACK, (Object)ItemStack.field_190927_a);
        this.func_184212_Q().func_187214_a(HAND, (Object)((byte)EnumHand.MAIN_HAND.ordinal()));
        this.func_184212_Q().func_187214_a(RETRACTING, (Object)false);
        this.func_184212_Q().func_187214_a(MAX_TIME, (Object)-1);
        this.func_184212_Q().func_187214_a(REMAINING_TIME, (Object)-1);
        this.func_184212_Q().func_187214_a(WEIGHT, (Object)Float.valueOf(1.0f));
        this.func_184212_Q().func_187214_a(CURRENT_LENGTH, (Object)Float.valueOf(1.0f));
        this.func_184212_Q().func_187214_a(MAX_LENGTH, (Object)Float.valueOf(1.0f));
        this.func_184212_Q().func_187214_a(MAX_COLLECTED_DROPS, (Object)0);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDrops(LivingDropsEvent event) {
        DamageSource source = event.getSource();
        Entity killer = source.func_76346_g();
        if (!(killer instanceof EntityPlayer) || killer.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)killer;
        EntityYoyo yoyo = CASTERS.get(player);
        if (yoyo == null || !yoyo.isCollecting()) {
            return;
        }
        event.getDrops().forEach(yoyo::collectDrop);
        event.setCanceled(true);
    }

    @Nullable
    public IYoyo getYoyo() {
        return this.yoyo;
    }

    public Entity getThrower() {
        return this.thrower;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityPlayer && !(entity instanceof FakePlayer)) {
            this.thrower = (EntityPlayer)entity;
            CASTERS.put(entity, this);
        }
    }

    public ItemStack getYoyoStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(YOYO_STACK);
    }

    public void setYoyoStack(ItemStack stack) {
        this.func_184212_Q().func_187227_b(YOYO_STACK, (Object)stack);
        this.func_184212_Q().func_187217_b(YOYO_STACK);
    }

    public EnumHand getHand() {
        return EnumHand.values()[(Byte)this.func_184212_Q().func_187225_a(HAND)];
    }

    public void setHand(EnumHand hand) {
        this.func_184212_Q().func_187227_b(HAND, (Object)((byte)hand.ordinal()));
        this.func_184212_Q().func_187217_b(HAND);
    }

    public boolean isRetracting() {
        return (Boolean)this.func_184212_Q().func_187225_a(RETRACTING);
    }

    public void setRetracting(boolean retracting) {
        if (this.canCancelRetract || !this.isRetracting()) {
            this.func_184212_Q().func_187227_b(RETRACTING, (Object)retracting);
            this.func_184212_Q().func_187217_b(RETRACTING);
        }
    }

    public void forceRetract() {
        this.setRetracting(true);
        this.canCancelRetract = false;
    }

    public int getMaxTime() {
        return (Integer)this.func_184212_Q().func_187225_a(MAX_TIME);
    }

    public void setMaxTime(int duration) {
        this.func_184212_Q().func_187227_b(MAX_TIME, (Object)duration);
        this.func_184212_Q().func_187217_b(MAX_TIME);
    }

    public int getRemainingTime() {
        return (Integer)this.func_184212_Q().func_187225_a(REMAINING_TIME);
    }

    public void setRemainingTime(int duration) {
        this.func_184212_Q().func_187227_b(REMAINING_TIME, (Object)duration);
        this.func_184212_Q().func_187217_b(REMAINING_TIME);
    }

    public int decrementRemainingTime() {
        return this.decrementRemainingTime(1);
    }

    public int decrementRemainingTime(int amount) {
        int out = this.getRemainingTime() - amount;
        this.setRemainingTime(out);
        return out;
    }

    public float getWeight() {
        return ((Float)this.func_184212_Q().func_187225_a(WEIGHT)).floatValue();
    }

    public void setWeight(float weight) {
        this.func_184212_Q().func_187227_b(WEIGHT, (Object)Float.valueOf(weight));
        this.func_184212_Q().func_187217_b(WEIGHT);
    }

    public float getCurrentLength() {
        return ((Float)this.func_184212_Q().func_187225_a(CURRENT_LENGTH)).floatValue();
    }

    public void setCurrentLength(float length) {
        this.func_184212_Q().func_187227_b(CURRENT_LENGTH, (Object)Float.valueOf(length));
        this.func_184212_Q().func_187217_b(CURRENT_LENGTH);
    }

    public float getMaxLength() {
        return ((Float)this.func_184212_Q().func_187225_a(MAX_LENGTH)).floatValue();
    }

    public void setMaxLength(float length) {
        this.func_184212_Q().func_187227_b(MAX_LENGTH, (Object)Float.valueOf(length));
        this.func_184212_Q().func_187217_b(MAX_LENGTH);
    }

    public boolean doesBlockInteraction() {
        return this.doesBlockInteraction;
    }

    public void setInteractsWithBlocks(boolean blockInteraction) {
        this.doesBlockInteraction = blockInteraction;
    }

    public int getMaxCollectedDrops() {
        return (Integer)this.func_184212_Q().func_187225_a(MAX_COLLECTED_DROPS);
    }

    public void setMaxCollectedDrops(int numCollectedDrops) {
        this.func_184212_Q().func_187227_b(MAX_COLLECTED_DROPS, (Object)numCollectedDrops);
        this.func_184212_Q().func_187217_b(MAX_COLLECTED_DROPS);
    }

    public boolean isCollecting() {
        return this.getMaxCollectedDrops() > 0;
    }

    public boolean canAttack() {
        return this.attackCool >= this.attackInterval;
    }

    public void resetAttackCooldown() {
        this.shouldResetCool = true;
    }

    public Vec3d getPlayerHandPos(float partialTicks) {
        if (this.thrower == null) {
            return new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        float yaw = this.thrower.field_70177_z;
        float pitch = this.thrower.field_70125_A;
        double posX = this.thrower.field_70165_t;
        double posY = this.thrower.field_70163_u;
        double posZ = this.thrower.field_70161_v;
        if (partialTicks != 1.0f) {
            yaw = (float)EntityYoyo.interpolateValue(this.thrower.field_70126_B, this.thrower.field_70177_z, partialTicks);
            pitch = (float)EntityYoyo.interpolateValue(this.thrower.field_70127_C, this.thrower.field_70125_A, partialTicks);
            posX = EntityYoyo.interpolateValue(this.thrower.field_70169_q, this.thrower.field_70165_t, partialTicks);
            posY = EntityYoyo.interpolateValue(this.thrower.field_70167_r, this.thrower.field_70163_u, partialTicks);
            posZ = EntityYoyo.interpolateValue(this.thrower.field_70166_s, this.thrower.field_70161_v, partialTicks);
        }
        double throwerLookOffsetX = Math.cos((double)yaw * 0.01745329238474369);
        double throwerLookOffsetZ = Math.sin((double)yaw * 0.01745329238474369);
        double throwerLookOffsetY = Math.sin((double)pitch * 0.01745329238474369);
        double throwerLookWidth = Math.cos((double)pitch * 0.01745329238474369);
        float side = -1.0f;
        if (this.thrower.func_184591_cq() == EnumHandSide.RIGHT == (this.getHand() == EnumHand.MAIN_HAND)) {
            side = 1.0f;
        }
        return new Vec3d(posX - throwerLookOffsetX * (double)side * 0.4 - throwerLookOffsetZ * 0.5 * throwerLookWidth, posY + (double)this.thrower.eyeHeight * 0.85 - throwerLookOffsetY * 0.5 - 0.25, posZ - throwerLookOffsetZ * (double)side * 0.4 + throwerLookOffsetX * 0.5 * throwerLookWidth);
    }

    public float getRotation(int age, float partialTicks) {
        int maxTime = this.getMaxTime();
        float ageInTicks = maxTime < 0 ? (float)age + partialTicks : (float)(maxTime - this.getRemainingTime()) + partialTicks;
        float multiplier = 35.0f;
        if (maxTime >= 0) {
            multiplier *= 2.0f - ageInTicks / (float)maxTime;
        }
        return ageInTicks * multiplier;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.thrower != null && !this.thrower.field_70128_L) {
            this.yoyo = this.checkAndGetYoyoObject();
            if (this.yoyo == null) {
                return;
            }
            if (this.getMaxTime() >= 0 && this.decrementRemainingTime() < 0) {
                this.forceRetract();
            }
            this.updateMotion();
            this.moveAndCollide();
            this.yoyo.onUpdate(this.getYoyoStack(), this);
            if (!this.field_70170_p.field_72995_K && this.doesBlockInteraction()) {
                this.worldInteraction();
            }
            if (this.isCollecting()) {
                this.updateCapturedDrops();
            }
            if (ModConfig.yoyoSwing) {
                this.handlePlayerPulling();
            }
            this.resetOrIncrementAttackCooldown();
        } else {
            this.func_70106_y();
        }
    }

    @Nullable
    protected IYoyo checkAndGetYoyoObject() {
        EnumHand hand = this.getHand();
        ItemStack yoyoStack = this.thrower.func_184586_b(hand);
        this.setYoyoStack(yoyoStack);
        int currentSlot = hand == EnumHand.MAIN_HAND ? this.thrower.field_71071_by.field_70461_c : -2;
        ItemStack otherHand = this.thrower.func_184586_b(hand == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
        if (!CASTERS.containsKey(this.thrower) || !(yoyoStack.func_77973_b() instanceof IYoyo) || this.field_70173_aa > 1 && (this.lastSlot != -1 && this.lastSlot != currentSlot || otherHand == this.yoyoStackLastTick)) {
            this.func_70106_y();
            return null;
        }
        this.yoyoStackLastTick = yoyoStack;
        if (yoyoStack.func_77958_k() < yoyoStack.func_77952_i() && yoyoStack.func_77973_b() != Yoyos.CREATIVE_YOYO) {
            this.func_70106_y();
            return null;
        }
        if (!this.field_70170_p.field_72995_K && CASTERS.get(this.thrower) != this) {
            CASTERS.put((Entity)this.thrower, this);
        }
        IYoyo yoyo = (IYoyo)yoyoStack.func_77973_b();
        if (!this.field_70170_p.field_72995_K && this.shouldGetStats) {
            this.setMaxCollectedDrops(yoyo.getMaxCollectedDrops(yoyoStack));
            this.attackInterval = yoyo.getAttackInterval(yoyoStack);
            int duration = yoyo.getDuration(yoyoStack);
            this.setMaxTime(duration);
            this.setRemainingTime(duration);
            float maxLength = yoyo.getLength(yoyoStack);
            this.setCurrentLength(maxLength);
            this.setMaxLength(maxLength);
            this.setWeight(yoyo.getWeight(yoyoStack));
            this.setInteractsWithBlocks(yoyo.interactsWithBlocks(yoyoStack));
            this.shouldGetStats = false;
        }
        this.lastSlot = currentSlot;
        return yoyo;
    }

    protected void updateMotion() {
        Vec3d motion = this.getTarget().func_178786_a(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v).func_186678_a(Math.min((double)(1.0f / this.getWeight()), 1.0));
        this.field_70159_w = motion.field_72450_a;
        this.field_70181_x = motion.field_72448_b;
        this.field_70179_y = motion.field_72449_c;
        if (this.field_70171_ac) {
            float multiplier = this.yoyo.getWaterMovementModifier(this.getYoyoStack());
            this.field_70159_w *= (double)multiplier;
            this.field_70181_x *= (double)multiplier;
            this.field_70179_y *= (double)multiplier;
        }
        this.field_70122_E = true;
    }

    protected Vec3d getTarget() {
        if (this.isRetracting()) {
            Vec3d handPos = this.getPlayerHandPos(1.0f);
            double dX = this.field_70165_t - handPos.field_72450_a;
            double dY = this.field_70163_u - handPos.field_72448_b;
            double dZ = this.field_70161_v - handPos.field_72449_c;
            if (dX * dX + dY * dY + dZ * dZ < 0.8 || this.retractionTimeout++ >= 40) {
                this.func_70106_y();
            }
            return handPos;
        }
        Vec3d eyePos = new Vec3d(this.thrower.field_70165_t, this.thrower.field_70163_u + (double)this.thrower.eyeHeight, this.thrower.field_70161_v);
        Vec3d lookVec = this.thrower.func_70040_Z();
        double cordLength = this.getCurrentLength();
        Vec3d target = new Vec3d(eyePos.field_72450_a + lookVec.field_72450_a * cordLength, eyePos.field_72448_b + lookVec.field_72448_b * cordLength, eyePos.field_72449_c + lookVec.field_72449_c * cordLength);
        this.retractionTimeout = 0;
        RayTraceResult rayTraceResult = this.getTargetLook(eyePos, target);
        if (rayTraceResult != null) {
            target = rayTraceResult.field_72307_f;
        }
        return target;
    }

    public void moveAndCollide() {
        AxisAlignedBB yoyoBoundingBox = this.func_174813_aQ();
        AxisAlignedBB targetBoundingBox = yoyoBoundingBox.func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70145_X) {
            this.func_174826_a(targetBoundingBox);
            this.func_174829_m();
            return;
        }
        AxisAlignedBB union = targetBoundingBox.func_111270_a(yoyoBoundingBox);
        List collisionBoxes = this.field_70170_p.func_184144_a((Entity)this, union);
        List entities = this.field_70170_p.func_72839_b((Entity)this, union);
        int steps = 50;
        for (int step = 0; step < 50; ++step) {
            double dx = this.field_70159_w / 50.0;
            double dy = this.field_70181_x / 50.0;
            double dz = this.field_70179_y / 50.0;
            for (AxisAlignedBB box : collisionBoxes) {
                dx = box.func_72316_a(yoyoBoundingBox, dx);
                dy = box.func_72323_b(yoyoBoundingBox, dy);
                dz = box.func_72322_c(yoyoBoundingBox, dz);
            }
            yoyoBoundingBox = yoyoBoundingBox.func_72317_d(dx, dy, dz);
            for (AxisAlignedBB box : collisionBoxes) {
                if (!box.func_72326_a(yoyoBoundingBox)) continue;
                dx = box.func_72316_a(yoyoBoundingBox, dx);
                dy = box.func_72323_b(yoyoBoundingBox, dy);
                dz = box.func_72322_c(yoyoBoundingBox, dz);
                yoyoBoundingBox = yoyoBoundingBox.func_72317_d(-dx, -dy, -dz);
            }
            if (this.field_70170_p.field_72995_K) continue;
            ListIterator iterator = entities.listIterator();
            while (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                if (entity == this.thrower) {
                    iterator.remove();
                    continue;
                }
                if (!entity.func_174813_aQ().func_72326_a(yoyoBoundingBox)) continue;
                this.interactWithEntity(entity);
                iterator.remove();
            }
        }
        this.func_174826_a(yoyoBoundingBox);
        this.func_174829_m();
    }

    public void interactWithEntity(Entity entity) {
        this.yoyo.entityInteraction(this.getYoyoStack(), this.thrower, this.getHand(), this, entity);
    }

    protected void worldInteraction() {
        BlockPos pos = this.func_180425_c();
        AxisAlignedBB entityBox = this.func_174813_aQ().func_186662_g(0.1);
        for (BlockPos.MutableBlockPos checkPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 1, 1))) {
            IBlockState state = this.field_70170_p.func_180495_p((BlockPos)checkPos);
            Block block = state.func_177230_c();
            if (block == Blocks.field_150350_a || !state.func_185900_c((IBlockAccess)this.field_70170_p, (BlockPos)checkPos).func_186670_a((BlockPos)checkPos).func_72326_a(entityBox)) continue;
            this.yoyo.blockInteraction(this.getYoyoStack(), this.thrower, this.field_70170_p, (BlockPos)checkPos, state, block, this);
        }
    }

    public BlockPos func_180425_c() {
        return new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected void updateCapturedDrops() {
        if (!this.field_70170_p.field_72995_K && !this.collectedDrops.isEmpty() && this.needCollectedSync) {
            Iterator<ItemStack> iterator = this.collectedDrops.iterator();
            HashMap<Item, ItemStack> existing = new HashMap<Item, ItemStack>();
            while (iterator.hasNext()) {
                ItemStack collectedDrop = iterator.next();
                if (collectedDrop.func_190926_b() || collectedDrop.func_77978_p() != null) continue;
                Item item = collectedDrop.func_77973_b();
                ItemStack master = (ItemStack)existing.get(item);
                if (master != null && collectedDrop.func_77969_a(master)) {
                    master.func_190917_f(collectedDrop.func_190916_E());
                    iterator.remove();
                    continue;
                }
                existing.put(item, collectedDrop);
            }
            YoyoNetwork.INSTANCE.sendToAll((IMessage)new MessageCollectedDrops(this));
            this.needCollectedSync = false;
        }
    }

    public void createItemDropOrCollect(ItemStack drop, BlockPos pos) {
        ItemStack remaining = drop;
        if (this.isCollecting() && (remaining = this.collectDrop(drop)) == ItemStack.field_190927_a) {
            return;
        }
        float f = 0.7f;
        double d = (double)(this.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(this.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(this.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(this.field_70170_p, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, remaining);
        entityitem.func_174869_p();
        this.field_70170_p.func_72838_d((Entity)entityitem);
    }

    public ItemStack collectDrop(ItemStack stack) {
        if (!this.isCollecting()) {
            return stack;
        }
        int maxTake = this.getMaxCollectedDrops() - this.numCollectedDrops;
        ItemStack take = stack.func_77979_a(maxTake);
        this.collectedDrops.add(take);
        this.needCollectedSync = true;
        this.numCollectedDrops += take.func_190916_E();
        return stack;
    }

    public void collectDrop(@Nullable EntityItem drop) {
        if (drop == null) {
            return;
        }
        ItemStack stack = drop.func_92059_d();
        int countBefore = stack.func_190916_E();
        this.collectDrop(stack);
        if (countBefore == stack.func_190916_E()) {
            return;
        }
        drop.func_92058_a(stack);
        if (stack.func_190926_b()) {
            drop.func_174871_r();
            drop.func_70106_y();
        }
        this.field_70170_p.func_184148_a(null, drop.field_70165_t, drop.field_70163_u, drop.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.NEUTRAL, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
    }

    protected void handlePlayerPulling() {
        double dz;
        double distanceSqr;
        double dx = this.field_70165_t - this.thrower.field_70165_t;
        double dy = this.field_70163_u + (double)this.field_70131_O * 0.5 - (this.thrower.field_70163_u + (double)this.thrower.eyeHeight);
        float cordLength = this.getCurrentLength();
        if (dy < 0.0 && cordLength < this.thrower.eyeHeight) {
            dy += (double)this.thrower.eyeHeight * 1.2;
        }
        if ((distanceSqr = dx * dx + dy * dy + (dz = this.field_70161_v - this.thrower.field_70161_v) * dz) > (double)(cordLength * cordLength)) {
            double stretch = Math.sqrt(distanceSqr) - (double)cordLength;
            double scale = Math.min(0.04 * stretch * stretch, 0.4);
            this.thrower.func_70024_g(dx * scale, dy * scale, dz * scale);
            this.thrower.field_70143_R = 0.0f;
            if (this.isRetracting()) {
                this.func_70106_y();
            }
        }
    }

    protected void resetOrIncrementAttackCooldown() {
        if (this.shouldResetCool) {
            this.attackCool = 0;
            this.shouldResetCool = false;
        } else {
            ++this.attackCool;
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        CASTERS.remove(this.thrower, (Object)this);
        if (this.collectedDrops.isEmpty()) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.thrower != null) {
                for (ItemStack drop : this.collectedDrops) {
                    if (drop == null || drop.func_190926_b()) continue;
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)this.thrower, (ItemStack)drop);
                }
            } else {
                for (ItemStack drop : this.collectedDrops) {
                    if (drop == null || drop.func_190926_b()) continue;
                    while (drop.func_190916_E() > 0) {
                        ItemStack itemStack = drop.func_77979_a(drop.func_77976_d());
                        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v, itemStack);
                        entityitem.func_174869_p();
                        entityitem.field_70159_w = 0.0;
                        entityitem.field_70179_y = 0.0;
                        this.field_70170_p.func_72838_d((Entity)entityitem);
                    }
                }
            }
        }
        this.collectedDrops.clear();
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        this.collectedDrops.clear();
        NBTTagList list = compound.func_150295_c("collectedDrops", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            ItemStack stack = new ItemStack(nbt);
            stack.func_190920_e(nbt.func_74762_e("BigCount"));
            this.collectedDrops.add(stack);
        }
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        NBTTagList collected = new NBTTagList();
        for (ItemStack itemStack : this.collectedDrops) {
            NBTTagCompound nbt = itemStack.serializeNBT();
            nbt.func_74774_a("Count", (byte)1);
            nbt.func_74768_a("BigCount", itemStack.func_190916_E());
            collected.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("collectedDrops", (NBTBase)collected);
    }

    @Nullable
    public Team func_96124_cp() {
        return this.thrower == null ? null : this.thrower.func_96124_cp();
    }

    @Nullable
    protected RayTraceResult getTargetLook(Vec3d from, Vec3d to) {
        double distance = from.func_72438_d(to);
        RayTraceResult objectMouseOver = EntityYoyo.rayTraceBlocks(this.field_70170_p, from, to);
        boolean flag = false;
        double d1 = distance;
        if (distance > 3.0) {
            flag = true;
        }
        if (objectMouseOver != null) {
            d1 = objectMouseOver.field_72307_f.func_72438_d(from);
        }
        Vec3d vec3d1 = this.thrower.func_70676_i(1.0f);
        Entity pointedEntity = null;
        Vec3d vec3d3 = null;
        AxisAlignedBB expanded = this.thrower.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * distance, vec3d1.field_72448_b * distance, vec3d1.field_72449_c * distance).func_72321_a(1.0, 1.0, 1.0);
        List list = this.field_70170_p.func_175674_a((Entity)this.thrower, expanded, entity -> (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_175149_v()) && entity != null && entity.func_70067_L());
        double d2 = d1;
        for (Entity entity1 : list) {
            double d3;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            RayTraceResult raytraceresult = axisalignedbb.func_72327_a(from, to);
            if (axisalignedbb.func_72318_a(from)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                vec3d3 = raytraceresult == null ? from : raytraceresult.field_72307_f;
                d2 = 0.0;
                continue;
            }
            if (raytraceresult == null || !((d3 = from.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
            if (entity1.func_184208_bv() == this.thrower.func_184208_bv() && !this.thrower.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                vec3d3 = raytraceresult.field_72307_f;
                continue;
            }
            pointedEntity = entity1;
            vec3d3 = raytraceresult.field_72307_f;
            d2 = d3;
        }
        if (pointedEntity != null && flag) {
            pointedEntity = null;
            objectMouseOver = new RayTraceResult(RayTraceResult.Type.MISS, vec3d3, EnumFacing.UP, new BlockPos(vec3d3));
        }
        if (pointedEntity != null && objectMouseOver == null) {
            objectMouseOver = new RayTraceResult(pointedEntity, vec3d3);
        }
        return objectMouseOver;
    }

    protected static double interpolateValue(double start, double end, double pct) {
        return start + (end - start) * pct;
    }

    @Nullable
    protected static RayTraceResult rayTraceBlocks(World world, Vec3d start, Vec3d end) {
        if (!(Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c))) {
            if (!(Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c))) {
                RayTraceResult raytraceresult;
                int startZ;
                int startY;
                int endX = MathHelper.func_76128_c((double)end.field_72450_a);
                int endY = MathHelper.func_76128_c((double)end.field_72448_b);
                int endZ = MathHelper.func_76128_c((double)end.field_72449_c);
                int startX = MathHelper.func_76128_c((double)start.field_72450_a);
                BlockPos blockpos = new BlockPos(startX, startY = MathHelper.func_76128_c((double)start.field_72448_b), startZ = MathHelper.func_76128_c((double)start.field_72449_c));
                IBlockState iblockstate = world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if ((!(block instanceof BlockBush) || iblockstate.func_185890_d((IBlockAccess)world, blockpos) != Block.field_185506_k) && block.func_176209_a(iblockstate, false) && (raytraceresult = iblockstate.func_185910_a(world, blockpos, start, end)) != null) {
                    return raytraceresult;
                }
                RayTraceResult rayTraceResult2 = null;
                int steps = 200;
                while (steps-- >= 0) {
                    IBlockState state;
                    Block block1;
                    EnumFacing enumfacing;
                    if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
                        return null;
                    }
                    if (startX == endX && startY == endY && startZ == endZ) {
                        return rayTraceResult2;
                    }
                    boolean atMaxX = true;
                    boolean atMaxY = true;
                    boolean atMaxZ = true;
                    double currentX = 999.0;
                    double currentY = 999.0;
                    double currentZ = 999.0;
                    if (endX > startX) {
                        currentX = (double)startX + 1.0;
                    } else if (endX < startX) {
                        currentX = (double)startX + 0.0;
                    } else {
                        atMaxX = false;
                    }
                    if (endY > startY) {
                        currentY = (double)startY + 1.0;
                    } else if (endY < startY) {
                        currentY = (double)startY + 0.0;
                    } else {
                        atMaxY = false;
                    }
                    if (endZ > startZ) {
                        currentZ = (double)startZ + 1.0;
                    } else if (endZ < startZ) {
                        currentZ = (double)startZ + 0.0;
                    } else {
                        atMaxZ = false;
                    }
                    double x = 999.0;
                    double y = 999.0;
                    double z = 999.0;
                    double xDiff = end.field_72450_a - start.field_72450_a;
                    double yDiff = end.field_72448_b - start.field_72448_b;
                    double zDiff = end.field_72449_c - start.field_72449_c;
                    if (atMaxX) {
                        x = (currentX - start.field_72450_a) / xDiff;
                    }
                    if (atMaxY) {
                        y = (currentY - start.field_72448_b) / yDiff;
                    }
                    if (atMaxZ) {
                        z = (currentZ - start.field_72449_c) / zDiff;
                    }
                    if (x == -0.0) {
                        x = -1.0E-4;
                    }
                    if (y == -0.0) {
                        y = -1.0E-4;
                    }
                    if (z == -0.0) {
                        z = -1.0E-4;
                    }
                    if (x < y && x < z) {
                        enumfacing = endX > startX ? EnumFacing.WEST : EnumFacing.EAST;
                        start = new Vec3d(currentX, start.field_72448_b + yDiff * x, start.field_72449_c + zDiff * x);
                    } else if (y < z) {
                        enumfacing = endY > startY ? EnumFacing.DOWN : EnumFacing.UP;
                        start = new Vec3d(start.field_72450_a + xDiff * y, currentY, start.field_72449_c + zDiff * y);
                    } else {
                        enumfacing = endZ > startZ ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        start = new Vec3d(start.field_72450_a + xDiff * z, start.field_72448_b + yDiff * z, currentZ);
                    }
                    if ((block1 = (state = world.func_180495_p(blockpos = new BlockPos(startX = MathHelper.func_76128_c((double)start.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0), startY = MathHelper.func_76128_c((double)start.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0), startZ = MathHelper.func_76128_c((double)start.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0)))).func_177230_c()) instanceof BlockBush && state.func_185904_a() != Material.field_151567_E && state.func_185890_d((IBlockAccess)world, blockpos) == Block.field_185506_k) continue;
                    if (block1.func_176209_a(state, false)) {
                        RayTraceResult rayTraceResult = state.func_185910_a(world, blockpos, start, end);
                        if (rayTraceResult == null) continue;
                        return rayTraceResult;
                    }
                    rayTraceResult2 = new RayTraceResult(RayTraceResult.Type.MISS, start, enumfacing, blockpos);
                }
                return rayTraceResult2;
            }
            return null;
        }
        return null;
    }
}

