/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.xnet.XNet;
import mcjty.xnet.api.channels.IChannelSettings;
import mcjty.xnet.api.channels.IChannelType;
import mcjty.xnet.api.channels.IConnectorSettings;
import mcjty.xnet.api.channels.IControllerContext;
import mcjty.xnet.api.keys.ConsumerId;
import mcjty.xnet.api.keys.NetworkId;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.api.keys.SidedPos;
import mcjty.xnet.blocks.cables.ConnectorBlock;
import mcjty.xnet.blocks.cables.ConnectorTileEntity;
import mcjty.xnet.blocks.cables.NetCableSetup;
import mcjty.xnet.blocks.controller.ConnectedBlockInfo;
import mcjty.xnet.blocks.controller.KnownUnsidedBlocks;
import mcjty.xnet.blocks.controller.gui.GuiController;
import mcjty.xnet.clientinfo.ChannelClientInfo;
import mcjty.xnet.clientinfo.ConnectedBlockClientInfo;
import mcjty.xnet.clientinfo.ConnectorClientInfo;
import mcjty.xnet.clientinfo.ConnectorInfo;
import mcjty.xnet.config.ConfigSetup;
import mcjty.xnet.logic.ChannelInfo;
import mcjty.xnet.logic.LogicTools;
import mcjty.xnet.multiblock.BlobId;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.NetworkChecker;
import mcjty.xnet.multiblock.WirelessChannelKey;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.multiblock.XNetWirelessChannels;
import mcjty.xnet.network.PacketControllerError;
import mcjty.xnet.network.PacketJsonToClipboard;
import mcjty.xnet.network.XNetMessages;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public final class TileEntityController
extends GenericEnergyReceiverTileEntity
implements ITickable,
IControllerContext {
    public static final String CMD_GETCHANNELS = "getChannelInfo";
    public static final String CLIENTCMD_CHANNELSREADY = "channelsReady";
    public static final String CMD_GETCONNECTEDBLOCKS = "getConnectedBlocks";
    public static final String CLIENTCMD_CONNECTEDBLOCKSREADY = "connectedBlocksReady";
    public static final String CMD_CREATECONNECTOR = "controller.createConnector";
    public static final String CMD_REMOVECONNECTOR = "controller.removeConnector";
    public static final String CMD_UPDATECONNECTOR = "controller.updateConnector";
    public static final String CMD_CREATECHANNEL = "controller.createChannel";
    public static final String CMD_PASTECHANNEL = "controller.pasteChannel";
    public static final String CMD_COPYCHANNEL = "controller.copyChannel";
    public static final String CMD_PASTECONNECTOR = "controller.pasteConnector";
    public static final String CMD_COPYCONNECTOR = "controller.copyConnector";
    public static final String CMD_REMOVECHANNEL = "controller.removeChannel";
    public static final String CMD_UPDATECHANNEL = "controller.updateChannel";
    public static final Key<Integer> PARAM_INDEX = new Key("index", Type.INTEGER);
    public static final Key<String> PARAM_TYPE = new Key("type", Type.STRING);
    public static final Key<String> PARAM_JSON = new Key("json", Type.STRING);
    public static final Key<Integer> PARAM_CHANNEL = new Key("channel", Type.INTEGER);
    public static final Key<Integer> PARAM_SIDE = new Key("side", Type.INTEGER);
    public static final Key<BlockPos> PARAM_POS = new Key("pos", Type.BLOCKPOS);
    public static final PropertyBool ERROR = PropertyBool.func_177716_a((String)"error");
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        protected void setup() {
            this.layoutPlayerInventorySlots(91, 157);
        }
    };
    private NetworkId networkId;
    private final ChannelInfo[] channels = new ChannelInfo[8];
    private int colors = 0;
    private boolean error = false;
    private Map<SidedConsumer, IConnectorSettings>[] cachedConnectors = new Map[8];
    private Map<SidedConsumer, IConnectorSettings>[] cachedRoutedConnectors = new Map[8];
    private Map<WirelessChannelKey, Integer> wirelessVersions = new HashMap<WirelessChannelKey, Integer>();
    private NetworkChecker networkChecker = null;

    public TileEntityController() {
        super((long)ConfigSetup.controllerMaxRF.get(), (long)ConfigSetup.controllerRfPerTick.get());
        for (int i = 0; i < 8; ++i) {
            this.channels[i] = null;
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean oldError = this.error;
        super.onDataPacket(net, packet);
        if (this.func_145831_w().field_72995_K && oldError != this.error) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Nonnull
    public NetworkChecker getNetworkChecker() {
        if (this.networkChecker == null) {
            this.networkChecker = new NetworkChecker();
            this.networkChecker.add(this.networkId);
            WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
            LogicTools.routers(this.func_145831_w(), this.networkId).forEach(router -> {
                this.networkChecker.add(worldBlob.getNetworksAt(router.func_174877_v()));
                NetworkId routerNetwork = worldBlob.getNetworkAt(router.func_174877_v());
                if (routerNetwork != null) {
                    LogicTools.routers(this.func_145831_w(), routerNetwork).filter(r -> router != r).forEach(r -> LogicTools.connectors(this.func_145831_w(), r.func_174877_v()).forEach(connectorPos -> this.networkChecker.add(worldBlob.getNetworkAt((BlockPos)connectorPos))));
                }
            });
        }
        return this.networkChecker;
    }

    @Override
    public World getControllerWorld() {
        return this.func_145831_w();
    }

    @Override
    public NetworkId getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(NetworkId networkId) {
        if (networkId == null && this.networkId == null) {
            return;
        }
        if (networkId != null && networkId.equals(this.networkId)) {
            return;
        }
        this.networkChecker = null;
        this.networkId = networkId;
        this.markDirtyQuick();
    }

    public ChannelInfo[] getChannels() {
        return this.channels;
    }

    private void checkNetwork(WorldBlob worldBlob) {
        if (this.networkId != null && this.getNetworkChecker().isDirtyAndMarkClean(worldBlob)) {
            this.cleanCaches();
            return;
        }
        for (Map.Entry<WirelessChannelKey, Integer> entry : this.wirelessVersions.entrySet()) {
            XNetWirelessChannels channels = XNetWirelessChannels.getWirelessChannels(this.field_145850_b);
            XNetWirelessChannels.WirelessChannelInfo channel = channels.findChannel(entry.getKey());
            if (channel == null) {
                this.cleanCaches();
                return;
            }
            if (channel.getVersion() == entry.getValue().intValue()) continue;
            this.cleanCaches();
            return;
        }
    }

    private void cleanCaches() {
        for (int i = 0; i < 8; ++i) {
            if (this.channels[i] == null) continue;
            this.cleanCache(i);
        }
    }

    @Override
    public boolean matchColor(int colorMask) {
        return (this.colors & colorMask) == colorMask;
    }

    public boolean inError() {
        if (this.func_145831_w().field_72995_K) {
            return this.error;
        }
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        return worldBlob.getNetworksAt(this.func_174877_v()).size() > 1;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
            if (worldBlob.getNetworksAt(this.func_174877_v()).size() > 1) {
                this.markDirtyClient();
                return;
            }
            this.checkNetwork(worldBlob);
            if (!this.checkAndConsumeRF(ConfigSetup.controllerRFT.get())) {
                return;
            }
            boolean dirty = false;
            int newcolors = 0;
            for (int i = 0; i < 8; ++i) {
                if (this.channels[i] == null || !this.channels[i].isEnabled()) continue;
                if (this.checkAndConsumeRF(ConfigSetup.controllerChannelRFT.get())) {
                    this.channels[i].getChannelSettings().tick(i, this);
                }
                newcolors |= this.channels[i].getChannelSettings().getColors();
                dirty = true;
            }
            if (newcolors != this.colors) {
                dirty = true;
                this.colors = newcolors;
            }
            if (dirty) {
                this.markDirtyQuick();
            }
        }
    }

    @Override
    public boolean checkAndConsumeRF(int rft) {
        if (rft > 0) {
            if (this.getStoredPower() < (long)rft) {
                return false;
            }
            this.consumeEnergy(rft);
            this.markDirtyQuick();
        }
        return true;
    }

    private void networkDirty() {
        if (this.networkId != null) {
            XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w()).markNetworkDirty(this.networkId);
        }
    }

    private void cleanCache(int channel) {
        this.cachedConnectors[channel] = null;
        this.cachedRoutedConnectors[channel] = null;
        this.channels[channel].getChannelSettings().cleanCache();
    }

    @Override
    @Nonnull
    public Map<SidedConsumer, IConnectorSettings> getConnectors(int channel) {
        if (this.cachedConnectors[channel] == null) {
            WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
            this.cachedConnectors[channel] = new HashMap<SidedConsumer, IConnectorSettings>();
            for (Map.Entry<SidedConsumer, ConnectorInfo> entry : this.channels[channel].getConnectors().entrySet()) {
                SidedConsumer sidedConsumer = entry.getKey();
                BlockPos pos = this.findConsumerPosition(sidedConsumer.getConsumerId());
                if (pos == null || !worldBlob.getNetworksAt(pos).contains(this.getNetworkId())) continue;
                this.cachedConnectors[channel].put(sidedConsumer, entry.getValue().getConnectorSettings());
            }
        }
        return this.cachedConnectors[channel];
    }

    @Override
    @Nonnull
    public Map<SidedConsumer, IConnectorSettings> getRoutedConnectors(int channel) {
        if (this.cachedRoutedConnectors[channel] == null) {
            this.cachedRoutedConnectors[channel] = new HashMap<SidedConsumer, IConnectorSettings>();
            this.wirelessVersions.clear();
            if (!this.channels[channel].getChannelName().isEmpty()) {
                LogicTools.routers(this.func_145831_w(), this.networkId).forEach(router -> router.addRoutedConnectors(this.cachedRoutedConnectors[channel], this.func_174877_v(), channel, this.channels[channel].getType(), this.wirelessVersions));
            }
        }
        return this.cachedRoutedConnectors[channel];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        if (this.networkId != null) {
            tagCompound.func_74768_a("networkId", this.networkId.getId());
        }
        return super.func_189515_b(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.networkId = tagCompound.func_74764_b("networkId") ? new NetworkId(tagCompound.func_74762_e("networkId")) : null;
    }

    public void writeClientDataToNBT(NBTTagCompound tagCompound) {
        super.writeClientDataToNBT(tagCompound);
        if (!this.func_145831_w().field_72995_K) {
            tagCompound.func_74757_a("error", this.inError());
        }
    }

    public void readClientDataFromNBT(NBTTagCompound tagCompound) {
        super.readClientDataFromNBT(tagCompound);
        this.error = tagCompound.func_74767_n("error");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("colors", this.colors);
        for (int i = 0; i < 8; ++i) {
            if (this.channels[i] == null) continue;
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74778_a("type", this.channels[i].getType().getID());
            this.channels[i].writeToNBT(tc);
            tagCompound.func_74782_a("channel" + i, (NBTBase)tc);
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.colors = tagCompound.func_74762_e("colors");
        for (int i = 0; i < 8; ++i) {
            if (tagCompound.func_74764_b("channel" + i)) {
                NBTTagCompound tc = (NBTTagCompound)tagCompound.func_74781_a("channel" + i);
                String id = tc.func_74779_i("type");
                IChannelType type = XNet.xNetApi.findType(id);
                if (type == null) {
                    XNet.setup.getLogger().warn("Unsupported type " + id + "!");
                    continue;
                }
                this.channels[i] = new ChannelInfo(type);
                this.channels[i].readFromNBT(tc);
                continue;
            }
            this.channels[i] = null;
        }
    }

    @Override
    @Nullable
    public BlockPos findConsumerPosition(@Nonnull ConsumerId consumerId) {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        return this.findConsumerPosition(worldBlob, consumerId);
    }

    @Nullable
    private BlockPos findConsumerPosition(@Nonnull WorldBlob worldBlob, @Nonnull ConsumerId consumerId) {
        return worldBlob.getConsumerPosition(consumerId);
    }

    @Override
    public List<SidedPos> getConnectedBlockPositions() {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        ArrayList<SidedPos> result = new ArrayList<SidedPos>();
        HashSet set = new HashSet();
        Stream<BlockPos> consumers = this.getConsumerStream(worldBlob);
        consumers.forEach(consumerPos -> {
            String name = "";
            TileEntity te = this.func_145831_w().func_175625_s(consumerPos);
            if (te instanceof ConnectorTileEntity) {
                name = ((ConnectorTileEntity)te).getConnectorName();
            } else {
                XNet.setup.getLogger().warn("What? The connector at " + BlockPosTools.toString((BlockPos)consumerPos) + " is not a connector?");
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!ConnectorBlock.isConnectable((IBlockAccess)this.func_145831_w(), consumerPos, facing)) continue;
                BlockPos pos = consumerPos.func_177972_a(facing);
                SidedPos sidedPos = new SidedPos(pos, facing.func_176734_d());
                result.add(sidedPos);
            }
        });
        return result;
    }

    @Nonnull
    private List<ConnectedBlockClientInfo> findConnectedBlocksForClient() {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        HashSet set = new HashSet();
        Stream<BlockPos> consumers = this.getConsumerStream(worldBlob);
        consumers.forEach(consumerPos -> {
            String name = "";
            TileEntity te = this.func_145831_w().func_175625_s(consumerPos);
            if (te instanceof ConnectorTileEntity) {
                name = ((ConnectorTileEntity)te).getConnectorName();
            } else {
                XNet.setup.getLogger().warn("What? The connector at " + BlockPosTools.toString((BlockPos)consumerPos) + " is not a connector?");
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!ConnectorBlock.isConnectable((IBlockAccess)this.func_145831_w(), consumerPos, facing)) continue;
                BlockPos pos = consumerPos.func_177972_a(facing);
                SidedPos sidedPos = new SidedPos(pos, facing.func_176734_d());
                IBlockState state = this.func_145831_w().func_180495_p(pos);
                ItemStack item = state.func_177230_c().func_185473_a(this.func_145831_w(), pos, state);
                ConnectedBlockClientInfo info = new ConnectedBlockClientInfo(sidedPos, item, name);
                set.add(info);
            }
        });
        ArrayList<ConnectedBlockClientInfo> list = new ArrayList<ConnectedBlockClientInfo>(set);
        list.sort(Comparator.comparing(ConnectedBlockClientInfo::getBlockUnlocName).thenComparing(ConnectedBlockClientInfo::getPos));
        return list;
    }

    private Stream<BlockPos> getConsumerStream(WorldBlob worldBlob) {
        return XNet.xNetApi.getConsumerProviders().stream().map(provider -> provider.getConsumers(this.field_145850_b, worldBlob, this.getNetworkId()).stream()).flatMap(s -> s);
    }

    @Nonnull
    private List<ChannelClientInfo> findChannelInfo() {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        ArrayList<ChannelClientInfo> chanList = new ArrayList<ChannelClientInfo>();
        for (ChannelInfo channel : this.channels) {
            if (channel != null) {
                ChannelClientInfo clientInfo = new ChannelClientInfo(channel.getChannelName(), channel.getType(), channel.getChannelSettings(), channel.isEnabled());
                for (Map.Entry<SidedConsumer, ConnectorInfo> entry : channel.getConnectors().entrySet()) {
                    BlockPos consumerPos;
                    SidedConsumer sidedConsumer = entry.getKey();
                    ConnectorInfo info = entry.getValue();
                    if (info.getConnectorSettings() == null || (consumerPos = this.findConsumerPosition(worldBlob, sidedConsumer.getConsumerId())) == null) continue;
                    SidedPos pos = new SidedPos(consumerPos.func_177972_a(sidedConsumer.getSide()), sidedConsumer.getSide().func_176734_d());
                    boolean advanced = this.func_145831_w().func_180495_p(consumerPos).func_177230_c() == NetCableSetup.advancedConnectorBlock;
                    ConnectorClientInfo ci = new ConnectorClientInfo(pos, sidedConsumer.getConsumerId(), channel.getType(), info.getConnectorSettings());
                    clientInfo.getConnectors().put(sidedConsumer, ci);
                }
                chanList.add(clientInfo);
                continue;
            }
            chanList.add(null);
        }
        return chanList;
    }

    private void updateChannel(int channel, TypedMap params) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Key key : params.getKeys()) {
            data.put(key.getName(), params.get(key));
        }
        this.channels[channel].getChannelSettings().update(data);
        Boolean enabled = (Boolean)data.get("enabled");
        this.channels[channel].setEnabled(Boolean.TRUE.equals(enabled));
        String name = (String)data.get("name");
        this.channels[channel].setChannelName(name);
        this.markAsDirty();
    }

    public void markAsDirty() {
        this.networkDirty();
        this.markDirtyQuick();
    }

    private void removeChannel(int channel) {
        this.channels[channel] = null;
        this.cachedConnectors[channel] = null;
        this.cachedRoutedConnectors[channel] = null;
        this.markAsDirty();
    }

    private void createChannel(int channel, String typeId) {
        IChannelType type = XNet.xNetApi.findType(typeId);
        this.channels[channel] = new ChannelInfo(type);
        this.markAsDirty();
    }

    private void updateConnector(int channel, SidedPos pos, TypedMap params) {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        ConsumerId consumerId = worldBlob.getConsumerAt(pos.getPos().func_177972_a(pos.getSide()));
        for (Map.Entry<SidedConsumer, ConnectorInfo> entry : this.channels[channel].getConnectors().entrySet()) {
            SidedConsumer key = entry.getKey();
            if (!key.getConsumerId().equals(consumerId) || !key.getSide().func_176734_d().equals((Object)pos.getSide())) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Key k : params.getKeys()) {
                data.put(k.getName(), params.get(k));
            }
            this.channels[channel].getConnectors().get(key).getConnectorSettings().update(data);
            this.markAsDirty();
            return;
        }
    }

    private void removeConnector(int channel, SidedPos pos) {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        ConsumerId consumerId = worldBlob.getConsumerAt(pos.getPos().func_177972_a(pos.getSide()));
        SidedConsumer toremove = null;
        for (Map.Entry<SidedConsumer, ConnectorInfo> entry : this.channels[channel].getConnectors().entrySet()) {
            SidedConsumer key = entry.getKey();
            if (!key.getSide().func_176734_d().equals((Object)pos.getSide()) || !key.getConsumerId().equals(consumerId)) continue;
            toremove = key;
            break;
        }
        if (toremove != null) {
            this.channels[channel].getConnectors().remove(toremove);
            this.markAsDirty();
        }
    }

    private ConnectorInfo createConnector(int channel, SidedPos pos) {
        BlockPos consumerPos;
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        ConsumerId consumerId = worldBlob.getConsumerAt(consumerPos = pos.getPos().func_177972_a(pos.getSide()));
        if (consumerId == null) {
            throw new RuntimeException("What?");
        }
        SidedConsumer id = new SidedConsumer(consumerId, pos.getSide().func_176734_d());
        boolean advanced = this.func_145831_w().func_180495_p(consumerPos).func_177230_c() == NetCableSetup.advancedConnectorBlock;
        ConnectorInfo info = this.channels[channel].createConnector(id, advanced);
        this.markAsDirty();
        return info;
    }

    private IConnectorSettings findConnectorSettings(ChannelInfo channel, SidedPos p) {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        for (Map.Entry<SidedConsumer, ConnectorInfo> entry : channel.getConnectors().entrySet()) {
            SidedPos pos;
            BlockPos consumerPos;
            SidedConsumer sidedConsumer = entry.getKey();
            ConnectorInfo info = entry.getValue();
            if (info.getConnectorSettings() == null || (consumerPos = this.findConsumerPosition(worldBlob, sidedConsumer.getConsumerId())) == null || !(pos = new SidedPos(consumerPos.func_177972_a(sidedConsumer.getSide()), sidedConsumer.getSide().func_176734_d())).equals(p)) continue;
            return info.getConnectorSettings();
        }
        return null;
    }

    @Nonnull
    private Set<ConnectedBlockInfo> findConnectedBlocks() {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.field_145850_b);
        HashSet<ConnectedBlockInfo> set = new HashSet<ConnectedBlockInfo>();
        Stream<BlockPos> consumers = this.getConsumerStream(worldBlob);
        consumers.forEach(consumerPos -> {
            String name = "";
            TileEntity te = this.field_145850_b.func_175625_s(consumerPos);
            if (te instanceof ConnectorTileEntity) {
                name = ((ConnectorTileEntity)te).getConnectorName();
            } else {
                XNet.setup.getLogger().warn("What? The connector at " + BlockPosTools.toString((BlockPos)consumerPos) + " is not a connector?");
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!ConnectorBlock.isConnectable((IBlockAccess)this.field_145850_b, consumerPos, facing)) continue;
                BlockPos pos = consumerPos.func_177972_a(facing);
                SidedPos sidedPos = new SidedPos(pos, facing.func_176734_d());
                IBlockState state = this.field_145850_b.func_180495_p(pos);
                state = state.func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, pos) ? null : state;
                ConnectedBlockInfo info = new ConnectedBlockInfo(sidedPos, state, name);
                set.add(info);
            }
        });
        return set;
    }

    private void copyConnector(EntityPlayerMP player, int index, SidedPos sidedPos) {
        JsonObject object;
        ChannelInfo channel = this.channels[index];
        IChannelSettings settings = channel.getChannelSettings();
        JsonObject parent = new JsonObject();
        IConnectorSettings connectorSettings = this.findConnectorSettings(channel, sidedPos);
        if (connectorSettings != null && (object = connectorSettings.writeToJson()) != null) {
            parent.add("type", (JsonElement)new JsonPrimitive(channel.getType().getID()));
            parent.add("connector", (JsonElement)object);
            boolean advanced = ConnectorBlock.isAdvancedConnector(this.field_145850_b, sidedPos.getPos().func_177972_a(sidedPos.getSide()));
            parent.add("advanced", (JsonElement)new JsonPrimitive(Boolean.valueOf(advanced)));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((JsonElement)parent);
            XNetMessages.INSTANCE.sendTo((IMessage)new PacketJsonToClipboard(json), player);
            return;
        }
        XNetMessages.INSTANCE.sendTo((IMessage)new PacketControllerError("Error copying connector!"), player);
    }

    private void copyChannel(EntityPlayerMP player, int index) {
        ChannelInfo channel = this.channels[index];
        IChannelSettings settings = channel.getChannelSettings();
        JsonObject parent = new JsonObject();
        JsonObject channelObject = settings.writeToJson();
        if (channelObject != null) {
            parent.add("type", (JsonElement)new JsonPrimitive(channel.getType().getID()));
            parent.add("name", (JsonElement)new JsonPrimitive(channel.getChannelName()));
            parent.add("channel", (JsonElement)channelObject);
            JsonArray connectors = new JsonArray();
            Set<ConnectedBlockInfo> connectedBlocks = this.findConnectedBlocks();
            for (ConnectedBlockInfo connectedBlock : connectedBlocks) {
                JsonObject object;
                SidedPos sidedPos = connectedBlock.getPos();
                IConnectorSettings connectorSettings = this.findConnectorSettings(channel, sidedPos);
                if (connectorSettings == null || (object = connectorSettings.writeToJson()) == null) continue;
                JsonObject connectorObject = new JsonObject();
                connectorObject.add("connector", (JsonElement)object);
                connectorObject.add("name", (JsonElement)new JsonPrimitive(connectedBlock.getName()));
                boolean advanced = ConnectorBlock.isAdvancedConnector(this.field_145850_b, sidedPos.getPos().func_177972_a(sidedPos.getSide()));
                connectorObject.add("advanced", (JsonElement)new JsonPrimitive(Boolean.valueOf(advanced)));
                if (!connectedBlock.isAir()) {
                    IBlockState state = connectedBlock.getConnectedState();
                    connectorObject.add("block", (JsonElement)new JsonPrimitive(state.func_177230_c().getRegistryName().toString()));
                }
                connectors.add((JsonElement)connectorObject);
            }
            parent.add("connectors", (JsonElement)connectors);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((JsonElement)parent);
            XNetMessages.INSTANCE.sendTo((IMessage)new PacketJsonToClipboard(json), player);
        } else {
            XNetMessages.INSTANCE.sendTo((IMessage)new PacketControllerError("Channel does not support this!"), player);
        }
    }

    private int calculateMatchingScore(IChannelType type, ConnectedBlockInfo info, String name, ResourceLocation block, @Nonnull EnumFacing side, @Nonnull EnumFacing facingOverride, boolean advanced, boolean advancedNeeded) {
        ResourceLocation infoBlock;
        EnumFacing facing;
        BlockPos blockPos;
        int score = 0;
        String infoName = info.getName();
        if (!name.isEmpty() && Objects.equals(name, infoName)) {
            score += 100;
        }
        if (!type.supportsBlock(this.field_145850_b, blockPos = info.getPos().getPos(), facing = info.getPos().getSide())) {
            score -= 1000;
        }
        if (!KnownUnsidedBlocks.isUnsided(infoBlock = info.getConnectedState().func_177230_c().getRegistryName()) && !facingOverride.equals((Object)facing)) {
            score -= 1000;
        }
        boolean infoAdvanced = ConnectorBlock.isAdvancedConnector(this.field_145850_b, blockPos.func_177972_a(facing));
        if (advanced) {
            score = infoAdvanced ? (score += 50) : (advancedNeeded ? (score -= 1000) : (score -= 40));
        } else if (infoAdvanced) {
            --score;
        }
        if (!info.isAir() && Objects.equals(infoBlock, block)) {
            score += 200;
        }
        if (facing.equals((Object)side)) {
            score += 2;
        }
        return score;
    }

    private void pasteConnector(EntityPlayerMP player, int channel, SidedPos sidedPos, String json) {
        try {
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(json).getAsJsonObject();
            if (!root.has("connector") || !root.has("type")) {
                XNetMessages.INSTANCE.sendTo((IMessage)new PacketControllerError("Invalid connector json!"), player);
                return;
            }
            String typeId = root.get("type").getAsString();
            IChannelType type = XNet.xNetApi.findType(typeId);
            if (type != this.channels[channel].getType()) {
                XNetMessages.INSTANCE.sendTo((IMessage)new PacketControllerError("Wrong channel type!"), player);
                return;
            }
            boolean advanced = root.get("advanced").getAsBoolean();
            JsonObject connectorObject = root.get("connector").getAsJsonObject();
            boolean advancedNeeded = connectorObject.get("advancedneeded").getAsBoolean();
            BlockPos blockPos = sidedPos.getPos();
            EnumFacing facing = sidedPos.getSide();
            EnumFacing side = EnumFacing.func_176739_a((String)connectorObject.get("side").getAsString());
            EnumFacing facingOverride = connectorObject.has("facingoverride") ? EnumFacing.func_176739_a((String)connectorObject.get("facingoverride").getAsString()) : side;
            boolean infoAdvanced = ConnectorBlock.isAdvancedConnector(this.field_145850_b, blockPos.func_177972_a(facing));
            if (advanced && !infoAdvanced && (advancedNeeded || !facingOverride.equals((Object)facing))) {
                XNetMessages.INSTANCE.sendTo((IMessage)new PacketControllerError("Advanced connector is needed!"), player);
                return;
            }
            if (!infoAdvanced) {
                connectorObject.remove("facingoverride");
            }
            ConnectorInfo info = this.createConnector(channel, sidedPos);
            info.getConnectorSettings().readFromJson(connectorObject);
        }
        catch (JsonSyntaxException e) {
            XNetMessages.INSTANCE.sendTo((IMessage)new PacketControllerError("Error pasting clipboard data!"), player);
        }
        this.markAsDirty();
    }

    private void pasteChannel(EntityPlayerMP player, int channel, String json) {
        try {
            ResourceLocation block;
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(json).getAsJsonObject();
            if (!(root.has("channel") && root.has("type") && root.has("name"))) {
                XNetMessages.INSTANCE.sendTo((IMessage)new PacketControllerError("Invalid channel json!"), player);
                return;
            }
            String typeId = root.get("type").getAsString();
            IChannelType type = XNet.xNetApi.findType(typeId);
            this.channels[channel] = new ChannelInfo(type);
            this.channels[channel].setChannelName(root.get("name").getAsString());
            this.channels[channel].getChannelSettings().readFromJson(root.get("channel").getAsJsonObject());
            this.channels[channel].setEnabled(false);
            Set<ConnectedBlockInfo> connectedBlocks = this.findConnectedBlocks();
            boolean notEnoughConnectors = false;
            JsonArray connectors = root.get("connectors").getAsJsonArray();
            ArrayList<PossibleConnection> connections = new ArrayList<PossibleConnection>();
            for (JsonElement con : connectors) {
                JsonObject connector = con.getAsJsonObject();
                String name = connector.get("name").getAsString();
                boolean advanced = connector.get("advanced").getAsBoolean();
                block = connector.has("block") ? new ResourceLocation(connector.get("block").getAsString()) : null;
                JsonObject connectorSettings = connector.get("connector").getAsJsonObject();
                EnumFacing side = EnumFacing.func_176739_a((String)connectorSettings.get("side").getAsString());
                EnumFacing facingOverride = connectorSettings.has("facingoverride") ? EnumFacing.func_176739_a((String)connectorSettings.get("facingoverride").getAsString()) : side;
                boolean advancedNeeded = connectorSettings.get("advancedneeded").getAsBoolean();
                List<Pair<ConnectedBlockInfo, Integer>> sortedMatches = connectedBlocks.stream().map(info -> Pair.of((Object)info, (Object)this.calculateMatchingScore(type, (ConnectedBlockInfo)info, name, block, side, facingOverride, advanced, advancedNeeded))).sorted((p1, p2) -> Integer.compare((Integer)p2.getRight(), (Integer)p1.getRight())).collect(Collectors.toList());
                if (!sortedMatches.isEmpty() && (Integer)((Pair)sortedMatches.get(0)).getRight() > -50) {
                    connections.add(new PossibleConnection(connector, sortedMatches));
                    continue;
                }
                notEnoughConnectors = true;
            }
            while (!connections.isEmpty()) {
                connections.sort((p1, p2) -> Integer.compare((Integer)((Pair)((PossibleConnection)p2).sortedMatches.get(0)).getRight(), (Integer)((Pair)((PossibleConnection)p1).sortedMatches.get(0)).getRight()));
                PossibleConnection pair = (PossibleConnection)connections.remove(0);
                JsonObject connector = pair.connector;
                if (pair.sortedMatches.isEmpty()) {
                    notEnoughConnectors = true;
                    break;
                }
                ConnectedBlockInfo info2 = (ConnectedBlockInfo)((Pair)pair.sortedMatches.get(0)).getKey();
                boolean infoAdvanced = ConnectorBlock.isAdvancedConnector(this.field_145850_b, info2.getPos().getPos());
                JsonObject connectorSettings = connector.get("connector").getAsJsonObject();
                if (!infoAdvanced) {
                    connectorSettings.remove("facingoverride");
                }
                block = connector.has("block") ? new ResourceLocation(connector.get("block").getAsString()) : null;
                System.out.println("Pasting " + info2.getName() + " (" + block.toString() + " into " + info2.getConnectedState().func_177230_c().getRegistryName().toString() + ") with score = " + ((Pair)pair.sortedMatches.get(0)).getRight());
                ConnectorInfo connectorInfo = this.createConnector(channel, info2.getPos());
                connectorInfo.getConnectorSettings().readFromJson(connectorSettings);
                for (PossibleConnection connection : connections) {
                    ArrayList<Pair> newMatches = new ArrayList<Pair>();
                    for (Pair match : connection.sortedMatches) {
                        if (match.getLeft() == info2) continue;
                        newMatches.add(match);
                    }
                    connection.sortedMatches = newMatches;
                }
            }
            if (notEnoughConnectors) {
                XNetMessages.INSTANCE.sendTo((IMessage)new PacketControllerError("Not everything could be pasted!"), player);
            }
        }
        catch (JsonSyntaxException e) {
            XNetMessages.INSTANCE.sendTo((IMessage)new PacketControllerError("Error pasting clipboard data!"), player);
        }
        this.markAsDirty();
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_CREATECHANNEL.equals(command)) {
            int index = (Integer)params.get(PARAM_INDEX);
            String typeId = (String)params.get(PARAM_TYPE);
            this.createChannel(index, typeId);
            return true;
        }
        if (CMD_PASTECHANNEL.equals(command)) {
            int index = (Integer)params.get(PARAM_INDEX);
            String json = (String)params.get(PARAM_JSON);
            this.pasteChannel(playerMP, index, json);
            return true;
        }
        if (CMD_PASTECONNECTOR.equals(command)) {
            int index = (Integer)params.get(PARAM_INDEX);
            SidedPos pos = new SidedPos((BlockPos)params.get(PARAM_POS), EnumFacing.field_82609_l[(Integer)params.get(PARAM_SIDE)]);
            String json = (String)params.get(PARAM_JSON);
            this.pasteConnector(playerMP, index, pos, json);
            return true;
        }
        if (CMD_COPYCHANNEL.equals(command)) {
            int index = (Integer)params.get(PARAM_INDEX);
            this.copyChannel(playerMP, index);
            return true;
        }
        if (CMD_COPYCONNECTOR.equals(command)) {
            int index = (Integer)params.get(PARAM_INDEX);
            SidedPos pos = new SidedPos((BlockPos)params.get(PARAM_POS), EnumFacing.field_82609_l[(Integer)params.get(PARAM_SIDE)]);
            this.copyConnector(playerMP, index, pos);
            return true;
        }
        if (CMD_CREATECONNECTOR.equals(command)) {
            int channel = (Integer)params.get(PARAM_CHANNEL);
            SidedPos pos = new SidedPos((BlockPos)params.get(PARAM_POS), EnumFacing.field_82609_l[(Integer)params.get(PARAM_SIDE)]);
            this.createConnector(channel, pos);
            return true;
        }
        if (CMD_REMOVECHANNEL.equals(command)) {
            int index = (Integer)params.get(PARAM_INDEX);
            this.removeChannel(index);
            return true;
        }
        if (CMD_REMOVECONNECTOR.equals(command)) {
            SidedPos pos = new SidedPos((BlockPos)params.get(PARAM_POS), EnumFacing.field_82609_l[(Integer)params.get(PARAM_SIDE)]);
            int channel = (Integer)params.get(PARAM_CHANNEL);
            this.removeConnector(channel, pos);
            return true;
        }
        if (CMD_UPDATECONNECTOR.equals(command)) {
            SidedPos pos = new SidedPos((BlockPos)params.get(PARAM_POS), EnumFacing.field_82609_l[(Integer)params.get(PARAM_SIDE)]);
            int channel = (Integer)params.get(PARAM_CHANNEL);
            this.updateConnector(channel, pos, params);
            return true;
        }
        if (CMD_UPDATECHANNEL.equals(command)) {
            int channel = (Integer)params.get(PARAM_CHANNEL);
            this.updateChannel(channel, params);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if (CMD_GETCHANNELS.equals(command)) {
            return type.convert(this.findChannelInfo());
        }
        if (CMD_GETCONNECTEDBLOCKS.equals(command)) {
            return type.convert(this.findConnectedBlocksForClient());
        }
        return Collections.emptyList();
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if (CLIENTCMD_CHANNELSREADY.equals(command)) {
            GuiController.fromServer_channels = new ArrayList<ChannelClientInfo>(Type.create(ChannelClientInfo.class).convert(list));
            return true;
        }
        if (CLIENTCMD_CONNECTEDBLOCKSREADY.equals(command)) {
            GuiController.fromServer_connectedBlocks = new ArrayList<ConnectedBlockClientInfo>(Type.create(ConnectedBlockClientInfo.class).convert(list));
            return true;
        }
        return false;
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        this.findNeighbourConnector(world, pos);
    }

    public void onBlockBreak(World world, BlockPos pos, IBlockState state) {
        super.onBlockBreak(world, pos, state);
        XNetBlobData blobData = XNetBlobData.getBlobData(this.field_145850_b);
        WorldBlob worldBlob = blobData.getWorldBlob(this.field_145850_b);
        worldBlob.removeCableSegment(pos);
        blobData.save();
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        WorldBlob worldBlob = XNetBlobData.getBlobData(world).getWorldBlob(world);
        NetworkId networkId = this.getNetworkId();
        if (networkId != null) {
            if (mode == ProbeMode.DEBUG) {
                probeInfo.text(TextStyleClass.LABEL + "Network: " + TextStyleClass.INFO + networkId.getId() + ", V: " + worldBlob.getNetworkVersion(networkId));
            } else {
                probeInfo.text(TextStyleClass.LABEL + "Network: " + TextStyleClass.INFO + networkId.getId());
            }
        }
        if (mode == ProbeMode.DEBUG) {
            String s = "";
            for (NetworkId id : this.getNetworkChecker().getAffectedNetworks()) {
                if ((s = s + id.getId() + " ").length() <= 15) continue;
                probeInfo.text(TextStyleClass.LABEL + "InfNet: " + TextStyleClass.INFO + s);
                s = "";
            }
            if (!s.isEmpty()) {
                probeInfo.text(TextStyleClass.LABEL + "InfNet: " + TextStyleClass.INFO + s);
            }
        }
        if (this.inError()) {
            probeInfo.text(TextStyleClass.ERROR + "Too many controllers on network!");
        }
        if (mode == ProbeMode.DEBUG) {
            ColorId colorId;
            BlobId blobId = worldBlob.getBlobAt(data.getPos());
            if (blobId != null) {
                probeInfo.text(TextStyleClass.LABEL + "Blob: " + TextStyleClass.INFO + blobId.getId());
            }
            if ((colorId = worldBlob.getColorAt(data.getPos())) != null) {
                probeInfo.text(TextStyleClass.LABEL + "Color: " + TextStyleClass.INFO + colorId.getId());
            }
            probeInfo.text(TextStyleClass.LABEL + "Color mask: " + this.colors);
        }
    }

    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a((IProperty)ERROR, (Comparable)Boolean.valueOf(this.inError()));
    }

    public void checkRedstone(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            this.findNeighbourConnector(world, pos);
        }
    }

    private void findNeighbourConnector(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        XNetBlobData blobData = XNetBlobData.getBlobData(world);
        WorldBlob worldBlob = blobData.getWorldBlob(world);
        ColorId oldColor = worldBlob.getColorAt(pos);
        ColorId newColor = null;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            ColorId color;
            if (!(world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() instanceof ConnectorBlock) || (color = worldBlob.getColorAt(pos.func_177972_a(facing))) == null) continue;
            if (color == oldColor) {
                return;
            }
            newColor = color;
        }
        if (newColor != null) {
            if (worldBlob.getBlobAt(pos) != null) {
                worldBlob.removeCableSegment(pos);
            }
            NetworkId networkId = worldBlob.newNetwork();
            worldBlob.createNetworkProvider(pos, newColor, networkId);
            blobData.save();
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityController) {
                ((TileEntityController)te).setNetworkId(networkId);
            }
        }
    }

    private static class PossibleConnection {
        private final JsonObject connector;
        private List<Pair<ConnectedBlockInfo, Integer>> sortedMatches;

        public PossibleConnection(JsonObject connector, List<Pair<ConnectedBlockInfo, Integer>> sortedMatches) {
            this.connector = connector;
            this.sortedMatches = sortedMatches;
        }
    }
}

