/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import twilightforest.TFConfig;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.world.ChunkGeneratorTFBase;
import twilightforest.world.WorldProviderTwilightForest;

public class TFWorld {
    public static final int SEALEVEL = 31;
    public static final int CHUNKHEIGHT = 256;
    public static final int MAXHEIGHT = 256;

    @Nullable
    public static ChunkGeneratorTFBase getChunkGenerator(World world) {
        if (world instanceof WorldServer) {
            IChunkGenerator chunkGenerator = ((WorldServer)world).func_72863_F().field_186029_c;
            return chunkGenerator instanceof ChunkGeneratorTFBase ? (ChunkGeneratorTFBase)chunkGenerator : null;
        }
        return null;
    }

    public static boolean isTwilightForest(World world) {
        return world.field_73011_w instanceof WorldProviderTwilightForest;
    }

    public static NBTTagCompound getDimensionData(World world) {
        return world.func_72912_H().getDimensionData(TFConfig.dimension.dimensionID);
    }

    public static void setDimensionData(World world, NBTTagCompound data) {
        world.func_72912_H().setDimensionData(TFConfig.dimension.dimensionID, data);
    }

    public static boolean isProgressionEnforced(World world) {
        return world.func_82736_K().func_82766_b("tfEnforcedProgression");
    }

    public static boolean isBiomeSafeFor(Biome biome, Entity entity) {
        if (biome instanceof TFBiomeBase && entity instanceof EntityPlayer) {
            return ((TFBiomeBase)biome).doesPlayerHaveRequiredAdvancements((EntityPlayer)entity);
        }
        return true;
    }

    public static void markStructureConquered(World world, BlockPos pos, TFFeature feature) {
        ChunkGeneratorTFBase generator = TFWorld.getChunkGenerator(world);
        if (generator != null && TFFeature.getFeatureAt(pos.func_177958_n(), pos.func_177952_p(), world) == feature) {
            generator.setStructureConquered(pos, true);
        }
    }

    public static int getGroundLevel(World world, int x, int z) {
        return TFWorld.getGroundLevel(world, x, z, block -> false);
    }

    public static int getGroundLevel(World world, int x, int z, Predicate<Block> extraBlocks) {
        Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int lastDirt = 31;
        for (int y = 31; y < 255; ++y) {
            Block block = chunk.func_177435_g((BlockPos)pos.func_181079_c(x, y, z)).func_177230_c();
            if (block == Blocks.field_150349_c) {
                return y + 1;
            }
            if (block != Blocks.field_150346_d && block != Blocks.field_150348_b && block != Blocks.field_150351_n && !extraBlocks.test(block)) continue;
            lastDirt = y + 1;
        }
        return lastDirt;
    }
}

