/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.github.opencubicchunks.cubicchunks.api.world.ICubicWorld;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.IFluidBlock;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.registry.ModBlocks;

public class SpawnHelper {
    private final WorldServer world;
    private BlockPos initPos;
    private List<BlockPos> positions;
    private final CacheLoader<BlockPos, PlaceType> loader = new CacheLoader<BlockPos, PlaceType>(){

        public PlaceType load(BlockPos pos) {
            return SpawnHelper.this.getPathNodeTypeRaw(SpawnHelper.this.world, pos);
        }
    };
    private final LoadingCache<BlockPos, PlaceType> spawnPlaces = CacheBuilder.newBuilder().maximumSize(2052L).build(this.loader);
    private final Map<IBlockState, PlaceType> knownStates = new HashMap<IBlockState, PlaceType>();
    private BlockPos spawnPos = null;
    private SpawnResult spawnType = SpawnResult.NONE;
    private final boolean isWaterWorld;
    private final boolean isCubicWorld;
    private final boolean isBelowBedRock;
    private ConfigTombstone.CatClient.GraveSpawnRule graveSpawnRule = ConfigTombstone.CatClient.GraveSpawnRule.getDefault();
    private int move = 0;
    private static final Material[] UNSAFE_MATERIAL = new Material[]{Material.field_151587_i, Material.field_151581_o, Material.field_151567_E, Material.field_151570_A, Material.field_175972_I, Material.field_151590_u, Material.field_151569_G};
    private static final Material[] GROUND_MATERIAL = new Material[]{Material.field_151584_j, Material.field_151593_r, Material.field_151597_y, Material.field_151578_c, Material.field_151588_w};

    public SpawnHelper(WorldServer world, BlockPos initPos) {
        this(world, initPos, true);
    }

    public SpawnHelper(WorldServer world, BlockPos initPos, boolean generate) {
        this.world = world;
        this.initPos = Helper.getCloserValidPos((World)world, initPos);
        if (generate && !world.func_190526_b(initPos.func_177958_n(), initPos.func_177952_p())) {
            SpawnHelper.generateChunk(world, initPos);
        }
        this.isCubicWorld = SupportMods.CUBIC_CHUNKS.isLoaded() && ((ICubicWorld)world).isCubicWorld();
        this.isWaterWorld = SupportMods.CAVERN.isLoaded() && world.field_73011_w.func_186058_p().func_186065_b().equals("aqua_cavern");
        this.isBelowBedRock = SupportMods.FUTURE_PACK.isLoaded() && world.field_73011_w.func_186058_p().func_186065_b().equals("belowbedrock");
    }

    public SpawnHelper withGraveSpawnRule(ConfigTombstone.CatClient.GraveSpawnRule graveSpawnRule) {
        this.graveSpawnRule = graveSpawnRule;
        return this;
    }

    public Location findSafePlace(int range, boolean withHeight, boolean playerPlace) {
        Iterable it = BlockPos.func_177980_a((BlockPos)this.initPos.func_177982_a(-range, withHeight ? -range : 0, -range), (BlockPos)this.initPos.func_177982_a(range, withHeight ? range : 0, range));
        this.positions = StreamSupport.stream(it.spliterator(), false).collect(Collectors.toList());
        this.positions.sort(Comparator.comparingDouble(pos0 -> pos0.func_177951_i((Vec3i)this.initPos)));
        for (BlockPos currentPos : this.positions) {
            if (!(playerPlace ? this.isIdealSpawnPlace(currentPos) : this.isSafePlace(currentPos))) continue;
            return new Location(currentPos, (World)this.world);
        }
        return Location.ORIGIN;
    }

    public Location findStructurePlace(SupportStructures struct) {
        this.initPos = new BlockPos(this.initPos.func_177958_n(), struct.getY(), this.initPos.func_177952_p());
        return this.findSpawnPlace(PlacementType.SPAWN_STRUCTURE);
    }

    private boolean containLiquid(IBlockState state) {
        return state.func_185904_a().func_76224_d() || state.func_177230_c() instanceof IFluidBlock;
    }

    public Location findSpawnPlace() {
        return this.findSpawnPlace(PlacementType.SPAWN_PLACE);
    }

    public Location findGravePlace() {
        return this.findSpawnPlace(PlacementType.SPAWN_GRAVE);
    }

    public Pair<Location, SpawnResult> findGravePlaceWithResult() {
        return Pair.of((Object)this.findSpawnPlace(PlacementType.SPAWN_GRAVE), (Object)((Object)this.spawnType));
    }

    private BlockPos getInitPosInFluid(PlacementType placementType) {
        if (this.isWaterWorld) {
            return this.initPos;
        }
        BlockPos adjustedPos = this.initPos;
        IBlockState state = this.world.func_180495_p(adjustedPos);
        boolean hasFluid = this.containLiquid(state);
        if (!hasFluid && !this.world.func_189509_E(adjustedPos = this.initPos.func_177984_a())) {
            state = this.world.func_180495_p(adjustedPos);
            hasFluid = this.containLiquid(state);
        }
        if (!hasFluid || state.func_185904_a() == Material.field_151586_h && !placementType.isGrave()) {
            return this.initPos;
        }
        while (!this.containLiquid(this.world.func_180495_p(adjustedPos))) {
            if (!this.world.func_189509_E(adjustedPos = adjustedPos.func_177984_a()) && (!this.isCubicWorld || adjustedPos.func_177956_o() - this.initPos.func_177956_o() <= 300)) continue;
            return this.initPos;
        }
        return adjustedPos;
    }

    private Location findSpawnPlace(PlacementType placementType) {
        int minY;
        int maxY;
        boolean wasInLiquid;
        Predicate<BlockPos> predicPos;
        Predicate<BlockPos> predicate = predicPos = placementType.isGrave() ? this::isIdealGravePlace : this::isIdealSpawnPlace;
        if (predicPos.test(this.initPos)) {
            return new Location(this.initPos, (World)this.world);
        }
        this.initChunkPositions();
        BlockPos adjustedPos = this.getInitPosInFluid(placementType);
        boolean bl = wasInLiquid = !adjustedPos.equals((Object)this.initPos);
        if (placementType.isGrave()) {
            maxY = !this.isCubicWorld ? (this.isBelowBedRock ? 256 : this.world.field_73011_w.getActualHeight()) : adjustedPos.func_177956_o() + 300;
            minY = !this.isCubicWorld ? 0 : adjustedPos.func_177956_o() - 300;
        } else {
            int borne;
            int n = borne = placementType.isSpawn() ? 70 : 16;
            maxY = !this.isCubicWorld ? Math.min(adjustedPos.func_177956_o() + borne, this.isBelowBedRock ? 256 : this.world.field_73011_w.getActualHeight()) : adjustedPos.func_177956_o() + borne;
            minY = !this.isCubicWorld ? Math.max(adjustedPos.func_177956_o() - borne, 0) : adjustedPos.func_177956_o() - borne;
        }
        int yUp = adjustedPos.func_177956_o();
        int yDown = yUp - 1;
        boolean canGoDown = true;
        boolean canGoUp = true;
        this.move = 0;
        while (canGoUp || canGoDown) {
            canGoUp = yUp < maxY;
            canGoDown = !wasInLiquid && yDown > minY;
            for (BlockPos pos : this.positions) {
                BlockPos currentPos;
                if (canGoUp && predicPos.test(currentPos = new BlockPos(pos.func_177958_n(), yUp, pos.func_177952_p()))) {
                    return new Location(this.spawnPos, (World)this.world);
                }
                if (!canGoDown || !predicPos.test(currentPos = new BlockPos(pos.func_177958_n(), yDown, pos.func_177952_p()))) continue;
                return new Location(this.spawnPos, (World)this.world);
            }
            ++yUp;
            --yDown;
            ++this.move;
        }
        return placementType.isGrave() && SpawnResult.MINIMAL.hasPattern(this.spawnType) ? new Location(this.spawnPos, (World)this.world) : Location.ORIGIN;
    }

    private boolean isIdealSpawnPlace(BlockPos pos) {
        if (this.isSafeGround(pos.func_177977_b()) && this.isSafePlace(pos) && this.isSafePlace(pos.func_177984_a())) {
            this.setTypeAndPosition(SpawnResult.IDEAL, pos);
            return true;
        }
        return false;
    }

    private boolean isIdealGravePlace(BlockPos pos) {
        if (this.isGravePlace(pos)) {
            SpawnResult type = this.isSafeGround(pos.func_177977_b()) ? (this.isSafePlace(pos.func_177984_a()) ? (this.isSafePlace(pos.func_177981_b(2)) ? SpawnResult.IDEAL : SpawnResult.FIT) : SpawnResult.NORMAL) : SpawnResult.MINIMAL;
            this.setTypeAndPosition(type, pos);
            if (this.graveSpawnRule == ConfigTombstone.CatClient.GraveSpawnRule.SAFER) {
                return type == SpawnResult.IDEAL;
            }
            if (this.graveSpawnRule == ConfigTombstone.CatClient.GraveSpawnRule.NEAREST) {
                return SpawnResult.MINIMAL.hasPattern(type);
            }
            return this.move > 70 ? SpawnResult.NORMAL.hasPattern(type) : type == SpawnResult.IDEAL;
        }
        return false;
    }

    private boolean isGravePlace(BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        Material mat = state.func_185904_a();
        return (mat == Material.field_151579_a || mat == Material.field_151597_y || mat == Material.field_151581_o || this.isWaterWorld && mat == Material.field_151586_h) && this.world.func_175625_s(pos) == null;
    }

    private boolean isSafeGround(BlockPos pos) {
        PlaceType placeType = this.getPlaceType(pos);
        return placeType.isGround() || placeType.isWater();
    }

    private boolean isSafePlace(BlockPos pos) {
        PlaceType placeType = this.getPlaceType(pos);
        return placeType.isSafe() || placeType.isWater();
    }

    private void setTypeAndPosition(SpawnResult type, BlockPos pos) {
        if (type.ordinal() > this.spawnType.ordinal()) {
            this.spawnType = type;
            this.spawnPos = pos;
        }
    }

    private PlaceType getPlaceType(BlockPos pos) {
        return (PlaceType)((Object)this.spawnPlaces.getUnchecked((Object)pos));
    }

    private static void generateChunk(WorldServer world, BlockPos initPos) {
        ChunkPos chunkPos = new ChunkPos(initPos);
        for (int x = chunkPos.field_77276_a - 1; x <= chunkPos.field_77276_a + 1; ++x) {
            for (int z = chunkPos.field_77275_b - 1; z <= chunkPos.field_77275_b + 1; ++z) {
                ChunkPos currentChunk = new ChunkPos(x, z);
                world.func_180495_p(currentChunk.func_180331_a(0, 0, 0));
            }
        }
    }

    private void initChunkPositions() {
        ChunkPos chunkPos = new ChunkPos(this.initPos);
        this.spawnPos = null;
        this.spawnType = SpawnResult.NONE;
        Iterable it = BlockPos.func_177980_a((BlockPos)new BlockPos(chunkPos.func_180334_c(), 0, chunkPos.func_180333_d()), (BlockPos)new BlockPos(chunkPos.func_180332_e(), 0, chunkPos.func_180330_f()));
        this.positions = StreamSupport.stream(it.spliterator(), false).collect(Collectors.toList());
        this.positions.sort((pos0, pos1) -> {
            double dist0 = pos0.func_177954_c((double)this.initPos.func_177958_n(), 0.0, (double)this.initPos.func_177952_p());
            double dist1 = pos1.func_177954_c((double)this.initPos.func_177958_n(), 0.0, (double)this.initPos.func_177952_p());
            return Double.compare(dist0, dist1);
        });
    }

    private PlaceType getPathNodeTypeRaw(WorldServer world, BlockPos pos) {
        if (!world.func_175723_af().func_177746_a(pos)) {
            return PlaceType.UNSAFE;
        }
        return this.knownStates.computeIfAbsent(world.func_180495_p(pos), state -> this.getPathNodeTypeRaw(world, pos, (IBlockState)state));
    }

    private PlaceType getPathNodeTypeRaw(WorldServer world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        PathNodeType type = block.getAiPathNodeType(state, (IBlockAccess)world, pos);
        if (type != null) {
            switch (type) {
                case OPEN: {
                    return PlaceType.SAFE;
                }
                case BLOCKED: 
                case WALKABLE: {
                    return PlaceType.GROUND;
                }
                case WATER: {
                    return PlaceType.WATER;
                }
            }
            return PlaceType.UNSAFE;
        }
        Material mat = state.func_185904_a();
        if (Arrays.stream(UNSAFE_MATERIAL).anyMatch(m -> m == mat) || block == Blocks.field_189877_df) {
            return PlaceType.UNSAFE;
        }
        if (this.containLiquid(state)) {
            return mat == Material.field_151586_h && state.func_185890_d((IBlockAccess)world, pos) == null ? PlaceType.WATER : PlaceType.UNSAFE;
        }
        if (mat == Material.field_151579_a) {
            return PlaceType.SAFE;
        }
        if (Arrays.stream(GROUND_MATERIAL).anyMatch(m -> m == mat)) {
            return PlaceType.GROUND;
        }
        if (state.func_185890_d((IBlockAccess)world, pos) == null) {
            return PlaceType.SAFE;
        }
        if (block.func_176205_b((IBlockAccess)world, pos)) {
            return block == Blocks.field_150392_bi ? PlaceType.GROUND : PlaceType.UNSAFE;
        }
        if (state.func_185917_h()) {
            return PlaceType.GROUND;
        }
        if (block instanceof BlockSlab || block instanceof BlockStairs || block instanceof BlockWall || block instanceof BlockBed || ModBlocks.isAnyGrave(block)) {
            return PlaceType.GROUND;
        }
        return PlaceType.UNSAFE;
    }

    public static enum SpawnResult {
        NONE,
        MINIMAL,
        NORMAL,
        FIT,
        IDEAL;


        public boolean hasPattern(SpawnResult actualPattern) {
            return this.ordinal() <= actualPattern.ordinal();
        }
    }

    private static enum PlacementType {
        SPAWN_PLACE,
        SPAWN_GRAVE,
        SPAWN_STRUCTURE;


        public boolean isSpawn() {
            return this == SPAWN_PLACE;
        }

        public boolean isGrave() {
            return this == SPAWN_GRAVE;
        }

        public boolean isStructure() {
            return this == SPAWN_STRUCTURE;
        }
    }

    private static enum PlaceType {
        SAFE,
        GROUND,
        UNSAFE,
        WATER;


        public boolean isSafe() {
            return this == SAFE;
        }

        public boolean isGround() {
            return this == GROUND;
        }

        public boolean isWater() {
            return this == WATER;
        }
    }
}

